/*
 * Decompiled with CFR 0.152.
 */
package mpjbuf;

import java.util.ArrayList;
import mpjbuf.Buddy2Buffer;
import mpjbuf.Buddy2FreeList;
import mpjbuf.Buddy2Region;
import mpjbuf.BufferConstants;
import mpjbuf.BufferFactory;
import mpjbuf.CustomMath;
import mpjbuf.RawBuffer;
import org.apache.log4j.Logger;

public class Buddy2BufferFactory
extends BufferFactory {
    private ArrayList<Buddy2Region> regionLists = new ArrayList();
    static Logger logger = Logger.getLogger((String)"mpj");

    @Override
    public synchronized void init() {
        Buddy2Region region = new Buddy2Region(BufferConstants.DEFAULT_REGION_SIZE);
        this.regionLists.add(region);
    }

    @Override
    public synchronized void finalixe() {
        Buddy2Buffer current = null;
        for (Buddy2Region reg : this.regionLists) {
            int numLevels = reg.freeLists.size();
            for (int l = 0; l < numLevels; ++l) {
                Buddy2FreeList fList = reg.freeLists.get(l);
                if (!fList.isEmpty()) {
                    current = fList.head;
                    do {
                        current.free();
                    } while ((current = current.prev) != fList.head);
                }
                fList = null;
            }
            reg.buffer = null;
            Object var3_3 = null;
        }
        this.regionLists = null;
    }

    Buddy2Buffer findInAllRegions(int level) {
        Buddy2Buffer freeBuffer = null;
        block0: for (Buddy2Region reg : this.regionLists) {
            int numLevels = reg.freeLists.size();
            if (level >= numLevels) continue;
            for (int l = level; l < numLevels; ++l) {
                Buddy2FreeList freeList = reg.freeLists.get(l);
                if (freeList.isEmpty() || freeList.head == null) continue;
                Buddy2Buffer current = freeList.head;
                do {
                    if (!current.free) continue;
                    freeBuffer = current;
                    break block0;
                } while ((current = current.prev) != freeList.head);
            }
        }
        return freeBuffer;
    }

    Buddy2Buffer find(Buddy2Region inRegion, int level) {
        Buddy2Buffer freeBuffer = null;
        int numLevels = inRegion.freeLists.size();
        if (level < numLevels) {
            block0: for (int l = level; l < numLevels; ++l) {
                Buddy2FreeList freeList = inRegion.freeLists.get(l);
                if (freeList.isEmpty() || freeList.head == null) continue;
                Buddy2Buffer current = freeList.head;
                do {
                    if (!current.free) continue;
                    freeBuffer = current;
                    break block0;
                } while ((current = current.prev) != freeList.tail);
            }
        }
        return freeBuffer;
    }

    @Override
    public synchronized RawBuffer createBuffer(int size) {
        if (size == 0) {
            return null;
        }
        int numChunks = (size + BufferConstants.CHUNK_SIZE - 1) / BufferConstants.CHUNK_SIZE;
        int level = CustomMath.widthInBits(numChunks - 1);
        Buddy2Buffer freeNode = this.findInAllRegions(level);
        if (freeNode == null) {
            int newRegionSize;
            block5: {
                newRegionSize = -1;
                if (size > BufferConstants.DEFAULT_REGION_SIZE) {
                    int h = 2;
                    while (true) {
                        if (size < BufferConstants.DEFAULT_REGION_SIZE * h) {
                            newRegionSize = BufferConstants.DEFAULT_REGION_SIZE * h;
                            break block5;
                        }
                        h *= 2;
                    }
                }
                newRegionSize = BufferConstants.DEFAULT_REGION_SIZE;
            }
            Buddy2Region reg = new Buddy2Region(newRegionSize);
            this.regionLists.add(reg);
            freeNode = this.find(reg, level);
        }
        Buddy2Buffer output = this.block(freeNode, freeNode.region, level);
        return output;
    }

    private Buddy2Buffer block(Buddy2Buffer freeBuffer, Buddy2Region region, int level) {
        int l = freeBuffer.level;
        Buddy2Buffer buddy = null;
        if (level == l) {
            freeBuffer.free = false;
            return freeBuffer;
        }
        region.freeLists.get(l).remove(freeBuffer);
        --l;
        while (l >= level) {
            int childCap = freeBuffer.capacity / 2;
            region.buffer.position(freeBuffer.realOffset);
            region.buffer.limit(freeBuffer.realOffset + childCap);
            freeBuffer = new Buddy2Buffer(region.buffer.slice(), 0, childCap, l, region, freeBuffer.realOffset);
            region.buffer.position(freeBuffer.realOffset + childCap);
            region.buffer.limit(freeBuffer.realOffset + 2 * childCap);
            buddy = new Buddy2Buffer(region.buffer.slice(), 0, childCap, l, region, freeBuffer.realOffset + childCap);
            region.buffer.clear();
            region.freeLists.get(l).add(buddy);
            if (l == level) {
                region.freeLists.get(l).add(freeBuffer);
            }
            --l;
        }
        freeBuffer.free = false;
        return freeBuffer;
    }

    private Buddy2Buffer calculateBuddy(Buddy2Buffer buffer) {
        Buddy2FreeList fList = buffer.region.freeLists.get(buffer.level);
        int buddyOffset = buffer.realOffset ^ BufferConstants.CHUNK_SIZE << buffer.level;
        Buddy2Buffer current = fList.head;
        Buddy2Buffer buddy = null;
        do {
            if (current.realOffset != buddyOffset) continue;
            if (!current.free) break;
            buddy = current;
            break;
        } while ((current = current.prev) != fList.head);
        return buddy;
    }

    @Override
    public synchronized void destroyBuffer(RawBuffer buffer) {
        Buddy2Buffer buf = (Buddy2Buffer)buffer;
        Buddy2Buffer buddy = this.calculateBuddy(buf);
        if (buddy == null) {
            buf.free = true;
            try {
                buf.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        int numLevels = buf.region.freeLists.size();
        int level = buf.level;
        while (buddy != null) {
            Buddy2FreeList topLevelList;
            Buddy2FreeList fList = buf.region.freeLists.get(level);
            if (buf.region.freeLists.size() == level + 1) {
                topLevelList = new Buddy2FreeList();
                buf.region.freeLists.add(topLevelList);
            } else {
                topLevelList = buf.region.freeLists.get(level + 1);
            }
            int parentOffset = -1;
            parentOffset = buddy.realOffset > buf.realOffset ? buf.realOffset : buddy.realOffset;
            int parentbufoffset = 0;
            try {
                buf.clear();
                buf.free = false;
                buddy.clear();
                buddy.free = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fList.remove(buddy);
            fList.remove(buf);
            buf.region.buffer.position(parentOffset);
            buf.region.buffer.limit(parentOffset + buf.capacity * 2);
            buf = new Buddy2Buffer(buf.region.buffer.slice(), parentbufoffset, buf.capacity * 2, level + 1, buf.region, parentOffset);
            topLevelList.add(buf);
            buf.region.buffer.clear();
            buddy = this.calculateBuddy(buf);
            ++level;
        }
    }
}

