/*
 * Decompiled with CFR 0.152.
 */
package mpjbuf;

import java.nio.ByteBuffer;
import mpjbuf.Buddy1FreeList;

public class Buddy1RegionFreeList {
    ByteBuffer memory;
    Buddy1FreeList globalFreeList;
    Buddy1RegionFreeList prevList;
    Buddy1RegionFreeList nextList;
    int front;
    int level;
    int blockSize;
    Buddy1RegionFreeList up;
    Buddy1RegionFreeList down;

    Buddy1RegionFreeList(int level, int blockSize, ByteBuffer memory, Buddy1FreeList globalFreeList) {
        this.level = level;
        this.blockSize = blockSize;
        this.memory = memory;
        this.globalFreeList = globalFreeList;
        this.front = -1;
    }

    void add(int position) {
        if (this.front == -1) {
            this.memory.position(position + 5);
            this.memory.putInt(-1);
            this.memory.position(position + 1);
            this.memory.putInt(-1);
            this.front = position;
            this.globalFreeList.add(this);
        } else {
            this.memory.position(position + 5);
            this.memory.putInt(this.front);
            this.memory.position(position + 1);
            this.memory.putInt(-1);
            this.memory.position(this.front + 1);
            this.memory.putInt(position);
            this.front = position;
        }
    }

    void remove(int position) {
        this.memory.position(position + 1);
        int prev = this.memory.getInt();
        this.memory.position(position + 5);
        int next = this.memory.getInt();
        if (prev == -1) {
            this.front = next;
        } else {
            this.memory.position(prev + 5);
            this.memory.putInt(next);
        }
        if (next != -1) {
            this.memory.position(next + 1);
            this.memory.putInt(prev);
        }
        if (this.front == -1) {
            this.globalFreeList.remove(this);
        }
    }

    void removeFront() {
        this.memory.clear();
        this.memory.position(this.front + 5);
        this.front = this.memory.getInt();
        if (this.front == -1) {
            this.globalFreeList.remove(this);
        } else {
            this.memory.position(this.front + 1);
            this.memory.putInt(-1);
        }
    }
}

