/*
 * Decompiled with CFR 0.152.
 */
package mpjbuf;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import mpjbuf.Buddy1Buffer;
import mpjbuf.Buddy1FreeList;
import mpjbuf.Buddy1RegionFreeList;
import mpjbuf.BufferConstants;
import mpjbuf.BufferFactory;
import mpjbuf.CustomMath;
import mpjbuf.RawBuffer;
import org.apache.log4j.Logger;

public class Buddy1BufferFactory
extends BufferFactory {
    static Logger logger = Logger.getLogger((String)"mpj");
    private ArrayList<Buddy1FreeList> freeLists = new ArrayList();

    @Override
    public synchronized void init() {
    }

    @Override
    public synchronized RawBuffer createBuffer(int size) {
        Buddy1RegionFreeList list;
        int level;
        block5: {
            if (size == 0) {
                return null;
            }
            int numChunks = (size + 1 + BufferConstants.CHUNK_SIZE - 1) / BufferConstants.CHUNK_SIZE;
            level = CustomMath.widthInBits(numChunks - 1);
            int numLevels = this.freeLists.size();
            for (int l = level; l < numLevels; ++l) {
                list = this.freeLists.get(l).getFront();
                if (list == null) {
                    continue;
                }
                break block5;
            }
            int newNumLevels = BufferConstants.INIT_NUM_LEVELS;
            if (numLevels + 1 > newNumLevels) {
                newNumLevels = numLevels + 1;
            }
            if (level + 1 > newNumLevels) {
                newNumLevels = level + 1;
            }
            list = this.initializeRegion(newNumLevels);
        }
        return this.allocate(level, list);
    }

    @Override
    public synchronized void destroyBuffer(RawBuffer buffer) {
        this.free((Buddy1Buffer)buffer);
    }

    private Buddy1Buffer allocate(int level, Buddy1RegionFreeList list) {
        int position = list.front;
        list.removeFront();
        while (list.level > level) {
            list = list.down;
            list.memory.position(position ^ list.blockSize);
            list.memory.put((byte)list.level);
            list.add(position ^ list.blockSize);
        }
        int cap = BufferConstants.CHUNK_SIZE << level;
        list.memory.position(position);
        list.memory.put((byte)-1);
        list.memory.position(position + 1);
        list.memory.limit(cap + position);
        ByteBuffer slicedBuffer = list.memory.slice();
        return new Buddy1Buffer(slicedBuffer, cap, list, position);
    }

    private void free(Buddy1Buffer buffer) {
        if (buffer.list.front == buffer.position) {
            return;
        }
        Buddy1RegionFreeList list = buffer.list;
        int position = buffer.position;
        ByteBuffer memory = buffer.list.memory;
        memory.clear();
        while (list.up != null) {
            int buddy = position ^ list.blockSize;
            memory.position(buddy);
            if (memory.get() != list.level) break;
            list.remove(buddy);
            if (position > buddy) {
                position = buddy;
            }
            list = list.up;
        }
        list.add(position);
        memory.position(position);
        memory.put((byte)list.level);
    }

    @Override
    public synchronized void finalixe() {
    }

    private Buddy1RegionFreeList initializeRegion(int numLevels) {
        int l;
        int size = BufferConstants.CHUNK_SIZE << numLevels - 1;
        ByteBuffer memory = ByteBuffer.allocateDirect(size);
        Buddy1RegionFreeList[] lists = new Buddy1RegionFreeList[numLevels];
        int oldNumLevels = this.freeLists.size();
        int blockSize = BufferConstants.CHUNK_SIZE;
        for (l = 0; l < numLevels; ++l) {
            Buddy1FreeList freeList;
            if (l < oldNumLevels) {
                freeList = this.freeLists.get(l);
            } else {
                freeList = new Buddy1FreeList();
                this.freeLists.add(freeList);
            }
            lists[l] = new Buddy1RegionFreeList(l, blockSize, memory, freeList);
            blockSize <<= 1;
        }
        for (l = 0; l < numLevels; ++l) {
            Buddy1RegionFreeList list = lists[l];
            if (l > 0) {
                list.down = lists[l - 1];
            }
            if (l + 1 >= numLevels) continue;
            list.up = lists[l + 1];
        }
        Buddy1RegionFreeList top = lists[numLevels - 1];
        top.add(0);
        return top;
    }
}

