/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Datatype;
import mpi.MPIException;
import mpi.Op;
import mpi.OpWorker;
import mpi.SumByte;
import mpi.SumChar;
import mpi.SumDouble;
import mpi.SumFloat;
import mpi.SumInt;
import mpi.SumLong;
import mpi.SumShort;

public class SumWorker
implements OpWorker {
    SumWorker() {
    }

    @Override
    public Op getWorker(Datatype datatype) throws MPIException {
        switch (datatype.baseType) {
            case 1: {
                return new SumByte();
            }
            case 2: {
                return new SumChar();
            }
            case 3: {
                return new SumShort();
            }
            case 4: {
                throw new MPIException("MPI.SUM is invalid for MPI.BOOLEAN");
            }
            case 5: {
                return new SumInt();
            }
            case 6: {
                return new SumLong();
            }
            case 7: {
                return new SumFloat();
            }
            case 8: {
                return new SumDouble();
            }
        }
        return null;
    }
}

