/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.util.ArrayList;
import mpi.Datatype;
import mpi.MPI;
import mpi.MPIException;
import mpi.Status;

public class Request {
    public mpjdev.Request req = null;
    Datatype datatype = null;
    boolean isNull = false;
    static final int NULL = 2;
    int code = -1;

    Request() {
    }

    Request(int code) {
        this.code = code;
    }

    Request(boolean isNull) {
        this.isNull = isNull;
    }

    public Request(mpjdev.Request req) {
        this.req = req;
    }

    public Status Wait() throws MPIException {
        if (this.isNull) {
            return MPI.EMPTY_STATUS;
        }
        if (this.req == null) {
            System.out.println(" mpjdev Request is null in Wait() ");
            return null;
        }
        mpjdev.Status mpjdevStatus = this.req.iwait();
        this.isNull = true;
        Status status = new Status(mpjdevStatus);
        return status;
    }

    private Status Test(boolean nothing) throws MPIException {
        if (this.isNull) {
            return new Status();
        }
        Object status = null;
        mpjdev.Status devStatus = null;
        if (this.req == null) {
            return null;
        }
        devStatus = this.req.itest();
        if (devStatus == null) {
            return null;
        }
        return new Status();
    }

    public Status Test() throws MPIException {
        if (this.isNull) {
            return MPI.EMPTY_STATUS;
        }
        Status status = null;
        mpjdev.Status devStatus = null;
        if (this.req == null) {
            return null;
        }
        devStatus = this.req.itest();
        if (devStatus == null) {
            return null;
        }
        status = this.Wait();
        return status;
    }

    public static Status Testany(Request[] r) throws MPIException {
        Status s = null;
        for (int i = 0; i < r.length; ++i) {
            if (r[i] == null || r[i].Is_null() || (s = r[i].Test()) == null) continue;
            s.index = i;
            return s;
        }
        return null;
    }

    public void finalize() throws MPIException {
    }

    public boolean Is_null() throws MPIException {
        return this.isNull;
    }

    public static Status[] Waitall(Request[] r) throws MPIException {
        Status[] s = new Status[r.length];
        for (int i = 0; i < r.length; ++i) {
            if (r[i] == null) continue;
            s[i] = r[i].Wait();
        }
        return s;
    }

    public static Status Waitany(Request[] r) throws MPIException {
        Status s = null;
        for (int i = 0; i < r.length; ++i) {
            if (r[i].Is_null()) {
                if (i != r.length - 1) continue;
                i = -1;
                continue;
            }
            s = r[i].Test(true);
            if (s != null) {
                s = r[i].Wait();
                s.index = i;
                return s;
            }
            if (i != r.length - 1) continue;
            i = -1;
        }
        return null;
    }

    public static Status[] Testall(Request[] r) throws MPIException {
        int i;
        Status[] s = new Status[r.length];
        for (i = 0; i < r.length; ++i) {
            if (r[i] == null) continue;
            s[i] = r[i].Test(true);
            if (s[i] != null) continue;
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        for (i = 0; i < r.length; ++i) {
            s[i] = r[i].Wait();
        }
        return s;
    }

    public static Status[] Waitsome(Request[] r) throws MPIException {
        ArrayList<Status> list = new ArrayList<Status>();
        boolean break_flag = false;
        for (int i = 0; i < r.length; ++i) {
            Status s = null;
            if (r[i].Is_null()) {
                if (break_flag && i == r.length - 1) break;
                if (i != r.length - 1) continue;
                i = -1;
                continue;
            }
            s = r[i].Test(true);
            if (s != null) {
                s = r[i].Wait();
                s.index = i;
                list.add(s);
                break_flag = true;
            }
            if (break_flag && i == r.length - 1) break;
            if (i != r.length - 1) continue;
            i = -1;
        }
        return list.toArray(new Status[0]);
    }

    public static Status[] Testsome(Request[] r) throws MPIException {
        ArrayList<Status> list = new ArrayList<Status>();
        for (int i = 0; i < r.length; ++i) {
            Status s = null;
            if (r[i].Is_null() || (s = r[i].Test()) == null) continue;
            s.index = i;
            list.add(s);
        }
        return list.toArray(new Status[0]);
    }

    public void Cancel() throws MPIException {
        System.out.println("Request.Cancel(): Not implemented in this release");
        this.isNull = this.req.cancel();
    }
}

