/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.MPIException;
import mpi.MultistridedPacker;
import mpjbuf.Buffer;

public class MultistridedPackerByte
extends MultistridedPacker {
    public MultistridedPackerByte(int rank, int[] indexes, int extent, int size) {
        super(rank, indexes, extent, size);
    }

    @Override
    public void pack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
        try {
            mpjbuf.strGather((byte[])buf, offset, this.rank, 0, this.rank, this.indexes);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    @Override
    public void unpack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
        try {
            mpjbuf.strScatter((byte[])buf, offset, this.rank, 0, this.rank, this.indexes);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    @Override
    public void unpackPartial(Buffer mpjbuf, int length, Object buf, int offset) throws MPIException {
        int[] cIndexes = new int[2 * this.rank];
        for (int i = 0; i < 2 * this.rank; ++i) {
            cIndexes[i] = this.indexes[i];
        }
        int cubeRank = this.rank - 1;
        int cubeSize = this.size;
        while (length > 0) {
            int numCubes = length / (cubeSize /= this.indexes[cubeRank]);
            if (numCubes > 0) {
                cIndexes[cubeRank] = numCubes;
                int blockSize = numCubes * cubeSize;
                try {
                    mpjbuf.strScatter((byte[])buf, offset, cubeRank + 1, 0, this.rank, cIndexes);
                }
                catch (Exception e) {
                    throw new MPIException(e);
                }
                offset += blockSize;
                length -= blockSize;
            }
            --cubeRank;
        }
    }

    @Override
    public void pack(Buffer mpjbuf, Object buf, int offset, int count) throws MPIException {
        int i;
        if (count == 1) {
            try {
                mpjbuf.strGather((byte[])buf, offset, this.rank, 0, this.rank, this.indexes);
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
        }
        int cRank = this.rank + 1;
        int[] cIndexes = new int[2 * cRank];
        for (i = 0; i < this.rank; ++i) {
            cIndexes[i] = this.indexes[i];
        }
        cIndexes[this.rank] = count;
        for (i = 0; i < this.rank; ++i) {
            cIndexes[cRank + i] = this.indexes[this.rank + i];
        }
        cIndexes[cRank + this.rank] = this.extent;
        try {
            mpjbuf.strGather((byte[])buf, offset, cRank, 0, cRank, cIndexes);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    @Override
    public void unpack(Buffer mpjbuf, Object buf, int offset, int count) throws MPIException {
        int i;
        if (count == 1) {
            try {
                mpjbuf.strScatter((byte[])buf, offset, this.rank, 0, this.rank, this.indexes);
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
        }
        int cRank = this.rank + 1;
        int[] cIndexes = new int[2 * cRank];
        for (i = 0; i < this.rank; ++i) {
            cIndexes[i] = this.indexes[i];
        }
        cIndexes[this.rank] = count;
        for (i = 0; i < this.rank; ++i) {
            cIndexes[cRank + i] = this.indexes[this.rank + i];
        }
        cIndexes[cRank + this.rank] = this.extent;
        try {
            mpjbuf.strScatter((byte[])buf, offset, cRank, 0, cRank, cIndexes);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }
}

