/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Datatype;
import mpi.MPIException;
import mpi.MaxByte;
import mpi.MaxChar;
import mpi.MaxDouble;
import mpi.MaxFloat;
import mpi.MaxInt;
import mpi.MaxLong;
import mpi.MaxShort;
import mpi.Op;
import mpi.OpWorker;

public class MaxWorker
implements OpWorker {
    MaxWorker() {
    }

    @Override
    public Op getWorker(Datatype datatype) throws MPIException {
        switch (datatype.baseType) {
            case 1: {
                return new MaxByte();
            }
            case 2: {
                return new MaxChar();
            }
            case 3: {
                return new MaxShort();
            }
            case 4: {
                throw new MPIException("MPI.MAX is invalid for MPI.BOOLEAN");
            }
            case 5: {
                return new MaxInt();
            }
            case 6: {
                return new MaxLong();
            }
            case 7: {
                return new MaxFloat();
            }
            case 8: {
                return new MaxDouble();
            }
        }
        return null;
    }
}

