/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import mpi.Band;
import mpi.BasicType;
import mpi.Bor;
import mpi.Bxor;
import mpi.Comm;
import mpi.Datatype;
import mpi.Errhandler;
import mpi.Group;
import mpi.Intracomm;
import mpi.Land;
import mpi.Lor;
import mpi.Lxor;
import mpi.MPIException;
import mpi.Max;
import mpi.Maxloc;
import mpi.Min;
import mpi.Minloc;
import mpi.Op;
import mpi.Prod;
import mpi.Request;
import mpi.Status;
import mpi.Sum;
import mpjdev.MPJDev;
import org.apache.log4j.Logger;
import xdev.ProcessID;

public class MPI {
    public static final boolean DEBUG = false;
    static Logger logger = null;
    public static Intracomm COMM_WORLD;
    private static boolean initialized;
    static boolean debug;
    static ByteBuffer buffer;
    static ArrayList<Request> pendingRequests;
    static final int OP_BSEND = 1;
    static final int OP_RSEND = 2;
    static final int OP_SEND = 3;
    static final int OP_RECV = 4;
    static final int OP_SSEND = 5;
    public static final int NUM_OF_PROCESSORS;
    static Status UNDEFINED_STATUS;
    public static int UNDEFINED;
    public static Datatype NULL;
    public static Datatype BYTE;
    public static Datatype CHAR;
    public static Datatype SHORT;
    public static Datatype BOOLEAN;
    public static Datatype INT;
    public static Datatype LONG;
    public static Datatype FLOAT;
    public static Datatype DOUBLE;
    public static Datatype PACKED;
    public static Datatype LB;
    public static Datatype UB;
    public static Datatype OBJECT;
    public static int THREAD_SINGLE;
    public static int THREAD_FUNNELED;
    public static int THREAD_SERIALIZED;
    public static int THREAD_MULTIPLE;
    public static Datatype SHORT2;
    public static Datatype INT2;
    public static Datatype LONG2;
    public static Datatype FLOAT2;
    public static Datatype DOUBLE2;
    public static Op MAX;
    public static Op MIN;
    public static Op SUM;
    public static Op PROD;
    public static Op LAND;
    public static Op BAND;
    public static Op LOR;
    public static Op BOR;
    public static Op LXOR;
    public static Op BXOR;
    public static Op MAXLOC;
    public static Op MINLOC;
    public static int ANY_SOURCE;
    public static int ANY_TAG;
    public static Status EMPTY_STATUS;
    public static int PROC_NULL;
    public static int BSEND_OVERHEAD;
    public static int SEND_OVERHEAD;
    public static int RECV_OVERHEAD;
    public static Group GROUP_EMPTY;
    public static Comm COMM_SELF;
    public static final int IDENT = 0;
    public static final int CONGRUENT = 3;
    public static final int SIMILAR = 1;
    public static final int UNEQUAL = 2;
    public static int GRAPH;
    public static int CART;
    public static Errhandler ERRORS_ARE_FATAL;
    public static Errhandler ERRORS_RETURN;
    public static int TAG_UB;
    public static int HOST;
    public static int IO;
    public static Request REQUEST_NULL;
    public static Comm COMM_NULL;
    public static Group GROUP_NULL;

    public static void Buffer_attach(ByteBuffer userBuffer) throws MPIException {
        buffer = userBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Buffer_detach() throws MPIException {
        ArrayList<Request> arrayList = pendingRequests;
        synchronized (arrayList) {
            for (Request pending : pendingRequests) {
                pending.Wait();
            }
            buffer = null;
        }
        Comm.PendingMessage.clearFront();
    }

    public static String[] initThread(int required, int provided, String[] argv) {
        return null;
    }

    public static boolean isMainThread() {
        return true;
    }

    public static int queryThread() {
        return THREAD_MULTIPLE;
    }

    public static String[] Init(String[] argv) throws MPIException {
        if (argv.length < 3) {
            throw new MPIException("Usage: java MPI <myrank> <conf_file> <device_name> conf_file can be, ../conf/xdev.conf <Local>OR http://holly.dsg.port.ac.uk:15000/xdev.conf <Remote>");
        }
        Object fileAppender = null;
        int rank = Integer.parseInt(argv[0]);
        Map<String, String> map = System.getenv();
        String mpjHomeDir = map.get("MPJ_HOME");
        if (logger == null) {
            // empty if block
        }
        try {
            MPJDev.init(argv);
            SEND_OVERHEAD = BSEND_OVERHEAD = MPJDev.getSendOverhead();
            RECV_OVERHEAD = MPJDev.getRecvOverhead();
            COMM_WORLD = new Intracomm(MPJDev.WORLD, MPJDev.WORLD.group);
            COMM_WORLD.Attr_put(TAG_UB, Integer.MAX_VALUE);
            COMM_WORLD.Attr_put(HOST, PROC_NULL);
            COMM_WORLD.Attr_put(IO, COMM_WORLD.Rank());
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        int[] self = new int[]{COMM_WORLD.Rank()};
        Group selfGroup = MPI.COMM_WORLD.group.Incl(self);
        COMM_SELF = COMM_WORLD.Create(selfGroup);
        int[] empty = new int[]{};
        GROUP_EMPTY = MPI.COMM_WORLD.group.Incl(empty);
        MPI.GROUP_EMPTY.code = 3;
        GROUP_NULL = new Group(2);
        COMM_NULL = new Comm(2);
        ERRORS_ARE_FATAL = new Errhandler(2);
        ERRORS_ARE_FATAL = new Errhandler(3);
        String[] nargs = new String[argv.length - 3];
        System.arraycopy(argv, 3, nargs, 0, nargs.length);
        initialized = true;
        return nargs;
    }

    public static void Finalize() throws MPIException {
        MPI.Buffer_detach();
        try {
            COMM_WORLD.Barrier();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MPIException(e);
        }
        try {
            MPJDev.finish();
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        initialized = false;
    }

    public static String Get_processor_name() throws MPIException {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            byte[] ipAddr = addr.getAddress();
            String hostname = addr.getHostName();
            return hostname;
        }
        catch (UnknownHostException e) {
            throw new MPIException(e);
        }
    }

    public static void Errorhandler_set(Errhandler errhandler) throws MPIException {
    }

    public static Errhandler Errorhandler_get() throws MPIException {
        return null;
    }

    public static double Wtime() throws MPIException {
        return System.currentTimeMillis() / 1000L;
    }

    public static double Wtick() throws MPIException {
        double time = 0.0;
        double smaller = Double.MAX_VALUE;
        for (int i = 0; i < 100000; ++i) {
            time = MPI.Wtime();
            double newTime = MPI.Wtime();
            smaller = Math.min(smaller, newTime - time);
        }
        return smaller;
    }

    public static boolean Initialized() throws MPIException {
        return initialized;
    }

    static {
        initialized = false;
        debug = true;
        buffer = null;
        pendingRequests = new ArrayList();
        NUM_OF_PROCESSORS = Runtime.getRuntime().availableProcessors();
        UNDEFINED_STATUS = new Status(-1, -1, -1);
        UNDEFINED = -1;
        NULL = new BasicType(0);
        BYTE = new BasicType(1);
        CHAR = new BasicType(2);
        SHORT = new BasicType(3);
        BOOLEAN = new BasicType(4);
        INT = new BasicType(5);
        LONG = new BasicType(6);
        FLOAT = new BasicType(7);
        DOUBLE = new BasicType(8);
        PACKED = new BasicType(9);
        LB = new BasicType(10);
        UB = new BasicType(11);
        OBJECT = new BasicType(12);
        THREAD_SINGLE = 1;
        THREAD_FUNNELED = 2;
        THREAD_SERIALIZED = 3;
        THREAD_MULTIPLE = 4;
        SHORT2 = Datatype.Contiguous(2, SHORT);
        INT2 = Datatype.Contiguous(2, INT);
        LONG2 = Datatype.Contiguous(2, LONG);
        FLOAT2 = Datatype.Contiguous(2, FLOAT);
        DOUBLE2 = Datatype.Contiguous(2, DOUBLE);
        MAX = new Max();
        MIN = new Min();
        SUM = new Sum();
        PROD = new Prod();
        LAND = new Land();
        BAND = new Band();
        LOR = new Lor();
        BOR = new Bor();
        LXOR = new Lxor();
        BXOR = new Bxor();
        MAXLOC = new Op(new Maxloc(), true);
        MINLOC = new Op(new Minloc(), true);
        ANY_SOURCE = -2;
        ANY_TAG = -2;
        EMPTY_STATUS = new Status(ANY_SOURCE, ANY_TAG, 0, 0);
        PROC_NULL = -3;
        GROUP_EMPTY = new Group(new mpjdev.Group(new ProcessID[0], null, -1));
        GRAPH = 1;
        CART = 2;
        REQUEST_NULL = new Request(true);
    }
}

