/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.util.Arrays;
import mpi.Cartcomm;
import mpi.Comm;
import mpi.Datatype;
import mpi.Graphcomm;
import mpi.Group;
import mpi.MPI;
import mpi.MPIException;
import mpi.Op;
import mpi.ProcTree;
import mpi.Request;
import mpi.Status;

public class Intracomm
extends Comm {
    int bcast_tag = 35000;
    int nBARRIER_TAG = 34001;
    int gatherTag = 34002;
    int gathervTag = 34003;
    int scatterTag = 34004;
    int scattervTag = 34005;
    int allgatherTag = 34006;
    int allgathervTag = 34007;
    int alltoallTag = 34008;
    int alltoallvTag = 34009;
    int reduceTag = 34010;
    int allreduceTag = 34011;
    int reducescatterTag = 34012;
    int scanTag = 34013;
    int bCount = 1000;
    ProcTree procTree = null;
    static boolean EXOTIC_ALLGATHER = false;
    static boolean EXOTIC_ALLGATHERV = false;
    static boolean EXOTIC_BARRIER = false;
    static boolean EXOTIC_ALLREDUCE = false;

    Intracomm() {
    }

    Intracomm(mpjdev.Comm mpjdevComm, mpjdev.Group group) throws MPIException {
        this.mpjdevComm = mpjdevComm;
        this.group = new Group(group);
        this.procTree = new ProcTree();
        int root = 0;
        int index = this.Rank();
        int extent = this.Size();
        int places = 4 * index;
        for (int i = 1; i <= 4; ++i) {
            int ch = 4 * index + i + root;
            ch %= extent;
            if (++places >= extent) continue;
            this.procTree.child[i - 1] = ch;
            ++this.procTree.numChildren;
        }
        if (index == root) {
            this.procTree.isRoot = true;
        } else {
            int pr;
            this.procTree.isRoot = false;
            this.procTree.parent = pr = (index - 1) / 4;
        }
        this.procTree.root = root;
    }

    public Intracomm Split(int color, int key) throws MPIException {
        int i;
        Intracomm icomm = null;
        int[][] b = new int[this.group.Size()][3];
        int len = 0;
        int[] a = new int[2];
        int[] ra = new int[2];
        a[0] = color;
        a[1] = key;
        ra[0] = 0;
        ra[1] = 0;
        b[len][0] = color;
        b[len][1] = key;
        b[len][2] = this.group.Rank();
        ++len;
        int size = this.group.Size();
        int rank = this.group.Rank();
        int tag = 1110;
        Request[] reqs = new Request[size];
        for (i = 0; i < size; ++i) {
            if (i == rank) continue;
            reqs[i] = this.isend(a, 0, 2, MPI.INT, i, rank + tag + i, false);
        }
        for (i = 0; i < size; ++i) {
            if (i == rank) continue;
            this.recv(ra, 0, 2, MPI.INT, i, tag + i + rank, false);
            if (ra[0] != color) continue;
            b[len][0] = ra[0];
            b[len][1] = ra[1];
            b[len][2] = i;
            ++len;
        }
        for (i = 0; i < size; ++i) {
            if (i == rank) continue;
            reqs[i].Wait();
        }
        int[] keys = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            keys[i2] = b[i2][1];
        }
        Arrays.sort(keys);
        int[] nids = new int[len];
        for (int i3 = 0; i3 < len; ++i3) {
            for (int j = 0; j < len; ++j) {
                if (keys[i3] != b[j][1]) continue;
                nids[i3] = b[j][2];
            }
        }
        try {
            mpjdev.Comm ncomm = this.mpjdevComm.create(nids);
            icomm = new Intracomm(ncomm, ncomm.group);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        return icomm;
    }

    @Override
    public Object clone() throws MPIException {
        return this.Create(this.group);
    }

    public Intracomm Create(Group group) throws MPIException {
        mpjdev.Comm tcomm = this.mpjdevComm.create(group.mpjdevGroup);
        return new Intracomm(tcomm, group.mpjdevGroup);
    }

    void nBarrier() throws MPIException {
        int i;
        int offset = 0;
        Datatype type = MPI.INT;
        int[] buf = new int[1];
        int count = 1;
        int btag = this.nBARRIER_TAG;
        if (this.procTree.isRoot) {
            for (i = 0; i < this.procTree.child.length; ++i) {
                if (this.procTree.child[i] == -1) continue;
                this.recv(buf, offset, count, type, this.procTree.child[i], btag - this.procTree.child[i], false);
            }
        } else {
            if (this.procTree.parent == -1) {
                System.out.println("non root's node parent doesn't exist");
            }
            for (i = 0; i < this.procTree.child.length; ++i) {
                if (this.procTree.child[i] == -1) continue;
                this.recv(buf, offset, count, type, this.procTree.child[i], btag - this.procTree.child[i], false);
            }
            this.send(buf, offset, count, type, this.procTree.parent, btag - this.Rank(), false);
        }
        if (this.procTree.isRoot) {
            for (i = 0; i < this.procTree.child.length; ++i) {
                if (this.procTree.child[i] == -1) continue;
                this.send(buf, offset, count, type, this.procTree.child[i], btag - this.procTree.child[i], false);
            }
        } else {
            if (this.procTree.parent == -1) {
                System.out.println("non root's node parent doesn't exist");
            }
            this.recv(buf, offset, count, type, this.procTree.parent, btag - this.Rank(), false);
            for (i = 0; i < this.procTree.child.length; ++i) {
                if (this.procTree.child[i] == -1) continue;
                this.send(buf, offset, count, type, this.procTree.child[i], btag - this.procTree.child[i], false);
            }
        }
    }

    void newBarrier() throws MPIException {
        int size = this.Size();
        int rank = this.Rank();
        Request req = null;
        int[] stuff = new int[1];
        int y = (int)Math.pow(2.0, Math.floor(Math.log(size) / Math.log(2.0)));
        if (rank >= y) {
            try {
                req = this.isend(stuff, 0, 1, MPI.INT, rank - y, (999 + rank - y) * this.bCount, false);
                this.recv(stuff, 0, 1, MPI.INT, rank - y, (999 + rank) * this.bCount, false);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            req.Wait();
        } else {
            if (size - y > rank) {
                try {
                    this.recv(stuff, 0, 1, MPI.INT, rank + y, (999 + rank) * this.bCount, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            int round = -1;
            int peer = 0;
            do {
                peer = rank ^ (int)Math.pow(2.0, ++round);
                try {
                    req = this.isend(stuff, 0, 1, MPI.INT, peer, (999 + peer) * this.bCount, false);
                    this.recv(stuff, 0, 1, MPI.INT, peer, (999 + rank) * this.bCount, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            } while (round != (int)(Math.log(y) / Math.log(2.0)) - 1);
            if (size - y > rank) {
                try {
                    req = this.isend(stuff, 0, 1, MPI.INT, rank + y, (999 + rank + y) * this.bCount, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    private void exoticBarrier() throws MPIException {
        int size = this.Size();
        int rank = this.Rank();
        byte[] barrierMsg = new byte[1];
        for (int mask = 1; mask < size; mask <<= 1) {
            int dst = (rank + mask) % size;
            int src = (rank - mask + size) % size;
            this.sendrecv(barrierMsg, 0, 1, MPI.BYTE, dst, this.nBARRIER_TAG, barrierMsg, 0, 1, MPI.BYTE, src, this.nBARRIER_TAG);
        }
    }

    public void Barrier() throws MPIException {
        if (this.Size() == 1) {
            return;
        }
        if (EXOTIC_BARRIER) {
            this.exoticBarrier();
            return;
        }
        this.nBarrier();
    }

    public void Bcast(Object buf, int offset, int count, Datatype type, int root) throws MPIException {
        int index = this.Rank();
        if (root != 0) {
            if (root == index) {
                this.send(buf, offset, count, type, 0, this.bcast_tag, false);
            }
            if (index == 0) {
                this.recv(buf, offset, count, type, root, this.bcast_tag - this.Rank(), false);
            }
        }
        root = 0;
        if (this.procTree.isRoot) {
            for (int i = 0; i < this.procTree.child.length; ++i) {
                if (this.procTree.child[i] == -1) continue;
                this.send(buf, offset, count, type, this.procTree.child[i], this.bcast_tag - this.procTree.child[i], false);
            }
        } else {
            if (this.procTree.parent == -1) {
                System.out.println("non root's node parent doesn't exist");
            }
            this.recv(buf, offset, count, type, this.procTree.parent, this.bcast_tag - this.Rank(), false);
            for (int i = 0; i < this.procTree.child.length; ++i) {
                if (this.procTree.child[i] == -1) continue;
                this.send(buf, offset, count, type, this.procTree.child[i], this.bcast_tag - this.procTree.child[i], false);
            }
        }
        if (this.bcast_tag == 65535) {
            this.bcast_tag = 35000;
        }
        ++this.bcast_tag;
    }

    public void Gather(Object sendbuf, int sendoffset, int sendcount, Datatype sendtype, Object recvbuf, int recvoffset, int recvcount, Datatype recvtype, int root) throws MPIException {
        int rcount = -1;
        int roffset = -1;
        int soffset = -1;
        int scount = -1;
        Request req = null;
        if (root != this.Rank()) {
            req = this.isend(sendbuf, sendoffset, sendcount, sendtype, root, this.gatherTag + this.Rank(), false);
        } else {
            scount = sendcount;
            soffset = sendoffset;
        }
        if (root == this.Rank()) {
            for (int i = 0; i < this.Size(); ++i) {
                if (i != root) {
                    this.recv(recvbuf, recvoffset, recvcount, recvtype, i, this.gatherTag + i, false);
                } else {
                    roffset = recvoffset;
                    rcount = recvcount;
                }
                recvoffset += recvcount;
            }
        }
        if (rcount != scount) {
            System.out.println(" scount != rcount, should not happen");
            System.out.println(" this is Reduce method");
        }
        if (root == this.Rank()) {
            System.arraycopy(sendbuf, soffset, recvbuf, roffset, rcount);
        } else {
            req.Wait();
        }
    }

    public void Gatherv(Object sendbuf, int sendoffset, int sendcount, Datatype sendtype, Object recvbuf, int recvoffset, int[] recvcount, int[] displs, Datatype recvtype, int root) throws MPIException {
        int rcount = -1;
        int roffset = -1;
        Request req = null;
        if (root != this.Rank()) {
            req = this.isend(sendbuf, sendoffset, sendcount, sendtype, root, this.gathervTag + this.Rank(), false);
        }
        if (root == this.Rank()) {
            for (int i = 0; i < this.Size(); ++i) {
                if (i != root) {
                    this.recv(recvbuf, recvoffset + displs[i], recvcount[i], recvtype, i, this.gathervTag + i, false);
                    continue;
                }
                roffset = recvoffset + displs[i];
                rcount = recvcount[i];
            }
        }
        if (root == this.Rank()) {
            if (rcount != sendcount) {
                System.out.println(" scount != rcount, should not happen");
                System.out.println(" this is Reduce method");
            }
            System.arraycopy(sendbuf, sendoffset, recvbuf, roffset, rcount);
        } else {
            req.Wait();
        }
    }

    public void Scatter(Object sendbuf, int sendoffset, int sendcount, Datatype sendtype, Object recvbuf, int recvoffset, int recvcount, Datatype recvtype, int root) throws MPIException {
        int i;
        Request[] reqs = new Request[this.Size()];
        int soffset = -1;
        int scount = -1;
        if (root == this.Rank()) {
            for (i = 0; i < this.Size(); ++i) {
                if (root != i) {
                    reqs[i] = this.isend(sendbuf, sendoffset, sendcount, sendtype, i, this.scatterTag + i, false);
                } else {
                    soffset = sendoffset;
                    scount = sendcount;
                }
                sendoffset += sendcount;
            }
        }
        if (root != this.Rank()) {
            this.recv(recvbuf, recvoffset, recvcount, recvtype, root, this.scatterTag + this.Rank(), false);
        } else {
            if (scount != recvcount) {
                System.out.println(" scount shuld be equal to recvcount");
            }
            System.arraycopy(sendbuf, soffset, recvbuf, recvoffset, recvcount);
        }
        if (root == this.Rank()) {
            for (i = 0; i < this.Size(); ++i) {
                if (i == root) continue;
                reqs[i].Wait();
            }
        }
    }

    public void Scatterv(Object sendbuf, int sendoffset, int[] sendcount, int[] displs, Datatype sendtype, Object recvbuf, int recvoffset, int recvcount, Datatype recvtype, int root) throws MPIException {
        int i;
        Request[] reqs = new Request[this.Size()];
        int soffset = -1;
        int scount = -1;
        if (root == this.Rank()) {
            for (i = 0; i < this.Size(); ++i) {
                if (root != i) {
                    reqs[i] = this.isend(sendbuf, sendoffset + displs[i], sendcount[i], sendtype, i, this.scattervTag + i, false);
                    continue;
                }
                soffset = sendoffset + displs[i];
                scount = sendcount[i];
            }
        }
        if (root != this.Rank()) {
            this.recv(recvbuf, recvoffset, recvcount, recvtype, root, this.scattervTag + this.Rank(), false);
        } else {
            if (scount != recvcount) {
                System.out.println(" scount shuld be equal to recvcount");
            }
            System.arraycopy(sendbuf, soffset, recvbuf, recvoffset, recvcount);
        }
        if (root == this.Rank()) {
            for (i = 0; i < this.Size(); ++i) {
                if (i == root) continue;
                reqs[i].Wait();
            }
        }
    }

    public void Allgather(Object sendbuf, int sendoffset, int sendcount, Datatype sendtype, Object recvbuf, int recvoffset, int recvcount, Datatype recvtype) throws MPIException {
        if (EXOTIC_ALLGATHER) {
            int pof2;
            int me = this.Rank();
            int size = this.Size();
            for (pof2 = 1; pof2 < size; pof2 *= 2) {
            }
            pof2 = pof2 == size ? 1 : 0;
            System.arraycopy(sendbuf, sendoffset, recvbuf, recvcount * me, recvcount);
            int curr_cnt = recvcount;
            int mask = 1;
            int i = 0;
            while (mask < size) {
                int dst = me ^ mask;
                int dst_tree_root = dst >> i;
                int my_tree_root = me >> i;
                int send_offset = (my_tree_root <<= i) * recvcount;
                int recv_offset = (dst_tree_root <<= i) * recvcount;
                Status status = this.sendrecv(recvbuf, send_offset, curr_cnt, sendtype, dst, this.allgatherTag, recvbuf, recv_offset, recvcount * mask, recvtype, dst, this.allgatherTag);
                int last_recv_cnt = status.Get_count(recvtype);
                curr_cnt += last_recv_cnt;
                mask <<= 1;
                ++i;
            }
        } else {
            int i;
            Request[] req = new Request[this.Size()];
            int rcount = -1;
            int roffset = -1;
            for (i = 0; i < this.Size(); ++i) {
                if (i == this.Rank()) continue;
                req[i] = this.isend(sendbuf, sendoffset, sendcount, sendtype, i, this.allgatherTag + i + this.Rank(), false);
            }
            for (i = 0; i < this.Size(); ++i) {
                if (i != this.Rank()) {
                    this.recv(recvbuf, recvoffset, recvcount, recvtype, i, this.allgatherTag + this.Rank() + i, false);
                } else {
                    rcount = recvcount;
                    roffset = recvoffset;
                }
                recvoffset += recvcount;
            }
            System.arraycopy(sendbuf, sendoffset, recvbuf, roffset, rcount);
            for (i = 0; i < this.Size(); ++i) {
                if (i == this.Rank()) continue;
                req[i].Wait();
            }
        }
    }

    public void Allgatherv(Object sendbuf, int sendoffset, int sendcount, Datatype sendtype, Object recvbuf, int recvoffset, int[] recvcount, int[] displs, Datatype recvtype) throws MPIException {
        if (EXOTIC_ALLGATHERV) {
            int pof2;
            int total_count = 0;
            Object[] tmp_buf = null;
            int me = this.Rank();
            int size = this.Size();
            for (int i = 0; i < recvcount.length; ++i) {
                total_count += recvcount[i];
            }
            if (total_count == 0) {
                return;
            }
            for (pof2 = 1; pof2 < size; pof2 *= 2) {
            }
            pof2 = pof2 == size ? 1 : 0;
            if (sendtype == MPI.LONG) {
                tmp_buf = new long[total_count];
            } else if (sendtype == MPI.INT) {
                tmp_buf = new int[total_count];
                tmp_buf = (int[])tmp_buf;
            }
            int position = 0;
            for (int i = 0; i < me; ++i) {
                position += recvcount[i];
            }
            System.arraycopy(sendbuf, sendoffset, tmp_buf, position, recvcount[me]);
            int curr_cnt = recvcount[me];
            int mask = 1;
            int i = 0;
            while (mask < size) {
                int j;
                int dst = me ^ mask;
                int dst_tree_root = dst >> i;
                dst_tree_root <<= i;
                int my_tree_root = me >> i;
                my_tree_root <<= i;
                int send_offset = 0;
                for (j = 0; j < my_tree_root; ++j) {
                    send_offset += recvcount[j];
                }
                int recv_offset = 0;
                for (j = 0; j < dst_tree_root; ++j) {
                    recv_offset += recvcount[j];
                }
                Status status = this.sendrecv(tmp_buf, send_offset, curr_cnt, sendtype, dst, this.allgathervTag, tmp_buf, recv_offset, total_count, recvtype, dst, this.allgathervTag);
                int last_recv_cnt = status.Get_count(recvtype);
                curr_cnt += last_recv_cnt;
                mask <<= 1;
                ++i;
            }
            position = 0;
            for (int j = 0; j < size; ++j) {
                System.arraycopy(tmp_buf, position, recvbuf, recvoffset + displs[j], recvcount[j]);
                position += recvcount[j];
            }
        } else {
            Request[] req = new Request[this.Size()];
            Request[] rreq = new Request[this.Size()];
            int rcount = -1;
            int roffset = -1;
            int i = 0;
            for (i = 0; i < this.Size(); ++i) {
                if (i == this.Rank()) continue;
                req[i] = this.isend(sendbuf, sendoffset, sendcount, sendtype, i, this.allgathervTag + i + this.Rank(), false);
            }
            for (i = 0; i < this.Size(); ++i) {
                if (i != this.Rank()) {
                    rreq[i] = this.irecv(recvbuf, recvoffset + displs[i], recvcount[i], recvtype, i, this.allgathervTag + i + this.Rank(), false);
                    continue;
                }
                rcount = recvcount[i];
                roffset = recvoffset + displs[i];
            }
            System.arraycopy(sendbuf, sendoffset, recvbuf, roffset, rcount);
            for (i = 0; i < this.Size(); ++i) {
                if (i == this.Rank()) continue;
                req[i].Wait();
            }
            for (i = 0; i < this.Size(); ++i) {
                if (i == this.Rank()) continue;
                rreq[i].Wait();
            }
        }
    }

    public void Alltoall(Object sendbuf, int sendoffset, int sendcount, Datatype sendtype, Object recvbuf, int recvoffset, int recvcount, Datatype recvtype) throws MPIException {
        int i;
        Request[] req = new Request[this.Size()];
        int soffset = -1;
        int scount = -1;
        int roffset = -1;
        int rcount = -1;
        for (i = 0; i < this.Size(); ++i) {
            if (i != this.Rank()) {
                req[i] = this.isend(sendbuf, sendoffset, sendcount, sendtype, i, this.alltoallTag * (76 + (i + 1)), false);
            } else {
                soffset = sendoffset;
                scount = sendcount;
            }
            sendoffset += sendcount;
        }
        for (i = 0; i < this.Size(); ++i) {
            if (i != this.Rank()) {
                this.recv(recvbuf, recvoffset, recvcount, recvtype, i, this.alltoallTag * (76 + (this.Rank() + 1)), false);
            } else {
                roffset = recvoffset;
                rcount = recvcount;
            }
            recvoffset += recvcount;
        }
        if (scount != rcount) {
            System.out.println("Alltoall, rcount not equal to scount");
            System.out.println("this can never happen ...");
        }
        System.arraycopy(sendbuf, soffset, recvbuf, roffset, rcount);
        for (i = 0; i < this.Size(); ++i) {
            if (i == this.Rank()) continue;
            req[i].Wait();
        }
    }

    public void Alltoallv(Object sendbuf, int sendoffset, int[] sendcount, int[] sdispls, Datatype sendtype, Object recvbuf, int recvoffset, int[] recvcount, int[] rdispls, Datatype recvtype) throws MPIException {
        int i;
        Request[] req = new Request[this.Size()];
        int soffset = -1;
        int scount = -1;
        int roffset = -1;
        int rcount = -1;
        for (i = 0; i < this.Size(); ++i) {
            if (i != this.Rank()) {
                req[i] = this.isend(sendbuf, sendoffset + sdispls[i], sendcount[i], sendtype, i, this.alltoallvTag, false);
                continue;
            }
            soffset = sendoffset + sdispls[i];
            scount = sendcount[i];
        }
        for (i = 0; i < this.Size(); ++i) {
            if (i != this.Rank()) {
                this.recv(recvbuf, recvoffset + rdispls[i], recvcount[i], recvtype, i, this.alltoallvTag, false);
                continue;
            }
            roffset = recvoffset + rdispls[i];
            rcount = recvcount[i];
        }
        if (scount != rcount) {
            System.out.println("Alltoall, rcount not equal to scount");
            System.out.println("this can never happen ...");
        }
        System.arraycopy(sendbuf, soffset, recvbuf, roffset, rcount);
        for (i = 0; i < this.Size(); ++i) {
            if (i == this.Rank()) continue;
            req[i].Wait();
        }
    }

    public void Reduce(Object sendbuf, int sendoffset, Object recvbuf, int recvoffset, int count, Datatype datatype, Op op, int root) throws MPIException {
        if (op.worker == null) {
            Request req = null;
            Object tmpbuf = this.createTemporaryBuffer(datatype, count);
            if (root != this.Rank()) {
                req = this.isend(sendbuf, sendoffset, count, datatype, root, this.reduceTag, false);
            } else {
                System.arraycopy(sendbuf, sendoffset, tmpbuf, sendoffset, count * datatype.size);
            }
            if (this.Rank() == root) {
                for (int i = 0; i < this.Size(); ++i) {
                    if (i == this.Rank()) continue;
                    this.recv(recvbuf, recvoffset, count, datatype, i, this.reduceTag, false);
                    op.funct.Call(recvbuf, recvoffset, tmpbuf, sendoffset, count, datatype);
                }
            }
            if (root != this.Rank()) {
                req.Wait();
            }
            System.arraycopy(tmpbuf, sendoffset, recvbuf, recvoffset, count * datatype.size);
            return;
        }
        Op op2 = op.worker.getWorker(datatype);
        op2.createInitialBuffer(sendbuf, sendoffset, count);
        Request req = null;
        if (root != this.Rank()) {
            req = this.isend(sendbuf, sendoffset, count, datatype, root, this.reduceTag, false);
        }
        if (this.Rank() == root) {
            for (int i = 0; i < this.Size(); ++i) {
                if (i == this.Rank()) continue;
                this.recv(recvbuf, recvoffset, count, datatype, i, this.reduceTag, false);
                op2.perform(recvbuf, recvoffset, count);
            }
        }
        op2.getResultant(recvbuf, recvoffset, count);
        if (root != this.Rank()) {
            req.Wait();
        }
    }

    Object createTemporaryBuffer(Datatype datatype, int count) {
        Object[] tempBuffer = null;
        switch (datatype.baseType) {
            case -1: {
                System.out.println("Intracomm.createTemporaryBuffer() - UNDEFINED datatype");
                break;
            }
            case 0: {
                System.out.println("Intracomm.createTemporaryBuffer() - NULL datatype");
                break;
            }
            case 1: {
                tempBuffer = new byte[count * datatype.Size()];
                break;
            }
            case 2: {
                tempBuffer = new char[count * datatype.Size()];
                break;
            }
            case 3: {
                tempBuffer = new short[count * datatype.Size()];
                break;
            }
            case 4: {
                tempBuffer = new byte[count * datatype.Size()];
                break;
            }
            case 5: {
                tempBuffer = new int[count * datatype.Size()];
                break;
            }
            case 6: {
                tempBuffer = new long[count * datatype.Size()];
                break;
            }
            case 7: {
                tempBuffer = new float[count * datatype.Size()];
                break;
            }
            case 8: {
                tempBuffer = new double[count * datatype.Size()];
                break;
            }
            case 9: {
                System.out.println("Intracomm.createTemporaryBuffer() - PACKED datatype");
                break;
            }
            case 12: {
                tempBuffer = new Object[count * datatype.Size()];
                break;
            }
            default: {
                System.out.println("Intracomm.createTemporaryBuffer() - default datatype");
            }
        }
        return tempBuffer;
    }

    public void Allreduce(Object sendbuf, int sendoffset, Object recvbuf, int recvoffset, int count, Datatype datatype, Op op) throws MPIException {
        int i;
        if (op.worker == null) {
            int i2;
            Request[] req = new Request[this.Size()];
            Object tmpbuf = this.createTemporaryBuffer(datatype, count);
            for (i2 = 0; i2 < req.length; ++i2) {
                if (i2 != this.Rank()) {
                    req[i2] = this.isend(sendbuf, sendoffset, count, datatype, i2, this.allreduceTag, false);
                    continue;
                }
                System.arraycopy(sendbuf, sendoffset, tmpbuf, sendoffset, count * datatype.size);
            }
            for (i2 = 0; i2 < this.Size(); ++i2) {
                if (i2 == this.Rank()) continue;
                this.recv(recvbuf, recvoffset, count, datatype, i2, this.allreduceTag, false);
                op.funct.Call(recvbuf, recvoffset, tmpbuf, sendoffset, count, datatype);
            }
            for (i2 = 0; i2 < this.Size(); ++i2) {
                if (i2 == this.Rank()) continue;
                req[i2].Wait();
            }
            System.arraycopy(tmpbuf, sendoffset, recvbuf, recvoffset, count * datatype.size);
            return;
        }
        if (EXOTIC_ALLREDUCE) {
            Op op2 = op.worker.getWorker(datatype);
            op2.createInitialBuffer(sendbuf, sendoffset, count * datatype.size);
            op2.getResultant(recvbuf, recvoffset, count);
            boolean i3 = false;
            int me = this.Rank();
            int size = this.Size();
            for (int mask = 1; mask < size; mask <<= 1) {
                int dst = me ^ mask;
                this.sendrecv(recvbuf, sendoffset, count, datatype, dst, this.allreduceTag, sendbuf, recvoffset, count, datatype, dst, this.allreduceTag);
                op2.perform(sendbuf, recvoffset, count);
                op2.getResultant(recvbuf, recvoffset, count);
            }
            return;
        }
        Op op2 = op.worker.getWorker(datatype);
        op2.createInitialBuffer(sendbuf, sendoffset, count * datatype.size);
        Request[] req = new Request[this.Size()];
        for (i = 0; i < req.length; ++i) {
            if (i == this.Rank()) continue;
            req[i] = this.isend(sendbuf, sendoffset, count, datatype, i, this.allreduceTag, false);
        }
        for (i = 0; i < this.Size(); ++i) {
            if (i == this.Rank()) continue;
            this.recv(recvbuf, recvoffset, count, datatype, i, this.allreduceTag, false);
            op2.perform(recvbuf, recvoffset, count);
        }
        op2.getResultant(recvbuf, recvoffset, count);
        for (i = 0; i < this.Size(); ++i) {
            if (i == this.Rank()) continue;
            req[i].Wait();
        }
    }

    public void Reduce_scatter(Object sendbuf, int sendoffset, Object recvbuf, int recvoffset, int[] recvcounts, Datatype datatype, Op op) throws MPIException {
        int root = 0;
        int myself = this.Rank();
        int sendcount = 0;
        for (int k = 0; k < recvcounts.length; ++k) {
            sendcount += recvcounts[k];
        }
        this.Reduce(sendbuf, sendoffset, recvbuf, recvoffset, sendcount, datatype, op, root);
        this.Scatter(recvbuf, recvoffset, recvcounts[myself], datatype, recvbuf, recvoffset, recvcounts[myself], datatype, root);
    }

    public void Scan(Object sendbuf, int sendoffset, Object recvbuf, int recvoffset, int count, Datatype datatype, Op op) throws MPIException {
        int i;
        if (op.worker == null) {
            int i2;
            Request[] req = new Request[this.Size()];
            Object tmpbuf = this.createTemporaryBuffer(datatype, count);
            System.arraycopy(sendbuf, sendoffset, tmpbuf, sendoffset, count * datatype.size);
            for (i2 = this.Size() - 1; i2 > this.Rank(); --i2) {
                req[i2] = this.isend(sendbuf, sendoffset, count, datatype, i2, this.scanTag, false);
            }
            for (i2 = 0; i2 < this.Rank(); ++i2) {
                this.recv(recvbuf, recvoffset, count, datatype, i2, this.scanTag, false);
                op.funct.Call(recvbuf, recvoffset, tmpbuf, sendoffset, count, datatype);
            }
            for (i2 = this.Size() - 1; i2 > this.Rank(); --i2) {
                req[i2].Wait();
            }
            System.arraycopy(tmpbuf, sendoffset, recvbuf, recvoffset, count * datatype.size);
            return;
        }
        Op op2 = op.worker.getWorker(datatype);
        op2.createInitialBuffer(sendbuf, sendoffset, count);
        Request[] req = new Request[this.Size()];
        for (i = this.Size() - 1; i > this.Rank(); --i) {
            req[i] = this.isend(sendbuf, sendoffset, count, datatype, i, this.scanTag, false);
        }
        for (i = 0; i < this.Rank(); ++i) {
            this.recv(recvbuf, recvoffset, count, datatype, i, this.scanTag, false);
            op2.perform(recvbuf, recvoffset, count);
        }
        op2.getResultant(recvbuf, recvoffset, count);
        for (i = this.Size() - 1; i > this.Rank(); --i) {
            req[i].Wait();
        }
    }

    public Cartcomm Create_cart(int[] dims, boolean[] periods, boolean reorder) throws MPIException {
        int totalProcess = this.group.Size();
        int places = 1;
        mpjdev.Comm ncomm = this.mpjdevComm;
        Group ngroup = this.group;
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] < 0) {
                throw new MPIException("dims[" + i + "] is less than than zero");
            }
            places *= dims[i];
        }
        if (places > totalProcess) {
            throw new MPIException(" Error in Intracomm.Create_cart: total grid positions <" + places + "> are greater than " + " total processes <" + totalProcess + ">");
        }
        if (places < totalProcess) {
            int[] excl = new int[totalProcess - places];
            for (int i = 0; i < excl.length; ++i) {
                excl[i] = i + places;
            }
            try {
                ngroup = ngroup.Excl(excl);
                ncomm = ncomm.create(ngroup.mpjdevGroup);
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
        }
        ngroup = this.group;
        try {
            ncomm = ncomm.create(ngroup.mpjdevGroup);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        if (ngroup.Rank() == -1) {
            return null;
        }
        return new Cartcomm(dims, periods, reorder, ncomm, ngroup.mpjdevGroup);
    }

    public Graphcomm Create_graph(int[] index, int[] edges, boolean reorder) {
        int size = this.group.Size();
        int nnodes = index.length;
        mpjdev.Comm ncomm = this.mpjdevComm;
        Group ngroup = this.group;
        if (nnodes > size) {
            throw new MPIException(" Error in Intracomm.Create_graphs: total nodes <" + nnodes + "> are greater than " + " total processes <" + size + ">");
        }
        if (nnodes < size) {
            int[] excl = new int[size - nnodes];
            for (int i = 0; i < excl.length; ++i) {
                excl[i] = i + nnodes;
            }
            try {
                ngroup = ngroup.Excl(excl);
                ncomm = ncomm.create(ngroup.mpjdevGroup);
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
        }
        ngroup = this.group;
        try {
            ncomm = ncomm.create(ngroup.mpjdevGroup);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        if (ngroup.Rank() == -1) {
            return null;
        }
        return new Graphcomm(index, edges, reorder, ncomm, ngroup.mpjdevGroup);
    }
}

