/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.nio.ByteBuffer;
import mpi.BasicType;
import mpi.Datatype;
import mpi.GatherPackerFactory;
import mpi.GenericPacker;
import mpi.MPI;
import mpi.MPIException;
import mpi.Packer;
import mpjbuf.Buffer;
import mpjbuf.BufferFactory;
import mpjbuf.NIOBuffer;
import mpjbuf.RawBuffer;

public class Indexed
extends Datatype {
    private int[] blockLengths;
    private int[] displacements;
    private boolean unitsOfOldExtent;
    private boolean unitBlocks;
    private Datatype oldType;
    int numBlocks;
    int repetitions;

    public Indexed(int[] array_of_blocklengths, int[] array_of_displacements, Datatype oldType, boolean unitsOfOldExtent) throws MPIException {
        int i;
        this.oldType = oldType;
        this.bufferType = oldType.bufferType;
        this.unitsOfOldExtent = unitsOfOldExtent;
        int oldExtent = oldType.Extent();
        this.numBlocks = array_of_blocklengths.length;
        this.repetitions = 0;
        this.unitBlocks = true;
        for (i = 0; i < this.numBlocks; ++i) {
            int blockLength = array_of_blocklengths[i];
            if (blockLength < 0) {
                throw new MPIException("All block-lengths for Indexed/Hindexed must be non-negative");
            }
            this.repetitions += blockLength;
            if (blockLength == 1) continue;
            this.unitBlocks = false;
        }
        if (!this.unitBlocks) {
            this.blockLengths = new int[this.numBlocks];
            for (i = 0; i < this.numBlocks; ++i) {
                this.blockLengths[i] = array_of_blocklengths[i];
            }
        }
        this.displacements = new int[this.numBlocks];
        if (unitsOfOldExtent) {
            for (i = 0; i < this.numBlocks; ++i) {
                this.displacements[i] = oldExtent * array_of_displacements[i];
            }
        } else {
            for (i = 0; i < this.numBlocks; ++i) {
                this.displacements[i] = array_of_displacements[i];
            }
        }
        this.baseType = oldType.baseType;
        int oldSize = oldType.Size();
        this.size = this.repetitions * oldSize;
        this.byteSize = this.repetitions * oldType.byteSize;
        this.computeBounds(oldSize);
    }

    private void computeBounds(int oldSize) {
        this.ubSet = this.repetitions > 0 && this.oldType.ubSet;
        this.lbSet = this.repetitions > 0 && this.oldType.lbSet;
        this.lb = Integer.MAX_VALUE;
        this.ub = Integer.MIN_VALUE;
        this.extent = 0;
        if (oldSize != 0 || this.oldType.lbSet || this.oldType.ubSet) {
            int oldExtent = this.oldType.extent;
            for (int i = 0; i < this.numBlocks; ++i) {
                int min_lb;
                int blockLen;
                int n = blockLen = this.unitBlocks ? 1 : this.blockLengths[i];
                if (blockLen <= 0) continue;
                int startBlock = this.displacements[i];
                int max_ub = startBlock + (blockLen - 1) * oldExtent + this.oldType.ub;
                if (max_ub > this.ub) {
                    this.ub = max_ub;
                }
                if ((min_lb = startBlock + this.oldType.lb) >= this.lb) continue;
                this.lb = min_lb;
            }
            this.extent = this.ub - this.lb;
        }
    }

    @Override
    Buffer createWriteBuffer(ByteBuffer slicedBuffer, int messageSize) {
        return new Buffer(new NIOBuffer(messageSize, slicedBuffer), MPI.BSEND_OVERHEAD, messageSize);
    }

    @Override
    Buffer createWriteBuffer(int count) throws MPIException {
        int capacity = this.packedSize(count) + MPI.SEND_OVERHEAD;
        int offset = MPI.SEND_OVERHEAD;
        RawBuffer rawBuffer = BufferFactory.create(capacity);
        Buffer wBuffer = new Buffer(rawBuffer, offset, capacity);
        try {
            wBuffer.putSectionHeader(this.bufferType);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        return wBuffer;
    }

    @Override
    Buffer createReadBuffer(int count) {
        int capacity = this.packedSize(count) + MPI.RECV_OVERHEAD;
        int offset = MPI.RECV_OVERHEAD;
        RawBuffer rawBuffer = BufferFactory.create(capacity);
        Buffer mpjbuf = new Buffer(rawBuffer, offset, capacity);
        return mpjbuf;
    }

    @Override
    int packedSize(int count) {
        int dataSize = count * this.byteSize;
        int totalSize = 0;
        int sectionHeader = 8;
        totalSize = sectionHeader + dataSize;
        int padding = 0;
        if (totalSize % 8 != 0) {
            padding = totalSize % 8;
        }
        return totalSize + padding;
    }

    @Override
    void setPacker() {
        this.packer = this.oldType instanceof BasicType && this.unitBlocks ? GatherPackerFactory.create(this.numBlocks, this.displacements, this.baseType, this.extent) : new IndexedPacker();
    }

    private class IndexedPacker
    extends GenericPacker {
        Packer itemPacker;
        int itemSize;
        int numBlocks;

        IndexedPacker() {
            super(Indexed.this.extent, Indexed.this.size);
            this.itemPacker = Indexed.this.oldType.getPacker();
            this.itemSize = ((Indexed)Indexed.this).oldType.extent;
        }

        @Override
        public void pack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
            int numBlocks = Indexed.this.displacements.length;
            for (int i = 0; i < numBlocks; ++i) {
                int boffset = offset + Indexed.this.displacements[i];
                int blockLen = Indexed.this.unitBlocks ? 1 : Indexed.this.blockLengths[i];
                this.itemPacker.pack(mpjbuf, buf, boffset, blockLen);
            }
        }

        @Override
        public void unpack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
            int numBlocks = Indexed.this.displacements.length;
            for (int i = 0; i < numBlocks; ++i) {
                int boffset = offset + Indexed.this.displacements[i];
                int blockLen = Indexed.this.unitBlocks ? 1 : Indexed.this.blockLengths[i];
                this.itemPacker.unpack(mpjbuf, buf, boffset, blockLen);
            }
        }

        @Override
        public void unpackPartial(Buffer mpjbuf, int length, Object buf, int offset) throws MPIException {
            int remaining = length;
            for (int i = 0; i < Indexed.this.displacements.length; ++i) {
                int boffset = offset + Indexed.this.displacements[i];
                int blockLen = Indexed.this.unitBlocks ? 1 : Indexed.this.blockLengths[i];
                int blockSize = blockLen * this.itemSize;
                if (blockSize < remaining) {
                    this.itemPacker.unpack(mpjbuf, buf, boffset, blockLen);
                    remaining -= blockSize;
                    continue;
                }
                int numFull = remaining / this.itemSize;
                int fullItemsSize = numFull * this.itemSize;
                this.itemPacker.unpack(mpjbuf, buf, boffset, numFull);
                this.itemPacker.unpackPartial(mpjbuf, remaining - fullItemsSize, buf, boffset + fullItemsSize);
                return;
            }
        }
    }
}

