/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Freeable;
import mpi.MPI;
import mpi.MPIException;
import xdev.ProcessID;

public class Group
implements Freeable {
    static final int NULL = 2;
    static final int EMPTY = 3;
    int code = -1;
    public mpjdev.Group mpjdevGroup = null;

    Group(mpjdev.Group mpjdevGroup) {
        this.mpjdevGroup = mpjdevGroup == null ? new mpjdev.Group(new ProcessID[0], null, -1) : mpjdevGroup;
    }

    Group(int code) {
        this.code = code;
    }

    @Override
    public void free() {
    }

    public int Size() throws MPIException {
        return this.mpjdevGroup != null ? this.mpjdevGroup.size() : MPI.UNDEFINED;
    }

    public int Rank() throws MPIException {
        return this.mpjdevGroup.rank();
    }

    public static int[] Translate_ranks(Group group1, int[] ranks1, Group group2) throws MPIException {
        return mpjdev.Group.transRanks(group1.mpjdevGroup, ranks1, group2.mpjdevGroup);
    }

    public static int Compare(Group group1, Group group2) throws MPIException {
        if (group1 == null || group1 == null) {
            throw new MPIException(" Group.Compare does not accept null groups");
        }
        if (group1.code == 3 && group2.code == 3) {
            throw new MPIException("Group.Compare cannot compare empty groups");
        }
        if (group1.code == 3) {
            return 2;
        }
        if (group2.code == 3) {
            return 2;
        }
        if (group1.code == 2 && group2.code == 2) {
            throw new MPIException("Group.Compare cannot compare null groups");
        }
        if (group1.code == 2) {
            return 2;
        }
        if (group2.code == 2) {
            return 2;
        }
        return mpjdev.Group.compare(group1.mpjdevGroup, group2.mpjdevGroup);
    }

    public static Group Union(Group group1, Group group2) throws MPIException {
        if (group1 == null || group2 == null) {
            throw new MPIException("Group.Union does not accept null groups asarguments");
        }
        if (group1.code == 2 && group2.code == 2) {
            return MPI.GROUP_NULL;
        }
        if (group2.code == 2) {
            return group1;
        }
        if (group1.code == 2) {
            return group2;
        }
        if (group1.code == 3 && group2.code == 3) {
            return MPI.GROUP_EMPTY;
        }
        if (group2.code == 3) {
            return group1;
        }
        if (group1.code == 3) {
            return group2;
        }
        return new Group(mpjdev.Group.union(group1.mpjdevGroup, group2.mpjdevGroup));
    }

    public static Group Intersection(Group group1, Group group2) throws MPIException {
        if (group1 == null || group2 == null) {
            throw new MPIException("Group.Union does not accept null groups asarguments");
        }
        if (group1.code == 2 || group2.code == 2) {
            return MPI.GROUP_NULL;
        }
        if (group1.code == 3 || group2.code == 3) {
            return MPI.GROUP_EMPTY;
        }
        return new Group(mpjdev.Group.intersection(group1.mpjdevGroup, group2.mpjdevGroup));
    }

    public static Group Difference(Group group1, Group group2) throws MPIException {
        if (group1 == null || group2 == null) {
            throw new MPIException("Group.Union does not accept null groups asarguments");
        }
        if (group1.code == 2) {
            return MPI.GROUP_NULL;
        }
        if (group2.code == 2) {
            return group1;
        }
        if (group1.code == 3) {
            return MPI.GROUP_EMPTY;
        }
        if (group2.code == 3) {
            return group1;
        }
        return new Group(mpjdev.Group.difference(group1.mpjdevGroup, group2.mpjdevGroup));
    }

    public Group Incl(int[] ranks) throws MPIException {
        if (ranks == null) {
            throw new MPIException("Group.Incl does not accept a null integer  array ");
        }
        if (ranks.length == 0) {
            return MPI.GROUP_EMPTY;
        }
        return new Group(this.mpjdevGroup.incl(ranks));
    }

    public Group Excl(int[] ranks) throws MPIException {
        if (ranks == null) {
            throw new MPIException("Group.Excl does not accept a null integer  array ");
        }
        if (ranks.length == 0) {
            return this;
        }
        return new Group(this.mpjdevGroup.excl(ranks));
    }

    public Group Range_incl(int[][] ranges) throws MPIException {
        if (ranges == null) {
            throw new MPIException("Group.Range_incl does not accept null integer array as argument");
        }
        return new Group(this.mpjdevGroup.rangeIncl(ranges));
    }

    public Group Range_excl(int[][] ranges) throws MPIException {
        if (ranges == null) {
            throw new MPIException("Group.Range_incl does not accept null integer array as argument");
        }
        return new Group(this.mpjdevGroup.rangeExcl(ranges));
    }

    public void finalize() throws MPIException {
    }
}

