/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.MPIException;
import mpi.Packer;
import mpjbuf.Buffer;

public abstract class GenericPacker
implements Packer {
    int extent;
    int size;

    public GenericPacker(int extent, int size) {
        this.extent = extent;
        this.size = size;
    }

    @Override
    public void pack(Buffer mpjbuf, Object buf, int offset, int count) throws MPIException {
        for (int i = 0; i < count; ++i) {
            this.pack(mpjbuf, buf, offset);
            offset += this.extent;
        }
    }

    @Override
    public void unpack(Buffer mpjbuf, int length, Object buf, int offset, int count) throws MPIException {
        if (this.size == 0) {
            return;
        }
        if (count * this.size < length) {
            throw new MPIException("Error in GenericPacker: count*size <" + count * this.size + " is less than length <" + length + ">");
        }
        int numFull = length / this.size;
        for (int i = 0; i < numFull; ++i) {
            this.unpack(mpjbuf, buf, offset);
            offset += this.extent;
        }
        int residue = length - numFull * this.size;
        if (residue > 0) {
            this.unpackPartial(mpjbuf, residue, buf, offset);
        }
    }

    @Override
    public void unpack(Buffer mpjbuf, Object buf, int offset, int count) throws MPIException {
        for (int i = 0; i < count; ++i) {
            this.unpack(mpjbuf, buf, offset);
            offset += this.extent;
        }
    }
}

