/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.GenericPacker;
import mpi.MPIException;
import mpjbuf.Buffer;

public class GatherPackerShort
extends GenericPacker {
    public int[] displacements;

    public GatherPackerShort(int numEls, int[] displacements, int extent) {
        super(extent, numEls);
        this.displacements = displacements;
    }

    @Override
    public void pack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
        try {
            mpjbuf.gather((short[])buf, this.size, offset, this.displacements);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    @Override
    public void unpack(Buffer mpjbuf, Object buf, int offset) throws MPIException {
        try {
            mpjbuf.scatter((short[])buf, this.size, offset, this.displacements);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    @Override
    public void unpackPartial(Buffer mpjbuf, int length, Object buf, int offset) throws MPIException {
        try {
            mpjbuf.scatter((short[])buf, this.size, offset, this.displacements);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }
}

