/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.nio.ByteBuffer;
import mpi.Contiguous;
import mpi.Freeable;
import mpi.Indexed;
import mpi.MPIException;
import mpi.Packer;
import mpi.Struct;
import mpi.Vector;
import mpjbuf.Buffer;
import mpjbuf.Type;

public abstract class Datatype
implements Freeable {
    Type bufferType = Type.UNDEFINED;
    static final int UNDEFINED = -1;
    static final int NULL = 0;
    static final int BYTE = 1;
    static final int CHAR = 2;
    static final int SHORT = 3;
    static final int BOOLEAN = 4;
    static final int INT = 5;
    static final int LONG = 6;
    static final int FLOAT = 7;
    static final int DOUBLE = 8;
    static final int PACKED = 9;
    static final int LB = 10;
    static final int UB = 11;
    static final int OBJECT = 12;
    static final int SHORT2 = 3;
    static final int INT2 = 5;
    static final int LONG2 = 6;
    static final int FLOAT2 = 7;
    static final int DOUBLE2 = 8;
    int numEls;
    int baseType = -1;
    int size;
    int byteSize;
    int lb;
    int ub;
    int extent;
    boolean ubSet;
    boolean lbSet;
    Packer packer;

    Packer getPacker() {
        if (this.packer == null) {
            this.setPacker();
        }
        return this.packer;
    }

    abstract void setPacker();

    abstract Buffer createWriteBuffer(int var1) throws MPIException;

    abstract Buffer createWriteBuffer(ByteBuffer var1, int var2);

    abstract Buffer createReadBuffer(int var1);

    abstract int packedSize(int var1);

    public int Extent() throws MPIException {
        return this.extent;
    }

    public int Size() throws MPIException {
        return this.size;
    }

    public int Lb() throws MPIException {
        return this.lb;
    }

    public int Ub() throws MPIException {
        return this.ub;
    }

    public void Commit() throws MPIException {
    }

    public void finalize() throws MPIException {
    }

    public static Datatype Contiguous(int count, Datatype oldtype) throws MPIException {
        return new Contiguous(count, oldtype);
    }

    public static Datatype Vector(int count, int blocklength, int stride, Datatype oldtype) throws MPIException {
        return new Vector(count, blocklength, stride, oldtype, true);
    }

    public static Datatype Hvector(int count, int blocklength, int stride, Datatype oldtype) throws MPIException {
        return new Vector(count, blocklength, stride, oldtype, false);
    }

    public static Datatype Indexed(int[] array_of_blocklengths, int[] array_of_displacements, Datatype oldtype) throws MPIException {
        return new Indexed(array_of_blocklengths, array_of_displacements, oldtype, true);
    }

    public static Datatype Hindexed(int[] array_of_blocklengths, int[] array_of_displacements, Datatype oldtype) throws MPIException {
        return new Indexed(array_of_blocklengths, array_of_displacements, oldtype, false);
    }

    public static Datatype Struct(int[] array_of_blocklengths, int[] array_of_displacements, Datatype[] array_of_types) throws MPIException {
        return new Struct(array_of_blocklengths, array_of_displacements, array_of_types);
    }

    @Override
    public void free() {
    }
}

