/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Hashtable;
import mpi.Datatype;
import mpi.Group;
import mpi.Intercomm;
import mpi.MPI;
import mpi.MPIException;
import mpi.Packer;
import mpi.Prequest;
import mpi.Request;
import mpi.Status;
import mpjbuf.Buffer;
import mpjbuf.BufferFactory;
import mpjbuf.Type;
import mpjdev.CompletionHandler;

public class Comm {
    Hashtable attrTable = new Hashtable();
    public Group group = null;
    Group localgroup = null;
    public mpjdev.Comm mpjdevComm = null;
    boolean intercomm = false;
    static final int NULL = 2;
    int code = -1;

    Comm() {
    }

    Comm(int code) {
        this.code = code;
    }

    public int Size() throws MPIException {
        return this.intercomm ? this.localgroup.Size() : this.group.Size();
    }

    public int Rank() throws MPIException {
        return this.intercomm ? this.localgroup.Rank() : this.group.Rank();
    }

    public Group Group() throws MPIException {
        return this.intercomm ? this.localgroup : this.group;
    }

    public static int Compare(Comm comm1, Comm comm2) throws MPIException {
        if (!comm1.intercomm && !comm2.intercomm) {
            int val = 0;
            val = Group.Compare(comm1.group, comm2.group);
            if (val == 0) {
                if (comm1.mpjdevComm.sendctxt == comm2.mpjdevComm.sendctxt) {
                    return 0;
                }
                return 3;
            }
            return val;
        }
        int val1 = Group.Compare(comm1.group, comm1.group);
        int val2 = Group.Compare(comm1.localgroup, comm1.localgroup);
        if (val1 == 0 && val2 == 0) {
            if (comm1.mpjdevComm.sendctxt == comm2.mpjdevComm.sendctxt && comm1.mpjdevComm.recvctxt == comm2.mpjdevComm.recvctxt) {
                return 0;
            }
            return 3;
        }
        if (val1 == val2) {
            return val1;
        }
        if (val1 == 1 && val2 == 1) {
            return 1;
        }
        return 2;
    }

    public void Free() throws MPIException {
    }

    public boolean Test_inter() throws MPIException {
        return this.intercomm;
    }

    public Intercomm Create_intercomm(Comm local_comm, int local_leader, int remote_leader, int tag) throws MPIException {
        if (local_comm.Rank() == -1) {
            throw new MPIException(" Error in Create_intercomm:  rank <" + local_comm.Rank() + "> is -1");
        }
        mpjdev.Comm newIntercomm = null;
        try {
            newIntercomm = this.mpjdevComm.create(local_comm.mpjdevComm, this.group.mpjdevGroup, local_leader, remote_leader, tag);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        return new Intercomm(newIntercomm, newIntercomm.localgroup, newIntercomm.group, this, local_leader, remote_leader, local_comm);
    }

    public Object Attr_get(int keyval) throws MPIException {
        Object value = this.attrTable.get(new Integer(keyval));
        if (value != null) {
            return value;
        }
        throw new MPIException(" Error in Attr_get: No corresponding value to key <" + keyval + ">");
    }

    public void Attr_delete(int keyval) throws MPIException {
        try {
            this.attrTable.remove(new Integer(keyval));
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    void Attr_put(int key, int val) throws MPIException {
        try {
            this.attrTable.put(new Integer(key), new Integer(val));
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    public void Send(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        this.send(buf, offset, count, datatype, dest, tag, true);
    }

    protected void send(Object buf, int offset, int count, Datatype datatype, int dest, int tag, boolean pt2pt) throws MPIException {
        if (datatype.baseType == 9) {
            Buffer mpjbuf = (Buffer)buf;
            try {
                mpjbuf.commit();
                this.mpjdevComm.send(mpjbuf, dest, tag, pt2pt);
                mpjbuf.clear();
                mpjbuf.free();
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            return;
        }
        Packer packer = datatype.getPacker();
        Buffer wBuffer = datatype.createWriteBuffer(count);
        try {
            packer.pack(wBuffer, buf, offset, count);
            wBuffer.commit();
            this.mpjdevComm.send(wBuffer, dest, tag, pt2pt);
            wBuffer.clear();
            wBuffer.free();
            BufferFactory.destroy(wBuffer.getStaticBuffer());
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    public void Ssend(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        this.ssend(buf, offset, count, datatype, dest, tag, true);
    }

    protected void ssend(Object buf, int offset, int count, Datatype datatype, int dest, int tag, boolean pt2pt) throws MPIException {
        if (datatype.baseType == 9) {
            Buffer mpjbuf = (Buffer)buf;
            try {
                mpjbuf.commit();
                this.mpjdevComm.ssend(mpjbuf, dest, tag, pt2pt);
                mpjbuf.clear();
                mpjbuf.free();
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            return;
        }
        Packer packer = datatype.getPacker();
        Buffer wBuffer = datatype.createWriteBuffer(count);
        try {
            packer.pack(wBuffer, buf, offset, count);
            wBuffer.commit();
            this.mpjdevComm.ssend(wBuffer, dest, tag, pt2pt);
            wBuffer.clear();
            wBuffer.free();
            BufferFactory.destroy(wBuffer.getStaticBuffer());
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    public void Bsend(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        this.bsend(buf, offset, count, datatype, dest, tag, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bsend(Object buf, int offset, int count, Datatype datatype, int dest, int tag, boolean pt2pt) throws MPIException {
        if (datatype.baseType == 9) {
            Buffer mpjbuf = (Buffer)buf;
            try {
                mpjbuf.commit();
                this.mpjdevComm.send(mpjbuf, dest, tag, pt2pt);
                mpjbuf.clear();
                mpjbuf.free();
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            return;
        }
        if (MPI.buffer == null) {
            throw new MPIException(" Error in MPI.Bsend: No buffer has been attached ");
        }
        ByteBuffer byteBuffer = MPI.buffer;
        synchronized (byteBuffer) {
            int ptr;
            PendingMessage.clearFront();
            Packer packer = datatype.getPacker();
            int messageSize = datatype.packedSize(count) + MPI.BSEND_OVERHEAD;
            if (PendingMessage.tailPtr + messageSize <= MPI.buffer.capacity()) {
                ptr = PendingMessage.tailPtr;
            } else if (messageSize <= PendingMessage.headPtr) {
                ptr = 0;
            } else {
                throw new MPIException("Error in MPI.Bsend: No space left in buffer.");
            }
            ByteBuffer slicedBuffer = null;
            MPI.buffer.position(ptr);
            MPI.buffer.limit(messageSize);
            slicedBuffer = MPI.buffer.slice();
            Buffer mpjbuf = datatype.createWriteBuffer(slicedBuffer, messageSize);
            try {
                mpjbuf.putSectionHeader(datatype.bufferType);
                packer.pack(mpjbuf, buf, offset, count);
                mpjbuf.commit();
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            PendingMessage pending = new PendingMessage();
            try {
                pending.request = new Request(this.mpjdevComm.isend(mpjbuf, dest, tag, pt2pt));
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            pending.ptr = ptr;
            pending.len = messageSize;
            pending.mpjbuf = mpjbuf;
            ArrayList<Request> arrayList = MPI.pendingRequests;
            synchronized (arrayList) {
                MPI.pendingRequests.add(pending.request);
            }
            PendingMessage.add(pending);
        }
    }

    public void Rsend(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        this.rsend(buf, offset, count, datatype, dest, tag, true);
    }

    protected void rsend(Object buf, int offset, int count, Datatype datatype, int dest, int tag, boolean pt2pt) throws MPIException {
        if (datatype.baseType == 9) {
            Buffer mpjbuf = (Buffer)buf;
            try {
                mpjbuf.commit();
                this.mpjdevComm.send(mpjbuf, dest, tag, pt2pt);
                mpjbuf.clear();
                mpjbuf.free();
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            return;
        }
        Packer packer = datatype.getPacker();
        Buffer wBuffer = datatype.createWriteBuffer(count);
        try {
            packer.pack(wBuffer, buf, offset, count);
            wBuffer.commit();
            this.mpjdevComm.send(wBuffer, dest, tag, pt2pt);
            wBuffer.clear();
            wBuffer.free();
            BufferFactory.destroy(wBuffer.getStaticBuffer());
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    public Request Isend(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        return this.isend(buf, offset, count, datatype, dest, tag, true);
    }

    protected Request isend(Object buf, int offset, int count, Datatype datatype, int dest, int tag, boolean pt2pt) throws MPIException {
        if (datatype.baseType == 9) {
            final Buffer mpjbuf = (Buffer)buf;
            mpjdev.Request request = null;
            try {
                mpjbuf.commit();
                request = this.mpjdevComm.isend(mpjbuf, dest, tag, pt2pt);
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            request.addCompletionHandler(new CompletionHandler(){

                @Override
                public void handleCompletion(mpjdev.Status status) {
                    try {
                        mpjbuf.clear();
                        mpjbuf.free();
                    }
                    catch (Exception e) {
                        throw new MPIException(e);
                    }
                }
            });
            return new Request(request);
        }
        Packer packer = datatype.getPacker();
        final Buffer wBuffer = datatype.createWriteBuffer(count);
        mpjdev.Request request = null;
        final int t = tag;
        final int d = dest;
        try {
            packer.pack(wBuffer, buf, offset, count);
            wBuffer.commit();
            request = this.mpjdevComm.isend(wBuffer, dest, tag, pt2pt);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        request.addCompletionHandler(new CompletionHandler(){

            @Override
            public void handleCompletion(mpjdev.Status status) {
                try {
                    wBuffer.clear();
                    wBuffer.free();
                    BufferFactory.destroy(wBuffer.getStaticBuffer());
                }
                catch (Exception e) {
                    throw new MPIException(e);
                }
            }
        });
        return new Request(request);
    }

    public Request Ibsend(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        return this.ibsend(buf, offset, count, datatype, dest, tag, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Request ibsend(Object buf, int offset, int count, Datatype datatype, int dest, int tag, boolean pt2pt) throws MPIException {
        if (datatype.baseType == 9) {
            final Buffer mpjbuf = (Buffer)buf;
            mpjdev.Request request = null;
            try {
                mpjbuf.commit();
                request = this.mpjdevComm.isend(mpjbuf, dest, tag, pt2pt);
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            request.addCompletionHandler(new CompletionHandler(){

                @Override
                public void handleCompletion(mpjdev.Status status) {
                    try {
                        mpjbuf.clear();
                        mpjbuf.free();
                    }
                    catch (Exception e) {
                        throw new MPIException(e);
                    }
                }
            });
            return new Request(request);
        }
        if (MPI.buffer == null) {
            throw new MPIException("Error:No buffer has been attached,can't use Bsend");
        }
        ByteBuffer byteBuffer = MPI.buffer;
        synchronized (byteBuffer) {
            int ptr;
            PendingMessage.clearFront();
            Packer packer = datatype.getPacker();
            int messageSize = datatype.packedSize(count) + MPI.BSEND_OVERHEAD;
            if (PendingMessage.tailPtr + messageSize <= MPI.buffer.capacity()) {
                ptr = PendingMessage.tailPtr;
            } else if (messageSize <= PendingMessage.headPtr) {
                ptr = 0;
            } else {
                throw new MPIException("No space left in buffer.");
            }
            ByteBuffer slicedBuffer = null;
            MPI.buffer.position(ptr);
            MPI.buffer.limit(messageSize);
            slicedBuffer = MPI.buffer.slice();
            Buffer mpjbuf = datatype.createWriteBuffer(slicedBuffer, messageSize);
            try {
                mpjbuf.putSectionHeader(datatype.bufferType);
                packer.pack(mpjbuf, buf, offset, count);
                mpjbuf.commit();
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            PendingMessage pending = new PendingMessage();
            try {
                pending.request = new Request(this.mpjdevComm.isend(mpjbuf, dest, tag, pt2pt));
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            pending.ptr = ptr;
            pending.len = messageSize;
            pending.mpjbuf = mpjbuf;
            ArrayList<Request> arrayList = MPI.pendingRequests;
            synchronized (arrayList) {
                MPI.pendingRequests.add(pending.request);
            }
            PendingMessage.add(pending);
            return pending.request;
        }
    }

    public Request Issend(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        return this.issend(buf, offset, count, datatype, dest, tag, true);
    }

    protected Request issend(Object buf, int offset, int count, Datatype datatype, int dest, int tag, boolean pt2pt) throws MPIException {
        if (datatype.baseType == 9) {
            final Buffer mpjbuf = (Buffer)buf;
            mpjdev.Request request = null;
            try {
                mpjbuf.commit();
                request = this.mpjdevComm.issend(mpjbuf, dest, tag, pt2pt);
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            request.addCompletionHandler(new CompletionHandler(){

                @Override
                public void handleCompletion(mpjdev.Status status) {
                    try {
                        mpjbuf.clear();
                        mpjbuf.free();
                    }
                    catch (Exception e) {
                        throw new MPIException(e);
                    }
                }
            });
            return new Request(request);
        }
        Packer packer = datatype.getPacker();
        final Buffer wBuffer = datatype.createWriteBuffer(count);
        mpjdev.Request request = null;
        try {
            packer.pack(wBuffer, buf, offset, count);
            wBuffer.commit();
            request = this.mpjdevComm.issend(wBuffer, dest, tag, pt2pt);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        request.addCompletionHandler(new CompletionHandler(){

            @Override
            public void handleCompletion(mpjdev.Status status) {
                try {
                    wBuffer.clear();
                    wBuffer.free();
                    BufferFactory.destroy(wBuffer.getStaticBuffer());
                }
                catch (Exception e) {
                    throw new MPIException(e);
                }
            }
        });
        return new Request(request);
    }

    public Request Irsend(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        return this.irsend(buf, offset, count, datatype, dest, tag, true);
    }

    protected Request irsend(Object buf, int offset, int count, Datatype datatype, int dest, int tag, boolean pt2pt) throws MPIException {
        if (datatype.baseType == 9) {
            final Buffer mpjbuf = (Buffer)buf;
            mpjdev.Request request = null;
            try {
                mpjbuf.commit();
                request = this.mpjdevComm.isend(mpjbuf, dest, tag, pt2pt);
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            request.addCompletionHandler(new CompletionHandler(){

                @Override
                public void handleCompletion(mpjdev.Status status) {
                    try {
                        mpjbuf.clear();
                        mpjbuf.free();
                    }
                    catch (Exception e) {
                        throw new MPIException(e);
                    }
                }
            });
            return new Request(request);
        }
        Packer packer = datatype.getPacker();
        final Buffer wBuffer = datatype.createWriteBuffer(count);
        mpjdev.Request request = null;
        try {
            packer.pack(wBuffer, buf, offset, count);
            wBuffer.commit();
            request = this.mpjdevComm.isend(wBuffer, dest, tag, pt2pt);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        request.addCompletionHandler(new CompletionHandler(){

            @Override
            public void handleCompletion(mpjdev.Status status) {
                try {
                    wBuffer.clear();
                    wBuffer.free();
                    BufferFactory.destroy(wBuffer.getStaticBuffer());
                }
                catch (Exception e) {
                    throw new MPIException(e);
                }
            }
        });
        return new Request(request);
    }

    public Status Recv(Object buf, int offset, int count, Datatype datatype, int source, int tag) throws MPIException {
        try {
            return this.recv(buf, offset, count, datatype, source, tag, true);
        }
        catch (MPIException mpie) {
            throw new MPIException(mpie);
        }
    }

    protected Status recv(Object buf, int offset, int count, Datatype datatype, int source, int tag, boolean pt2pt) throws MPIException {
        if (datatype.baseType == 9) {
            Buffer mpjbuf = (Buffer)buf;
            mpjdev.Status status1 = null;
            try {
                status1 = this.mpjdevComm.recv(mpjbuf, source, tag, pt2pt);
                mpjbuf.commit();
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            Status st = new Status(status1);
            return st;
        }
        Buffer rBuffer = datatype.createReadBuffer(count);
        Packer packer = datatype.getPacker();
        mpjdev.Status status = null;
        int count_received = 0;
        try {
            status = this.mpjdevComm.recv(rBuffer, source, tag, pt2pt);
            rBuffer.commit();
            Type receivedType = rBuffer.getSectionHeader();
            count_received = rBuffer.getSectionSize();
            packer.unpack(rBuffer, count_received, buf, offset, count);
            rBuffer.clear();
            rBuffer.free();
            BufferFactory.destroy(rBuffer.getStaticBuffer());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MPIException(e);
        }
        Status st = new Status(status);
        st.numEls = count_received;
        if (datatype.size != 0) {
            int temp = st.numEls / datatype.size;
            st.count = temp * datatype.size == st.numEls ? temp : MPI.UNDEFINED;
        } else {
            st.count = count;
            st.numEls = MPI.UNDEFINED;
        }
        return st;
    }

    public Request Irecv(Object buf, int offset, int count, Datatype datatype, int src, int tag) throws MPIException {
        return this.irecv(buf, offset, count, datatype, src, tag, true);
    }

    protected Request irecv(Object buf, int offset, int count, Datatype datatype, int src, int tag, boolean pt2pt) throws MPIException {
        if (datatype.baseType == 9) {
            final Buffer mpjbuf = (Buffer)buf;
            mpjdev.Request mpjdevRequest = null;
            mpjdev.Status status = new mpjdev.Status(src, tag, -1);
            try {
                mpjdevRequest = this.mpjdevComm.irecv(mpjbuf, src, tag, status, pt2pt);
            }
            catch (Exception e) {
                throw new MPIException(e);
            }
            mpjdevRequest.addCompletionHandler(new CompletionHandler(){

                @Override
                public void handleCompletion(mpjdev.Status status) {
                    status.count = MPI.UNDEFINED;
                    status.numEls = MPI.UNDEFINED;
                    try {
                        mpjbuf.clear();
                        mpjbuf.free();
                    }
                    catch (Exception e) {
                        throw new MPIException(e);
                    }
                }
            });
            Request req = new Request(mpjdevRequest);
            return req;
        }
        final Buffer rBuffer = datatype.createReadBuffer(count);
        final Packer packer = datatype.getPacker();
        final int c = count;
        final Object buf1 = buf;
        final int off = offset;
        final int source = src;
        final int t = tag;
        final Datatype dtype = datatype;
        mpjdev.Request request = null;
        mpjdev.Status status = new mpjdev.Status(src, tag, -1);
        try {
            request = this.mpjdevComm.irecv(rBuffer, src, tag, status, pt2pt);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        request.addCompletionHandler(new CompletionHandler(){

            @Override
            public void handleCompletion(mpjdev.Status status) {
                int count_received = 0;
                try {
                    rBuffer.commit();
                    Type recType = rBuffer.getSectionHeader();
                    count_received = rBuffer.getSectionSize();
                    packer.unpack(rBuffer, count_received, buf1, off, c);
                    rBuffer.clear();
                    rBuffer.free();
                    BufferFactory.destroy(rBuffer.getStaticBuffer());
                }
                catch (Exception e) {
                    System.out.println(" tag <" + t + ">");
                    throw new MPIException(e);
                }
                status.numEls = count_received;
                if (dtype.size != 0) {
                    int temp = status.numEls / dtype.size;
                    status.count = temp * dtype.size == status.numEls ? temp : MPI.UNDEFINED;
                } else {
                    status.count = c;
                    status.numEls = MPI.UNDEFINED;
                }
                status.type = dtype.bufferType;
                for (int j = 0; j < Comm.this.mpjdevComm.group.ids.length; ++j) {
                    if (!Comm.this.mpjdevComm.group.ids[j].uuid().equals(status.srcID)) continue;
                    status.source = j;
                    break;
                }
            }
        });
        Request req = new Request(request);
        req.datatype = datatype;
        return req;
    }

    public Status Iprobe(int source, int tag) throws MPIException {
        mpjdev.Status mpjdevStatus = null;
        Status status = null;
        try {
            mpjdevStatus = this.mpjdevComm.iprobe(source, tag);
            if (mpjdevStatus == null) {
                return null;
            }
            status = new Status(mpjdevStatus);
            status.numEls = status.count = mpjdevStatus.numEls;
            return status;
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    public Status Probe(int source, int tag) throws MPIException {
        mpjdev.Status mpjdevStatus = null;
        Status status = null;
        try {
            mpjdevStatus = this.mpjdevComm.probe(source, tag);
            if (mpjdevStatus == null) {
                return null;
            }
            status = new Status(mpjdevStatus);
            status.count = mpjdevStatus.numEls;
            status.numEls = mpjdevStatus.numEls;
            return status;
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    public int Pack_size(int incount, Datatype datatype) throws MPIException {
        return datatype.packedSize(incount);
    }

    public int Pack(Object inbuf, int offset, int incount, Datatype datatype, Buffer outbuf, int position) throws MPIException {
        outbuf.setSize(position);
        Packer packer = datatype.getPacker();
        int messageSize = datatype.packedSize(incount);
        try {
            outbuf.putSectionHeader(datatype.bufferType);
            packer.pack(outbuf, inbuf, offset, incount);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        return outbuf.getSize();
    }

    public int Unpack(Buffer inbuf, int position, Object outbuf, int offset, int outcount, Datatype datatype) throws MPIException {
        int expectedSize = MPI.COMM_WORLD.Pack_size(outcount, datatype);
        inbuf.setSize(expectedSize + position);
        try {
            Packer packer = datatype.getPacker();
            Type recType = inbuf.getSectionHeader();
            int count_received = inbuf.getSectionSize();
            packer.unpack(inbuf, count_received, outbuf, offset, outcount);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        return inbuf.getSize();
    }

    public Prequest Bsend_init(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        Prequest preq = new Prequest(buf, offset, count, datatype, dest, tag, 1, this);
        return preq;
    }

    public Prequest Send_init(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        Prequest preq = new Prequest(buf, offset, count, datatype, dest, tag, 3, this);
        return preq;
    }

    public Prequest Ssend_init(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        Prequest preq = new Prequest(buf, offset, count, datatype, dest, tag, 5, this);
        return preq;
    }

    public Prequest Rsend_init(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        Prequest preq = new Prequest(buf, offset, count, datatype, dest, tag, 2, this);
        return preq;
    }

    public Prequest Recv_init(Object buf, int offset, int count, Datatype datatype, int dest, int tag) throws MPIException {
        Prequest preq = new Prequest(buf, offset, count, datatype, dest, tag, 4, this);
        return preq;
    }

    public Status Sendrecv(Object sendbuf, int sendoffset, int sendcount, Datatype sendtype, int dest, int sendtag, Object recvbuf, int recvoffset, int recvcount, Datatype recvtype, int source, int recvtag) throws MPIException {
        Status status = null;
        Request recvRequest = null;
        Request request = null;
        recvRequest = this.Irecv(recvbuf, recvoffset, recvcount, recvtype, source, recvtag);
        request = this.Isend(sendbuf, sendoffset, sendcount, sendtype, dest, sendtag);
        status = recvRequest.Wait();
        request.Wait();
        return status;
    }

    public Status Sendrecv_replace(Object buf, int offset, int count, Datatype datatype, int dest, int sendtag, int source, int recvtag) throws MPIException {
        Request request = this.Isend(buf, offset, count, datatype, dest, sendtag);
        Status status = this.Recv(buf, offset, count, datatype, source, recvtag);
        request.Wait();
        return status;
    }

    protected Status sendrecv(Object sendbuf, int sendoffset, int sendcount, Datatype sendtype, int dest, int sendtag, Object recvbuf, int recvoffset, int recvcount, Datatype recvtype, int source, int recvtag) throws MPIException {
        Request recvRequest = this.Irecv(recvbuf, recvoffset, recvcount, recvtype, source, recvtag);
        Request request = this.Isend(sendbuf, sendoffset, sendcount, sendtype, dest, sendtag);
        request.Wait();
        Status status = recvRequest.Wait();
        return status;
    }

    public int Topo_test() throws MPIException {
        return -1;
    }

    public void Abort(int errorcode) throws MPIException {
    }

    public Object clone() throws MPIException {
        return this;
    }

    static class PendingMessage {
        Request request;
        Buffer mpjbuf;
        int ptr;
        int len;
        PendingMessage next;
        public static int queue_size = 0;
        static int headPtr = 0;
        static int tailPtr = 0;
        static PendingMessage front = null;
        static PendingMessage back = null;

        PendingMessage() {
        }

        static void add(PendingMessage pending) {
            if (back != null) {
                PendingMessage.back.next = pending;
                back = pending;
                tailPtr += PendingMessage.back.len;
            } else {
                front = pending;
                back = pending;
                tailPtr = pending.len;
                pending.next = null;
            }
            ++queue_size;
        }

        static void clearFront() {
            PendingMessage pending = front;
            while (pending != null) {
                if (pending.request.Test() != null) {
                    pending = pending.next;
                    if (pending != null) {
                    } else {
                        tailPtr = 0;
                        front = null;
                        back = null;
                        headPtr = 0;
                    }
                    --queue_size;
                    continue;
                }
                front = pending;
                headPtr = PendingMessage.front.ptr;
            }
        }
    }
}

