/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.CartParms;
import mpi.Intracomm;
import mpi.MPI;
import mpi.MPIException;
import mpi.ShiftParms;
import mpjdev.Comm;
import mpjdev.Group;

public class Cartcomm
extends Intracomm {
    CartParms cartParms = null;

    Cartcomm(int[] dims, boolean[] periods, boolean reorder, Comm mpjdevComm, Group group) throws MPIException {
        super(mpjdevComm, group);
        int rank = group.rank();
        this.cartParms = new CartParms();
        this.cartParms.dims = new int[dims.length];
        System.arraycopy(dims, 0, this.cartParms.dims, 0, dims.length);
        this.cartParms.periods = new boolean[periods.length];
        System.arraycopy(periods, 0, this.cartParms.periods, 0, this.cartParms.periods.length);
        try {
            this.cartParms.coords = this.Coords(rank);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
    }

    @Override
    public Object clone() throws MPIException {
        return this.Create_cart(this.cartParms.dims, this.cartParms.periods, false);
    }

    public int Rank(int[] coords) throws MPIException {
        int i;
        int factor = 1;
        int rank = 0;
        int d = i = this.cartParms.dims.length - 1;
        int c = i;
        int ord = 0;
        int dim = 0;
        while (i >= 0) {
            dim = this.cartParms.dims[i] > 0 ? this.cartParms.dims[i] : -this.cartParms.dims[i];
            ord = coords[c];
            if (ord < 0 || ord >= dim) {
                if (dim > 0) {
                    System.out.println("Error ");
                }
                System.out.println("ord " + ord);
                System.out.println("dim " + dim);
                if ((ord %= dim) < 0) {
                    ord += dim;
                }
            }
            rank += factor * ord;
            factor *= dim;
            --i;
            --c;
            --d;
        }
        return rank;
    }

    public int[] Coords(int rank) throws MPIException {
        int nprocs;
        int dim = 0;
        int remprocs = nprocs = this.group.Size();
        int orank = rank;
        int[] coords = new int[this.cartParms.dims.length];
        for (int i = 0; i < this.cartParms.dims.length; ++i) {
            dim = this.cartParms.dims[i];
            coords[i] = rank / (remprocs /= dim);
            rank %= remprocs;
        }
        return coords;
    }

    public ShiftParms Shift(int direction, int disp) throws MPIException {
        int saved_position;
        int source_position;
        ShiftParms sParms = new ShiftParms();
        boolean factor = false;
        boolean thisdim = false;
        boolean thisperiod = false;
        int ord = 0;
        boolean srcord = false;
        boolean destord = false;
        boolean i = false;
        boolean p = false;
        int rank_src = 0;
        int rank_dst = 0;
        ord = this.group.Rank();
        if (disp == 0) {
            rank_src = ord;
            rank_dst = ord;
            sParms.rank_source = rank_src;
            sParms.rank_dest = rank_dst;
            return sParms;
        }
        boolean periodic = this.cartParms.periods[direction];
        int dest_position = source_position = (saved_position = this.cartParms.coords[direction]);
        if ((dest_position += disp) >= this.cartParms.dims[direction]) {
            dest_position = periodic ? (dest_position %= this.cartParms.dims[direction]) : -1;
        } else if (dest_position < 0) {
            dest_position = periodic ? (dest_position += this.cartParms.dims[direction]) : -1;
        }
        this.cartParms.coords[direction] = dest_position;
        rank_dst = dest_position != -1 ? this.Rank(this.cartParms.coords) : -1;
        if ((source_position -= disp) >= this.cartParms.dims[direction]) {
            source_position = periodic ? (source_position %= this.cartParms.dims[direction]) : -1;
        } else if (source_position < 0) {
            source_position = periodic ? (source_position += this.cartParms.dims[direction]) : -1;
        }
        this.cartParms.coords[direction] = source_position;
        rank_src = source_position != -1 ? this.Rank(this.cartParms.coords) : -1;
        this.cartParms.coords[direction] = saved_position;
        sParms.rank_source = rank_src;
        sParms.rank_dest = rank_dst;
        return sParms;
    }

    public Cartcomm Sub(boolean[] remain_dims) throws MPIException {
        Intracomm newcomm;
        int color = 0;
        int key = 0;
        int keyfactor = 1;
        int colfactor = 1;
        int ndim = 0;
        int dim = 0;
        boolean allfalse = false;
        for (int i = this.cartParms.dims.length - 1; i >= 0; --i) {
            dim = this.cartParms.dims[i];
            if (!remain_dims[i]) {
                color += colfactor * this.cartParms.coords[i];
                colfactor *= dim;
                continue;
            }
            ++ndim;
            key += keyfactor * this.cartParms.coords[i];
            keyfactor *= dim;
        }
        if (ndim == 0) {
            color = this.group.Rank();
            ndim = 1;
            allfalse = true;
        }
        if ((newcomm = this.Split(color, key)) != null) {
            int nprocs = newcomm.Size();
            int[] ndimsArray = new int[ndim];
            boolean[] nperiods = new boolean[ndim];
            int index = 0;
            if (allfalse) {
                ndimsArray[0] = 1;
            } else {
                for (int l = 0; l < this.cartParms.dims.length; ++l) {
                    if (!remain_dims[l]) continue;
                    ndimsArray[index] = this.cartParms.dims[l];
                    nperiods[index] = this.cartParms.periods[l];
                    ++index;
                }
            }
            return newcomm.Create_cart(ndimsArray, nperiods, false);
        }
        return null;
    }

    public int Map(int[] dims, boolean[] periods) throws MPIException {
        int procs = 1;
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] < 0) {
                throw new MPIException(" Error in Cartcomm.Map: dims[" + i + "] is " + "less than zero");
            }
            procs *= dims[i];
        }
        int size = this.group.Size();
        int rank = this.group.Rank();
        if (procs > size) {
            throw new MPIException(" Error in Cartcomm.Map: procs <" + procs + "> is " + "greater than size <" + size + ">");
        }
        return rank < 0 || rank >= procs ? -1 : rank;
    }

    public CartParms Get() throws MPIException {
        return this.cartParms;
    }

    @Override
    public int Topo_test() throws MPIException {
        return MPI.CART;
    }

    public static void Dims_create(int nnodes, int[] dims) throws MPIException {
        int rank = dims.length;
        while (rank > 0) {
            int ext = Cartcomm.root(nnodes, rank);
            nnodes /= ext;
            dims[--rank] = ext;
        }
    }

    static int root(int n, int d) {
        switch (d) {
            case 1: {
                return n;
            }
            case 2: {
                return (int)Math.sqrt(n);
            }
        }
        int ceiling = 1;
        int power = 1;
        while (power < n) {
            power = ++ceiling;
            for (int i = 1; i < d; ++i) {
                power *= ceiling;
            }
        }
        if (power == n) {
            return ceiling;
        }
        return ceiling - 1;
    }
}

