/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.BorByte;
import mpi.BorChar;
import mpi.BorInt;
import mpi.BorLong;
import mpi.BorShort;
import mpi.Datatype;
import mpi.MPIException;
import mpi.Op;
import mpi.OpWorker;

public class BorWorker
implements OpWorker {
    BorWorker() {
    }

    @Override
    public Op getWorker(Datatype datatype) throws MPIException {
        switch (datatype.baseType) {
            case 1: {
                return new BorByte();
            }
            case 2: {
                return new BorChar();
            }
            case 3: {
                return new BorShort();
            }
            case 4: {
                throw new MPIException("MPI.BOR is not valid for MPI.BOOLEAN");
            }
            case 5: {
                return new BorInt();
            }
            case 6: {
                return new BorLong();
            }
            case 7: {
                throw new MPIException("MPI.BOR is not valid for MPI.FLOAT");
            }
            case 8: {
                throw new MPIException("MPI.BOR is not valid for MPI.DOUBLE");
            }
        }
        return null;
    }
}

