/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.nio.ByteBuffer;
import mpi.Datatype;
import mpi.MPI;
import mpi.MPIException;
import mpi.SimplePackerFactory;
import mpjbuf.Buffer;
import mpjbuf.BufferFactory;
import mpjbuf.NIOBuffer;
import mpjbuf.RawBuffer;
import mpjbuf.Type;

public class BasicType
extends Datatype {
    int type;

    BasicType(int type) {
        this.type = type;
        if (type == 10 || type == 11) {
            this.baseType = -1;
            this.size = 0;
            this.byteSize = 0;
        } else {
            this.baseType = type;
            switch (type) {
                case -1: {
                    this.size = 0;
                    this.byteSize = 0;
                    break;
                }
                case 0: {
                    this.size = 0;
                    this.byteSize = 0;
                    break;
                }
                case 1: {
                    this.bufferType = Type.BYTE;
                    this.byteSize = 1;
                    break;
                }
                case 2: {
                    this.bufferType = Type.CHAR;
                    this.byteSize = 2;
                    break;
                }
                case 3: {
                    this.bufferType = Type.SHORT;
                    this.byteSize = 2;
                    break;
                }
                case 4: {
                    this.bufferType = Type.BOOLEAN;
                    this.byteSize = 1;
                    break;
                }
                case 5: {
                    this.bufferType = Type.INT;
                    this.byteSize = 4;
                    break;
                }
                case 6: {
                    this.bufferType = Type.LONG;
                    this.byteSize = 8;
                    break;
                }
                case 7: {
                    this.bufferType = Type.FLOAT;
                    this.byteSize = 4;
                    break;
                }
                case 8: {
                    this.bufferType = Type.DOUBLE;
                    this.byteSize = 8;
                    break;
                }
                case 9: {
                    this.size = 0;
                    this.byteSize = 0;
                    break;
                }
                case 12: {
                    this.bufferType = Type.OBJECT;
                    this.size = 0;
                    this.byteSize = 0;
                    break;
                }
            }
            this.size = 1;
        }
        this.computeBounds();
    }

    private void computeBounds() {
        switch (this.type) {
            case 10: {
                this.lb = 0;
                this.ub = 0;
                this.lbSet = true;
                this.ubSet = false;
                break;
            }
            case 11: {
                this.lb = 0;
                this.ub = 0;
                this.lbSet = false;
                this.ubSet = true;
                break;
            }
            default: {
                this.lb = 0;
                this.ub = 1;
                this.lbSet = false;
                this.ubSet = false;
            }
        }
        this.extent = this.ub - this.lb;
    }

    @Override
    Buffer createWriteBuffer(ByteBuffer slicedBuffer, int messageSize) {
        return new Buffer(new NIOBuffer(messageSize, slicedBuffer), MPI.BSEND_OVERHEAD, messageSize);
    }

    @Override
    Buffer createWriteBuffer(int count) throws MPIException {
        int capacity = this.packedSize(count) + MPI.SEND_OVERHEAD;
        int offset = MPI.SEND_OVERHEAD;
        RawBuffer rawBuffer = BufferFactory.create(capacity);
        Buffer wBuffer = new Buffer(rawBuffer, offset, capacity);
        try {
            wBuffer.putSectionHeader(this.bufferType);
        }
        catch (Exception e) {
            throw new MPIException(e);
        }
        return wBuffer;
    }

    @Override
    Buffer createReadBuffer(int count) {
        int capacity = this.packedSize(count) + MPI.RECV_OVERHEAD;
        int offset = MPI.RECV_OVERHEAD;
        RawBuffer rawBuffer = BufferFactory.create(capacity);
        Buffer mpjbuf = new Buffer(rawBuffer, offset, capacity);
        return mpjbuf;
    }

    @Override
    int packedSize(int count) {
        int dataSize = count * this.byteSize;
        int totalSize = 0;
        int sectionHeader = 8;
        totalSize = sectionHeader + dataSize;
        int padding = 0;
        if (totalSize % 8 != 0) {
            padding = totalSize % 8;
        }
        return totalSize + padding;
    }

    @Override
    void setPacker() {
        this.packer = SimplePackerFactory.create(1, this.baseType);
    }
}

