/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.BandByte;
import mpi.BandChar;
import mpi.BandInt;
import mpi.BandLong;
import mpi.BandShort;
import mpi.Datatype;
import mpi.MPIException;
import mpi.Op;
import mpi.OpWorker;

public class BandWorker
implements OpWorker {
    BandWorker() {
    }

    @Override
    public Op getWorker(Datatype datatype) throws MPIException {
        switch (datatype.baseType) {
            case 1: {
                return new BandByte();
            }
            case 2: {
                return new BandChar();
            }
            case 3: {
                return new BandShort();
            }
            case 4: {
                throw new MPIException("MPI.BAND is not valid for MPI.BOOLEAN");
            }
            case 5: {
                return new BandInt();
            }
            case 6: {
                return new BandLong();
            }
            case 7: {
                throw new MPIException("MPI.BAND is not valid for MPI.FLOAT");
            }
            case 8: {
                throw new MPIException("MPI.BAND is not valid for MPI.DOUBLE");
            }
        }
        return null;
    }
}

