/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.xprottest.compute;

import es.uvigo.darwin.prottest.exe.ExternalExecutionManager;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.observer.ModelUpdaterObserver;
import es.uvigo.darwin.prottest.observer.ObservableModelUpdater;
import es.uvigo.darwin.prottest.util.Utilities;
import es.uvigo.darwin.xprottest.XProtTestView;
import es.uvigo.darwin.xprottest.util.TextAreaAppender;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;

public class RunningFrame
extends JFrame
implements ModelUpdaterObserver {
    private static final int TIMER_UPDATE_FREQUENCY = 1000;
    private XProtTestView mainFrame;
    private Task task;
    private int computedModels;
    private int numModels;
    private PrintWriter displayWriter;
    private Calendar startTime;
    Timer timer;
    private HashMap<String, Long> partialTimestamps;
    private ArrayList<String> runningModels;
    private boolean running;
    private JButton cancelButton;
    private JScrollPane computedScrollArea;
    private JTextArea computedTextArea;
    private JLabel lblElapsedTime;
    private JLabel lblExecutedModels;
    private JLabel lblNumModels;
    private JLabel lblRunning;
    private JLabel lblSeparator;
    private JProgressBar runningProgress;

    public RunningFrame(XProtTestView mainFrame, int numModels) {
        this.initComponents();
        this.setDefaultCloseOperation(0);
        this.startTime = Calendar.getInstance();
        this.mainFrame = mainFrame;
        this.numModels = numModels;
        this.displayWriter = new PrintWriter(new TextAreaAppender(this.computedTextArea));
        this.running = true;
        this.partialTimestamps = new HashMap();
        this.runningModels = new ArrayList();
        this.lblNumModels.setText(String.valueOf(numModels));
        this.lblExecutedModels.setText(String.valueOf(this.computedModels));
        this.runningProgress.setMaximum(numModels);
        this.runningProgress.setMinimum(0);
        this.runningProgress.setValue(this.computedModels);
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunningFrame.this.lblElapsedTime.setText(Utilities.calculateRuntime(RunningFrame.this.startTime.getTimeInMillis(), Calendar.getInstance().getTimeInMillis()));
                RunningFrame.this.updateHeader();
            }
        });
        this.timer.start();
    }

    public void setTask(Task task) {
        this.task = task;
    }

    private void initComponents() {
        this.lblRunning = new JLabel();
        this.runningProgress = new JProgressBar();
        this.cancelButton = new JButton();
        this.lblNumModels = new JLabel();
        this.lblExecutedModels = new JLabel();
        this.lblSeparator = new JLabel();
        this.computedScrollArea = new JScrollPane();
        this.computedTextArea = new JTextArea();
        this.lblElapsedTime = new JLabel();
        this.setDefaultCloseOperation(3);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(RunningFrame.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.lblRunning.setText(resourceMap.getString("lblRunning.text", new Object[0]));
        this.lblRunning.setName("lblRunning");
        this.runningProgress.setName("runningProgress");
        ApplicationActionMap actionMap = Application.getInstance().getContext().getActionMap(RunningFrame.class, (Object)this);
        this.cancelButton.setAction(actionMap.get("cancelExecution"));
        this.cancelButton.setText(resourceMap.getString("cancelButton.text", new Object[0]));
        this.cancelButton.setName("cancelButton");
        this.lblNumModels.setHorizontalAlignment(2);
        this.lblNumModels.setText(resourceMap.getString("lblNumModels.text", new Object[0]));
        this.lblNumModels.setName("lblNumModels");
        this.lblExecutedModels.setHorizontalAlignment(4);
        this.lblExecutedModels.setText(resourceMap.getString("lblExecutedModels.text", new Object[0]));
        this.lblExecutedModels.setName("lblExecutedModels");
        this.lblSeparator.setText(resourceMap.getString("lblSeparator.text", new Object[0]));
        this.lblSeparator.setName("lblSeparator");
        this.computedScrollArea.setName("computedScrollArea");
        this.computedTextArea.setBackground(resourceMap.getColor("computedTextArea.background"));
        this.computedTextArea.setColumns(20);
        this.computedTextArea.setEditable(false);
        this.computedTextArea.setRows(15);
        this.computedTextArea.setName("computedTextArea");
        this.computedScrollArea.setViewportView(this.computedTextArea);
        this.lblElapsedTime.setText(resourceMap.getString("lblElapsedTime.text", new Object[0]));
        this.lblElapsedTime.setName("lblElapsedTime");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.computedScrollArea, GroupLayout.Alignment.LEADING, -1, 329, Short.MAX_VALUE).addComponent(this.runningProgress, GroupLayout.Alignment.LEADING, -1, 329, Short.MAX_VALUE).addComponent(this.lblRunning, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.cancelButton).addGap(18, 18, 18).addComponent(this.lblElapsedTime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 135, Short.MAX_VALUE).addComponent(this.lblExecutedModels).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSeparator).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNumModels, -2, 25, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblRunning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runningProgress, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.lblNumModels).addComponent(this.lblSeparator).addComponent(this.lblExecutedModels).addComponent(this.lblElapsedTime)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.computedScrollArea, -1, 315, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    @Action
    public void cancelExecution() {
        ExternalExecutionManager.getInstance().killProcesses();
        this.task.cancel(true);
        this.unload();
    }

    public void finishedExecution() {
        this.unload();
    }

    private void unload() {
        this.mainFrame.unloadRunningView(this);
    }

    public void updateHeader() {
        StringBuffer models = new StringBuffer();
        Iterator<String> it = this.runningModels.iterator();
        while (it.hasNext()) {
            models.append((Object)it.next());
            if (!it.hasNext()) continue;
            models.append(", ");
        }
        this.lblRunning.setText("Computing: " + models);
    }

    @Override
    public void update(ObservableModelUpdater o, Model model, ApplicationOptions options) {
        if (this.running) {
            if (options == null) {
                this.runningModels.add(model.getModelName());
                this.partialTimestamps.put(model.getModelName(), Calendar.getInstance().getTimeInMillis());
            } else {
                ++this.computedModels;
                this.runningProgress.setValue(this.computedModels);
                this.lblExecutedModels.setText(String.valueOf(this.computedModels));
                this.runningModels.remove(model.getModelName());
                if (model.isComputed()) {
                    StringBuffer partialTime = new StringBuffer("");
                    this.displayWriter.println("Computed " + model.getModelName() + "(" + model.getLk() + ")");
                    long currentTimestamp = Calendar.getInstance().getTimeInMillis();
                    long partialTimestamp = this.partialTimestamps.get(model.getModelName());
                    this.displayWriter.println("    " + Utilities.calculateRuntime(partialTimestamp, currentTimestamp) + "     Elapsed time: " + Utilities.calculateRuntime(this.startTime.getTimeInMillis(), currentTimestamp));
                } else if (this.mainFrame.getErrorBehavior() == 0) {
                    this.displayWriter.println("There were errors computing " + model.getModelName());
                } else if (this.mainFrame.getErrorBehavior() == 1) {
                    this.running = false;
                    this.mainFrame.computationInterrupted();
                    this.cancelExecution();
                } else {
                    this.running = false;
                    this.cancelExecution();
                    throw new RuntimeException("Unsupported error behavior : " + this.mainFrame.getErrorBehavior());
                }
            }
        }
    }
}

