/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.xprottest.compute;

import es.uvigo.darwin.prottest.facade.util.ProtTestParameterVO;
import es.uvigo.darwin.prottest.global.AminoAcidApplicationGlobals;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.util.exception.AlignmentParseException;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.exception.TreeFormatException;
import es.uvigo.darwin.xprottest.XProtTestApp;
import es.uvigo.darwin.xprottest.XProtTestView;
import es.uvigo.darwin.xprottest.util.OptimizationStrategyWrapper;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import pal.alignment.Alignment;
import pal.misc.Identifier;
import pal.tree.Tree;

public class OptionsView
extends JFrame {
    private XProtTestView mainFrame;
    private ArrayList<JCheckBox> cbMatrices;
    private String alignmentFilePath;
    private String treeFilePath;
    private Alignment alignment;
    private Tree userTree;
    private boolean running;
    private ResourceBundle resource = ResourceBundle.getBundle("es/uvigo/darwin/xprottest/compute/resources/OptionsView");
    private JButton btnCancel;
    private JButton btnCompute;
    private JButton btnSetDefault;
    private JCheckBox cbDistGroupCat;
    private JCheckBox cbDistInvGC;
    private JCheckBox cbDistInvariant;
    private JCheckBox cbEmpiricalF;
    private JComboBox cmbStrategyMode;
    private JPanel distributionsPanel;
    private JPanel empiricalFPanel;
    private JLabel lblNCat;
    private JLabel lblNumModels;
    private JLabel lblNumModelsLabel;
    private JLabel lblNumProc;
    private JLabel lblStrategyMode;
    private JLabel lblUserTree;
    private JLabel msgValidate;
    private JPanel processorsPanel;
    private JPanel rateVarPanel;
    private JSlider sliderProcessors;
    private JPanel startingTopologiesPanel;
    private JPanel subMatPanel;
    private JPanel subMatricesPanel;
    private JTextField txtNCat;

    public OptionsView(XProtTestView mainFrame, Alignment alignment, String alignmentFilePath) {
        this.alignment = alignment;
        this.mainFrame = mainFrame;
        this.alignmentFilePath = alignmentFilePath;
        this.running = false;
        this.initComponents();
        this.msgValidate.setVisible(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.subMatricesPanel);
        GroupLayout.ParallelGroup pg1 = jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup pg2 = jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup horizontalGroup = jPanel1Layout.createSequentialGroup().addContainerGap();
        GroupLayout.ParallelGroup verticalGroup = jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup sg1 = jPanel1Layout.createSequentialGroup().addContainerGap();
        GroupLayout.SequentialGroup sg2 = jPanel1Layout.createSequentialGroup().addContainerGap();
        String[] matrices = AminoAcidApplicationGlobals.ALL_MATRICES;
        this.cbMatrices = new ArrayList(matrices.length);
        int i = 0;
        for (String matrix : matrices) {
            JCheckBox cbMatrix = new JCheckBox();
            cbMatrix.setText(matrix);
            cbMatrix.setSelected(true);
            cbMatrix.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsView.this.onChangeOptions(evt);
                }
            });
            this.cbMatrices.add(cbMatrix);
            if (i < matrices.length / 2) {
                pg1.addComponent(cbMatrix);
                sg1.addComponent(cbMatrix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            } else {
                pg2.addComponent(cbMatrix);
                sg2.addComponent(cbMatrix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            }
            ++i;
        }
        horizontalGroup.addGroup(pg1);
        horizontalGroup.addGroup(pg2);
        verticalGroup.addGroup(sg1);
        verticalGroup.addGroup(sg2);
        this.subMatricesPanel.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(horizontalGroup).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(verticalGroup));
        this.lblNumModels.setText(String.valueOf(this.calculateNumberOfModels()));
    }

    private void initComponents() {
        this.subMatPanel = new JPanel();
        this.subMatricesPanel = new JPanel();
        this.distributionsPanel = new JPanel();
        this.rateVarPanel = new JPanel();
        this.lblNCat = new JLabel();
        this.cbDistGroupCat = new JCheckBox();
        this.cbDistInvariant = new JCheckBox();
        this.txtNCat = new JTextField();
        this.cbDistInvGC = new JCheckBox();
        this.msgValidate = new JLabel();
        this.empiricalFPanel = new JPanel();
        this.cbEmpiricalF = new JCheckBox();
        this.lblNumModelsLabel = new JLabel();
        this.lblNumModels = new JLabel();
        this.btnCompute = new JButton();
        this.processorsPanel = new JPanel();
        this.sliderProcessors = new JSlider();
        this.lblNumProc = new JLabel();
        this.btnSetDefault = new JButton();
        this.btnCancel = new JButton();
        this.startingTopologiesPanel = new JPanel();
        this.lblStrategyMode = new JLabel();
        this.cmbStrategyMode = new JComboBox();
        this.lblUserTree = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(OptionsView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                OptionsView.this.onClose(evt);
            }
        });
        this.subMatPanel.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("subMatPanel.border.title", new Object[0]), 0, 0, XProtTestApp.FONT_PANEL_TITLE, resourceMap.getColor("subMatPanel.border.titleColor")));
        this.subMatPanel.setName("subMatPanel");
        this.subMatricesPanel.setToolTipText(resourceMap.getString("subMatricesPanel.toolTipText", new Object[0]));
        this.subMatricesPanel.setName("subMatricesPanel");
        GroupLayout subMatricesPanelLayout = new GroupLayout(this.subMatricesPanel);
        this.subMatricesPanel.setLayout(subMatricesPanelLayout);
        subMatricesPanelLayout.setHorizontalGroup(subMatricesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 172, Short.MAX_VALUE));
        subMatricesPanelLayout.setVerticalGroup(subMatricesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 283, Short.MAX_VALUE));
        GroupLayout subMatPanelLayout = new GroupLayout(this.subMatPanel);
        this.subMatPanel.setLayout(subMatPanelLayout);
        subMatPanelLayout.setHorizontalGroup(subMatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subMatPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subMatricesPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        subMatPanelLayout.setVerticalGroup(subMatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subMatPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subMatricesPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.distributionsPanel.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("distributionsPanel.border.title", new Object[0]), 0, 0, XProtTestApp.FONT_LABEL, resourceMap.getColor("distributionsPanel.border.titleColor")));
        this.distributionsPanel.setName("distributionsPanel");
        this.rateVarPanel.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("rateVarPanel.border.title", new Object[0]), 0, 0, XProtTestApp.FONT_PANEL_TITLE, resourceMap.getColor("rateVarPanel.border.titleColor")));
        this.rateVarPanel.setName("rateVarPanel");
        this.lblNCat.setFont(this.lblNCat.getFont());
        this.lblNCat.setHorizontalAlignment(4);
        this.lblNCat.setText(resourceMap.getString("lblNCat.text", new Object[0]));
        this.lblNCat.setName("lblNCat");
        this.cbDistGroupCat.setFont(this.cbDistGroupCat.getFont());
        this.cbDistGroupCat.setSelected(true);
        this.cbDistGroupCat.setText(resourceMap.getString("cbDistGroupCat.text", new Object[0]));
        this.cbDistGroupCat.setToolTipText(resourceMap.getString("cbDistGroupCat.toolTipText", new Object[0]));
        this.cbDistGroupCat.setName("cbDistGroupCat");
        this.cbDistGroupCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsView.this.onChangeOptions(evt);
            }
        });
        this.cbDistInvariant.setFont(this.cbDistInvariant.getFont());
        this.cbDistInvariant.setSelected(true);
        this.cbDistInvariant.setText(resourceMap.getString("cbDistInvariant.text", new Object[0]));
        this.cbDistInvariant.setToolTipText(resourceMap.getString("cbDistInvariant.toolTipText", new Object[0]));
        this.cbDistInvariant.setName("cbDistInvariant");
        this.cbDistInvariant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsView.this.onChangeOptions(evt);
            }
        });
        this.txtNCat.setHorizontalAlignment(4);
        this.txtNCat.setText(String.valueOf(4));
        ResourceBundle bundle = ResourceBundle.getBundle("es/uvigo/darwin/xprottest/compute/resources/OptionsView");
        this.txtNCat.setToolTipText(bundle.getString("txtNCat.toolTip"));
        this.txtNCat.setName("txtNCat");
        this.cbDistInvGC.setFont(this.cbDistInvGC.getFont());
        this.cbDistInvGC.setSelected(true);
        this.cbDistInvGC.setText(resourceMap.getString("cbDistInvGC.text", new Object[0]));
        this.cbDistInvGC.setName("cbDistInvGC");
        this.cbDistInvGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsView.this.onChangeOptions(evt);
            }
        });
        this.msgValidate.setFont(XProtTestApp.FONT_OPTION_LABEL);
        this.msgValidate.setForeground(XProtTestView.CRITIC_COLOR);
        this.msgValidate.setText(resourceMap.getString("msgValidate.text", new Object[0]));
        this.msgValidate.setName("msgValidate");
        GroupLayout rateVarPanelLayout = new GroupLayout(this.rateVarPanel);
        this.rateVarPanel.setLayout(rateVarPanelLayout);
        rateVarPanelLayout.setHorizontalGroup(rateVarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rateVarPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cbDistInvariant).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbDistGroupCat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbDistInvGC).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNCat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtNCat, -2, 35, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, rateVarPanelLayout.createSequentialGroup().addContainerGap(94, Short.MAX_VALUE).addComponent(this.msgValidate).addContainerGap()));
        rateVarPanelLayout.setVerticalGroup(rateVarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rateVarPanelLayout.createSequentialGroup().addComponent(this.msgValidate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(rateVarPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbDistInvariant).addComponent(this.cbDistGroupCat).addComponent(this.cbDistInvGC).addComponent(this.txtNCat, -2, -1, -2).addComponent(this.lblNCat)).addContainerGap(-1, Short.MAX_VALUE)));
        this.empiricalFPanel.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("empiricalFPanel.border.title", new Object[0]), 0, 0, XProtTestApp.FONT_PANEL_TITLE, resourceMap.getColor("empiricalFPanel.border.titleColor")));
        this.empiricalFPanel.setName("empiricalFPanel");
        this.cbEmpiricalF.setFont(this.cbEmpiricalF.getFont());
        this.cbEmpiricalF.setSelected(true);
        this.cbEmpiricalF.setText(bundle.getString("cbEmpiricalF.text"));
        this.cbEmpiricalF.setToolTipText(resourceMap.getString("cbEmpiricalF.toolTipText", new Object[0]));
        this.cbEmpiricalF.setName("cbEmpiricalF");
        this.cbEmpiricalF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsView.this.onChangeOptions(evt);
            }
        });
        GroupLayout empiricalFPanelLayout = new GroupLayout(this.empiricalFPanel);
        this.empiricalFPanel.setLayout(empiricalFPanelLayout);
        empiricalFPanelLayout.setHorizontalGroup(empiricalFPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(empiricalFPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cbEmpiricalF).addContainerGap(223, Short.MAX_VALUE)));
        empiricalFPanelLayout.setVerticalGroup(empiricalFPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(empiricalFPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cbEmpiricalF).addContainerGap(-1, Short.MAX_VALUE)));
        this.lblNumModelsLabel.setFont(XProtTestApp.FONT_OPTION_LABEL);
        this.lblNumModelsLabel.setForeground(resourceMap.getColor("lblNumModelsLabel.foreground"));
        this.lblNumModelsLabel.setText(resourceMap.getString("lblNumModelsLabel.text", new Object[0]));
        this.lblNumModelsLabel.setName("lblNumModelsLabel");
        this.lblNumModels.setFont(XProtTestApp.FONT_OPTION_LABEL);
        this.lblNumModels.setForeground(resourceMap.getColor("lblNumModelsLabel.foreground"));
        this.lblNumModels.setName("lblNumModels");
        GroupLayout distributionsPanelLayout = new GroupLayout(this.distributionsPanel);
        this.distributionsPanel.setLayout(distributionsPanelLayout);
        distributionsPanelLayout.setHorizontalGroup(distributionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, distributionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(distributionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.rateVarPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.empiricalFPanel, -1, -1, Short.MAX_VALUE).addGroup(distributionsPanelLayout.createSequentialGroup().addComponent(this.lblNumModelsLabel, -1, 248, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblNumModels, -2, 69, -2))).addContainerGap()));
        distributionsPanelLayout.setVerticalGroup(distributionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(distributionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.rateVarPanel, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.empiricalFPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(distributionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNumModels, -2, 13, -2).addComponent(this.lblNumModelsLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        ApplicationActionMap actionMap = Application.getInstance().getContext().getActionMap(OptionsView.class, (Object)this);
        this.btnCompute.setAction(actionMap.get("computeLikelihood"));
        this.btnCompute.setText(resourceMap.getString("btnCompute.text", new Object[0]));
        this.btnCompute.setName("btnCompute");
        this.processorsPanel.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("processorsPanel.border.title", new Object[0]), 0, 0, XProtTestApp.FONT_PANEL_TITLE, resourceMap.getColor("processorsPanel.border.titleColor")));
        this.processorsPanel.setName("processorsPanel");
        this.sliderProcessors.setMinimum(1);
        this.sliderProcessors.setMaximum(Runtime.getRuntime().availableProcessors());
        this.sliderProcessors.setValue(this.mainFrame.getFacade().getNumberOfThreads());
        this.sliderProcessors.setPaintLabels(true);
        this.sliderProcessors.setPaintTicks(true);
        this.sliderProcessors.setSnapToTicks(true);
        this.sliderProcessors.setToolTipText(resourceMap.getString("sliderProcessors.toolTipText", new Object[0]));
        this.sliderProcessors.setName("sliderProcessors");
        this.sliderProcessors.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OptionsView.this.sliderProcessorsStateChanged(evt);
            }
        });
        this.lblNumProc.setFont(this.lblNumProc.getFont());
        this.lblNumProc.setHorizontalAlignment(2);
        this.lblNumProc.setText(String.valueOf(this.sliderProcessors.getValue()));
        this.lblNumProc.setName("lblNumProc");
        GroupLayout processorsPanelLayout = new GroupLayout(this.processorsPanel);
        this.processorsPanel.setLayout(processorsPanelLayout);
        processorsPanelLayout.setHorizontalGroup(processorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processorsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lblNumProc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderProcessors, -1, 442, Short.MAX_VALUE).addContainerGap()));
        processorsPanelLayout.setVerticalGroup(processorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processorsPanelLayout.createSequentialGroup().addContainerGap().addGroup(processorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sliderProcessors, -1, 47, Short.MAX_VALUE).addComponent(this.lblNumProc)).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnSetDefault.setAction(actionMap.get("restoreDefault"));
        this.btnSetDefault.setText(resourceMap.getString("btnSetDefault.text", new Object[0]));
        this.btnSetDefault.setToolTipText(resourceMap.getString("btnSetDefault.toolTipText", new Object[0]));
        this.btnSetDefault.setName("btnSetDefault");
        this.btnCancel.setAction(actionMap.get("close"));
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setToolTipText(resourceMap.getString("btnCancel.toolTipText", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.startingTopologiesPanel.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("startingTopologiesPanel.border.title", new Object[0]), 0, 0, XProtTestApp.FONT_PANEL_TITLE, resourceMap.getColor("startingTopologiesPanel.border.titleColor")));
        this.startingTopologiesPanel.setName("startingTopologiesPanel");
        this.lblStrategyMode.setFont(this.lblStrategyMode.getFont());
        this.lblStrategyMode.setText(bundle.getString("lbl-strategy-mode"));
        this.lblStrategyMode.setName("lblStrategyMode");
        this.cmbStrategyMode.setAction(actionMap.get("setStrategyMode"));
        this.cmbStrategyMode.setName("cmbStrategyMode");
        this.lblUserTree.setFont(XProtTestApp.FONT_OPTION_LABEL);
        this.lblUserTree.setForeground(resourceMap.getColor("lblUserTree.foreground"));
        this.lblUserTree.setText(bundle.getString("msg-no-user-tree-loaded"));
        this.lblUserTree.setName("lblUserTree");
        GroupLayout startingTopologiesPanelLayout = new GroupLayout(this.startingTopologiesPanel);
        this.startingTopologiesPanel.setLayout(startingTopologiesPanelLayout);
        startingTopologiesPanelLayout.setHorizontalGroup(startingTopologiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(startingTopologiesPanelLayout.createSequentialGroup().addContainerGap().addGroup(startingTopologiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbStrategyMode, 0, 329, Short.MAX_VALUE).addComponent(this.lblStrategyMode, -1, 329, Short.MAX_VALUE).addComponent(this.lblUserTree, -1, 329, Short.MAX_VALUE)).addContainerGap()));
        startingTopologiesPanelLayout.setVerticalGroup(startingTopologiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(startingTopologiesPanelLayout.createSequentialGroup().addComponent(this.lblStrategyMode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbStrategyMode, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblUserTree).addContainerGap(-1, Short.MAX_VALUE)));
        for (int optimizeValue : AminoAcidApplicationGlobals.OPTIMIZE_VALUES) {
            OptimizationStrategyWrapper optimizeItem = new OptimizationStrategyWrapper(AminoAcidApplicationGlobals.OPTIMIZE_NAMES[optimizeValue], optimizeValue);
            this.cmbStrategyMode.addItem(optimizeItem);
        }
        this.cmbStrategyMode.setSelectedIndex(0);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.processorsPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.subMatPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.distributionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.startingTopologiesPanel, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnCompute).addGap(18, 18, 18).addComponent(this.btnSetDefault).addGap(18, 18, 18).addComponent(this.btnCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.processorsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.distributionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startingTopologiesPanel, -2, -1, -2)).addComponent(this.subMatPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnSetDefault).addComponent(this.btnCompute)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void onClose(WindowEvent evt) {
        this.mainFrame.unloadOptionsView(this.running);
    }

    private void onChangeOptions(ActionEvent evt) {
        this.lblNumModels.setText(String.valueOf(this.calculateNumberOfModels()));
        this.txtNCat.setEnabled(this.cbDistGroupCat.isSelected() || this.cbDistInvGC.isSelected());
    }

    private void sliderProcessorsStateChanged(ChangeEvent evt) {
        this.lblNumProc.setText(String.valueOf(this.sliderProcessors.getValue()));
    }

    private int calculateNumberOfModels() {
        int numberOfModels = 0;
        for (JCheckBox cbMatrix : this.cbMatrices) {
            if (!cbMatrix.isSelected()) continue;
            ++numberOfModels;
        }
        int numberOfMatrices = numberOfModels;
        if (this.cbDistInvariant.isSelected()) {
            numberOfModels += numberOfMatrices;
        }
        if (this.cbDistGroupCat.isSelected()) {
            numberOfModels += numberOfMatrices;
        }
        if (this.cbDistInvGC.isSelected()) {
            numberOfModels += numberOfMatrices;
        }
        if (this.cbEmpiricalF.isSelected()) {
            numberOfModels *= 2;
        }
        return numberOfModels;
    }

    @Action
    public void computeLikelihood() {
        boolean validate = true;
        this.msgValidate.setVisible(false);
        ArrayList<String> matrices = new ArrayList<String>();
        ArrayList<String> distributions = new ArrayList<String>();
        int ncat = 0;
        for (JCheckBox cbMatrix : this.cbMatrices) {
            if (!cbMatrix.isSelected()) continue;
            matrices.add(cbMatrix.getText());
        }
        distributions.add("Uniform");
        if (this.cbDistGroupCat.isSelected()) {
            distributions.add("+G");
        }
        if (this.cbDistInvariant.isSelected()) {
            distributions.add("+I");
        }
        if (this.cbDistInvGC.isSelected()) {
            distributions.add("+I+G");
        }
        if (this.cbDistGroupCat.isSelected() || this.cbDistInvGC.isSelected()) {
            try {
                ncat = Integer.parseInt(this.txtNCat.getText());
                if (ncat <= 0) {
                    this.msgValidate.setVisible(true);
                    validate = false;
                }
            }
            catch (NumberFormatException e) {
                this.msgValidate.setVisible(true);
                validate = false;
            }
        }
        boolean plusF = this.cbEmpiricalF.isSelected();
        int strategyMode = this.cmbStrategyMode.getSelectedIndex();
        if (validate) {
            try {
                this.mainFrame.getFacade().setNumberOfThreads(this.sliderProcessors.getValue());
                ProtTestParameterVO parameters = new ProtTestParameterVO(this.alignmentFilePath, this.alignment, this.treeFilePath, matrices, distributions, plusF, ncat, strategyMode);
                ApplicationOptions options = this.mainFrame.getFacade().configure(parameters);
                this.mainFrame.computeLikelihood(this.calculateNumberOfModels(), options);
                this.running = true;
            }
            catch (IOException e) {
                this.mainFrame.getDisplayWriter().println(e.getMessage());
            }
            catch (AlignmentParseException e) {
                this.mainFrame.getDisplayWriter().println(e.getMessage());
            }
            catch (ProtTestInternalException e) {
                this.mainFrame.getDisplayWriter().println(e.getMessage());
            }
            this.dispose();
        }
    }

    @Action
    public void setStrategyMode() {
        ResourceMap resourceMap = ((XProtTestApp)Application.getInstance(XProtTestApp.class)).getContext().getResourceMap(OptionsView.class);
        File f = null;
        if (((OptimizationStrategyWrapper)this.cmbStrategyMode.getSelectedItem()).getValue() == 3) {
            FileDialog fc = new FileDialog((Frame)this, "Load DNA alignment", 0);
            fc.setDirectory(System.getProperty("user.dir"));
            fc.setVisible(true);
            String dataFileName = fc.getFile();
            if (dataFileName != null) {
                try {
                    f = new File(fc.getDirectory() + dataFileName);
                    Tree tree = this.mainFrame.getFacade().readTree(this.mainFrame.getDisplayWriter(), f.getAbsolutePath(), true);
                    this.treeFilePath = f.getAbsolutePath();
                    boolean consistent = true;
                    if (this.alignment.getIdCount() == tree.getIdCount()) {
                        for (int id = 0; id < this.alignment.getIdCount(); ++id) {
                            Identifier identifier = this.alignment.getIdentifier(id);
                            if (tree.whichIdNumber(identifier.getName()) != -1) continue;
                            consistent = false;
                            break;
                        }
                    } else {
                        consistent = false;
                    }
                    if (consistent) {
                        this.setUserTree(tree);
                    } else {
                        this.mainFrame.getDisplayWriter().println("User topology is not consistent with current alignment");
                        this.setUserTree(null);
                        this.cmbStrategyMode.setSelectedIndex(0);
                    }
                }
                catch (TreeFormatException ex) {
                    this.mainFrame.getDisplayWriter().println(ex.getMessage());
                    this.setUserTree(null);
                    this.cmbStrategyMode.setSelectedIndex(0);
                }
                catch (FileNotFoundException ex) {
                    this.mainFrame.getDisplayWriter().println(ex.getMessage());
                    this.setUserTree(null);
                    this.cmbStrategyMode.setSelectedIndex(0);
                }
                catch (IOException ex) {
                    this.mainFrame.getDisplayWriter().println(ex.getMessage());
                    this.setUserTree(null);
                    this.cmbStrategyMode.setSelectedIndex(0);
                }
                this.mainFrame.getDisplayWriter().println("");
                this.mainFrame.getFrame().toFront();
                this.mainFrame.getFrame().transferFocus();
            }
        } else if (this.userTree != null) {
            this.setUserTree(null);
        }
    }

    private void setUserTree(Tree tree) {
        this.userTree = tree;
        ResourceMap resourceMap = ((XProtTestApp)Application.getInstance(XProtTestApp.class)).getContext().getResourceMap(OptionsView.class);
        if (tree == null) {
            this.lblUserTree.setText(resourceMap.getString("msg-no-user-tree-loaded", new Object[0]));
            this.lblUserTree.setForeground(Color.GRAY);
            this.treeFilePath = null;
        } else {
            this.lblUserTree.setText(resourceMap.getString("msg-user-tree-loaded", new Object[0]));
            this.lblUserTree.setForeground(XProtTestView.DONE_COLOR);
        }
    }

    @Action
    public void restoreDefault() {
        for (JCheckBox matrix : this.cbMatrices) {
            matrix.setSelected(true);
        }
        this.cbDistGroupCat.setSelected(true);
        this.cbDistInvGC.setSelected(true);
        this.cbDistInvariant.setSelected(true);
        this.cbEmpiricalF.setSelected(true);
        this.txtNCat.setText(String.valueOf(4));
        this.sliderProcessors.setValue(this.sliderProcessors.getMaximum());
        this.cmbStrategyMode.setSelectedIndex(0);
        this.onChangeOptions(null);
        this.sliderProcessorsStateChanged(null);
        this.setUserTree(null);
    }

    @Action
    public void close() {
        this.dispose();
    }
}

