/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.xprottest.analysis.consensus;

import es.uvigo.darwin.prottest.facade.TreeFacade;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.selection.AIC;
import es.uvigo.darwin.prottest.selection.AICc;
import es.uvigo.darwin.prottest.selection.BIC;
import es.uvigo.darwin.prottest.selection.DT;
import es.uvigo.darwin.prottest.selection.InformationCriterion;
import es.uvigo.darwin.prottest.selection.LNL;
import es.uvigo.darwin.prottest.util.ProtTestAlignment;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogger;
import es.uvigo.darwin.prottest.util.printer.ProtTestPrinter;
import es.uvigo.darwin.xprottest.XProtTestApp;
import es.uvigo.darwin.xprottest.XProtTestView;
import es.uvigo.darwin.xprottest.util.TextAreaWriter;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import pal.alignment.Alignment;
import pal.misc.Identifier;
import pal.tree.Tree;

public class Consensus
extends JFrame {
    private static final int AIC_SELECTION = 0;
    private static final int BIC_SELECTION = 1;
    private static final int AICC_SELECTION = 2;
    private static final int LNL_SELECTION = 3;
    private static final int DT_SELECTION = 4;
    private static final int DISABLED_SELECTION = 5;
    private static final String[] SELECTION = new String[]{"AIC", "BIC", "AICc", "LK", "DT", "Disabled"};
    private ResourceMap resourceMap;
    private TreeFacade facade;
    private ModelCollection models;
    private Handler logHandler;
    private PrintWriter displayWriter;
    private int sampleSizeMode = 2;
    private double sampleSize = 1.0;
    private XProtTestView mainFrame;
    private JButton btnBuild;
    private JButton btnExport;
    private ButtonGroup btnGroupSampleSizeMode;
    private ButtonGroup btnGrpCriterion;
    private JMenuItem closeMenuItem;
    private JTextArea displayArea;
    private JScrollPane displayScroll;
    private JMenuItem editCopyMenuItem;
    private JMenu editMenu;
    private JMenuBar jMenuBar1;
    private JLabel lblConfInt;
    private JLabel lblConfidenceInterval;
    private JLabel lblConsType;
    private JLabel lblConsensusType;
    private JLabel lblCriterion;
    private JLabel lblMR;
    private JLabel lblPercent;
    private JLabel lblSampleSize;
    private JLabel lblSampleSizeMode;
    private JLabel lblStrict;
    private JLabel lblTitle;
    private JRadioButton radioAIC;
    private JRadioButton radioAICC;
    private JRadioButton radioBIC;
    private JRadioButton radioDT;
    private JRadioButton radioLK;
    private JMenuItem selectAllMenuItem;
    private JPanel settingsPanel;
    private JRadioButton sizeModeAlignment3;
    private JRadioButton sizeModeCustom;
    private JRadioButton sizeModeNL;
    private JRadioButton sizeModeShannon;
    private JRadioButton sizeModeShannonNL;
    private JRadioButton sizeModeVar;
    private JSlider sliderConfidence;
    private JSlider sliderConsType;
    private JTextField txtSampleSize;
    private JMenu windowMenu;

    public Consensus(XProtTestView mainFrame, TreeFacade facade, Model[] models, Alignment alignment) {
        this.initComponents();
        this.mainFrame = mainFrame;
        this.facade = facade;
        this.models = new SingleModelCollection(models, alignment);
        this.displayWriter = new PrintWriter(new TextAreaWriter(this.displayArea));
        this.logHandler = ProtTestLogger.getDefaultLogger().addHandler(this.displayWriter, Level.OFF);
        this.resourceMap = ((XProtTestApp)Application.getInstance(XProtTestApp.class)).getContext().getResourceMap(Consensus.class);
        Font f = new Font("Monospaced", 0, 12);
        this.displayArea.setFont(f);
        this.lblSampleSize.setText(String.valueOf(ProtTestAlignment.calculateSampleSize(this.models.getAlignment(), this.sampleSizeMode, this.sampleSize)));
    }

    private void initComponents() {
        this.btnGrpCriterion = new ButtonGroup();
        this.btnGroupSampleSizeMode = new ButtonGroup();
        this.settingsPanel = new JPanel();
        this.lblTitle = new JLabel();
        this.lblCriterion = new JLabel();
        this.radioAIC = new JRadioButton();
        this.radioBIC = new JRadioButton();
        this.radioAICC = new JRadioButton();
        this.radioDT = new JRadioButton();
        this.radioLK = new JRadioButton();
        this.sliderConsType = new JSlider();
        this.lblConsType = new JLabel();
        this.btnBuild = new JButton();
        this.lblMR = new JLabel();
        this.lblStrict = new JLabel();
        this.lblConfInt = new JLabel();
        this.sliderConfidence = new JSlider();
        this.lblConfidenceInterval = new JLabel();
        this.lblConsensusType = new JLabel();
        this.lblPercent = new JLabel();
        this.sizeModeAlignment3 = new JRadioButton();
        this.sizeModeNL = new JRadioButton();
        this.sizeModeCustom = new JRadioButton();
        this.txtSampleSize = new JTextField();
        this.sizeModeVar = new JRadioButton();
        this.sizeModeShannon = new JRadioButton();
        this.sizeModeShannonNL = new JRadioButton();
        this.lblSampleSize = new JLabel();
        this.lblSampleSizeMode = new JLabel();
        this.btnExport = new JButton();
        this.displayScroll = new JScrollPane();
        this.displayArea = new JTextArea();
        this.jMenuBar1 = new JMenuBar();
        this.windowMenu = new JMenu();
        this.closeMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.editCopyMenuItem = new JMenuItem();
        this.selectAllMenuItem = new JMenuItem();
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(Consensus.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.settingsPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.settingsPanel.setName("settingsPanel");
        this.lblTitle.setBackground(resourceMap.getColor("lblTitle.background"));
        this.lblTitle.setFont(resourceMap.getFont("lblTitle.font"));
        this.lblTitle.setHorizontalAlignment(0);
        this.lblTitle.setText(resourceMap.getString("title.text", new Object[0]));
        this.lblTitle.setName("lblTitle");
        this.lblCriterion.setText(resourceMap.getString("lblCriterion.text", new Object[0]));
        this.lblCriterion.setName("lblCriterion");
        ApplicationActionMap actionMap = Application.getInstance().getContext().getActionMap(Consensus.class, (Object)this);
        this.radioAIC.setAction(actionMap.get("disableSampleSize"));
        this.btnGrpCriterion.add(this.radioAIC);
        this.radioAIC.setText(resourceMap.getString("radioAIC.text", new Object[0]));
        this.radioAIC.setName("radioAIC");
        this.radioBIC.setAction(actionMap.get("enableSampleSize"));
        this.btnGrpCriterion.add(this.radioBIC);
        this.radioBIC.setText(resourceMap.getString("radioBIC.text", new Object[0]));
        this.radioBIC.setName("radioBIC");
        this.radioAICC.setAction(actionMap.get("enableSampleSize"));
        this.btnGrpCriterion.add(this.radioAICC);
        this.radioAICC.setText(resourceMap.getString("radioAICC.text", new Object[0]));
        this.radioAICC.setName("radioAICC");
        this.radioDT.setAction(actionMap.get("disableSampleSize"));
        this.btnGrpCriterion.add(this.radioDT);
        this.radioDT.setSelected(true);
        this.radioDT.setText(resourceMap.getString("radioDT.text", new Object[0]));
        this.radioDT.setName("radioDT");
        this.radioLK.setAction(actionMap.get("disableSampleSize"));
        this.btnGrpCriterion.add(this.radioLK);
        this.radioLK.setText(resourceMap.getString("radioLK.text", new Object[0]));
        this.radioLK.setName("radioLK");
        this.sliderConsType.setMinimum(50);
        this.sliderConsType.setToolTipText(resourceMap.getString("sliderConsType.toolTipText", new Object[0]));
        this.sliderConsType.setName("sliderConsType");
        this.sliderConsType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Consensus.this.sliderConsTypeStateChanged(evt);
            }
        });
        this.lblConsType.setText(resourceMap.getString("lblConsType.text", new Object[0]));
        this.lblConsType.setName("lblConsType");
        this.btnBuild.setAction(actionMap.get("buildConsensus"));
        this.btnBuild.setText(resourceMap.getString("btnBuild.text", new Object[0]));
        this.btnBuild.setName("btnBuild");
        this.lblMR.setFont(resourceMap.getFont("lblMR.font"));
        this.lblMR.setForeground(resourceMap.getColor("lblMR.foreground"));
        this.lblMR.setText(resourceMap.getString("lblMR.text", new Object[0]));
        this.lblMR.setName("lblMR");
        this.lblStrict.setFont(resourceMap.getFont("lblStrict.font"));
        this.lblStrict.setForeground(resourceMap.getColor("lblStrict.foreground"));
        this.lblStrict.setHorizontalAlignment(4);
        this.lblStrict.setText(resourceMap.getString("lblStrict.text", new Object[0]));
        this.lblStrict.setName("lblStrict");
        this.lblConfInt.setText(resourceMap.getString("lblConfInt.text", new Object[0]));
        this.lblConfInt.setToolTipText(resourceMap.getString("lblConfInt.toolTipText", new Object[0]));
        this.lblConfInt.setName("lblConfInt");
        this.sliderConfidence.setValue(100);
        this.sliderConfidence.setName("sliderConfidence");
        this.sliderConfidence.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Consensus.this.sliderConfidenceStateChanged(evt);
            }
        });
        this.lblConfidenceInterval.setText(resourceMap.getString("default-confidence-interval", new Object[0]));
        this.lblConfidenceInterval.setName("lblConfidenceInterval");
        this.lblConsensusType.setHorizontalAlignment(4);
        this.lblConsensusType.setText(resourceMap.getString("default-consensus-type", new Object[0]));
        this.lblConsensusType.setName("lblConsensusType");
        this.lblPercent.setText(resourceMap.getString("percent-symbol", new Object[0]));
        this.lblPercent.setName("lblPercent");
        this.sizeModeAlignment3.setAction(actionMap.get("selectSampleSize"));
        this.btnGroupSampleSizeMode.add(this.sizeModeAlignment3);
        this.sizeModeAlignment3.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("es/uvigo/darwin/xprottest/results/resources/ResultsView");
        this.sizeModeAlignment3.setText(bundle.getString("btn-sizemode-alignment"));
        this.sizeModeAlignment3.setToolTipText(resourceMap.getString("sizeModeAlignment3.toolTipText", new Object[0]));
        this.sizeModeAlignment3.setName("sizeModeAlignment3");
        this.sizeModeAlignment3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Consensus.this.sizeModePressed(evt);
            }
        });
        this.sizeModeNL.setAction(actionMap.get("selectSampleSize"));
        this.btnGroupSampleSizeMode.add(this.sizeModeNL);
        this.sizeModeNL.setText(bundle.getString("btn-sizemode-nxl"));
        this.sizeModeNL.setToolTipText(resourceMap.getString("sizeModeNL.toolTipText", new Object[0]));
        this.sizeModeNL.setName("sizeModeNL");
        this.sizeModeNL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Consensus.this.sizeModePressed(evt);
            }
        });
        this.sizeModeCustom.setAction(actionMap.get("selectSampleSize"));
        this.btnGroupSampleSizeMode.add(this.sizeModeCustom);
        this.sizeModeCustom.setText(bundle.getString("btn-sizemode-custom"));
        this.sizeModeCustom.setToolTipText(resourceMap.getString("sizeModeCustom.toolTipText", new Object[0]));
        this.sizeModeCustom.setName("sizeModeCustom");
        this.sizeModeCustom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Consensus.this.sizeModePressed(evt);
            }
        });
        this.txtSampleSize.setHorizontalAlignment(4);
        this.txtSampleSize.setText(resourceMap.getString("txtSampleSize.text", new Object[0]));
        this.txtSampleSize.setEnabled(false);
        this.txtSampleSize.setName("txtSampleSize");
        this.txtSampleSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Consensus.this.txtSampleSizeFocusLost(evt);
            }
        });
        this.sizeModeVar.setAction(actionMap.get("selectSampleSize"));
        this.btnGroupSampleSizeMode.add(this.sizeModeVar);
        this.sizeModeVar.setText(bundle.getString("btn-sizemode-alignment-var"));
        this.sizeModeVar.setToolTipText(resourceMap.getString("sizeModeVar.toolTipText", new Object[0]));
        this.sizeModeVar.setName("sizeModeVar");
        this.sizeModeVar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Consensus.this.sizeModePressed(evt);
            }
        });
        this.sizeModeShannon.setAction(actionMap.get("selectSampleSize"));
        this.btnGroupSampleSizeMode.add(this.sizeModeShannon);
        this.sizeModeShannon.setText(bundle.getString("btn-sizemode-shannon"));
        this.sizeModeShannon.setToolTipText(resourceMap.getString("sizeModeShannon.toolTipText", new Object[0]));
        this.sizeModeShannon.setName("sizeModeShannon");
        this.sizeModeShannon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Consensus.this.sizeModePressed(evt);
            }
        });
        this.sizeModeShannonNL.setAction(actionMap.get("selectSampleSize"));
        this.btnGroupSampleSizeMode.add(this.sizeModeShannonNL);
        this.sizeModeShannonNL.setText(bundle.getString("btn-sizemode-shannon-nxl"));
        this.sizeModeShannonNL.setToolTipText(resourceMap.getString("sizeModeShannonNL.toolTipText", new Object[0]));
        this.sizeModeShannonNL.setName("sizeModeShannonNL");
        this.sizeModeShannonNL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Consensus.this.sizeModePressed(evt);
            }
        });
        this.lblSampleSize.setText(resourceMap.getString("lblSampleSize.text", new Object[0]));
        this.lblSampleSize.setName("lblSampleSize");
        this.lblSampleSizeMode.setText(resourceMap.getString("lblSampleSizeMode.text", new Object[0]));
        this.lblSampleSizeMode.setName("lblSampleSizeMode");
        this.btnExport.setAction(actionMap.get("exportData"));
        this.btnExport.setText(resourceMap.getString("btnExport.text", new Object[0]));
        this.btnExport.setEnabled(false);
        this.btnExport.setName("btnExport");
        GroupLayout settingsPanelLayout = new GroupLayout(this.settingsPanel);
        this.settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCriterion, -2, 161, -2).addComponent(this.lblTitle, -1, 636, Short.MAX_VALUE).addGroup(settingsPanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.radioAIC).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radioBIC).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radioAICC).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radioDT).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radioLK)).addGroup(settingsPanelLayout.createSequentialGroup().addComponent(this.lblConsType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblConsensusType, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPercent)).addComponent(this.sliderConsType, -1, 636, Short.MAX_VALUE).addGroup(settingsPanelLayout.createSequentialGroup().addComponent(this.lblMR, -2, 76, -2).addGap(129, 129, 129).addComponent(this.btnBuild).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 182, Short.MAX_VALUE).addComponent(this.lblStrict, -2, 40, -2)).addComponent(this.sliderConfidence, GroupLayout.Alignment.TRAILING, -1, 636, Short.MAX_VALUE).addGroup(settingsPanelLayout.createSequentialGroup().addComponent(this.lblConfInt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblConfidenceInterval)))).addGroup(GroupLayout.Alignment.TRAILING, settingsPanelLayout.createSequentialGroup().addGap(28, 28, 28).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(settingsPanelLayout.createSequentialGroup().addComponent(this.sizeModeAlignment3).addGap(15, 15, 15)).addComponent(this.sizeModeNL, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, settingsPanelLayout.createSequentialGroup().addComponent(this.sizeModeCustom, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSampleSize, -2, 53, -2)).addGroup(GroupLayout.Alignment.LEADING, settingsPanelLayout.createSequentialGroup().addComponent(this.sizeModeVar, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sizeModeShannon, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sizeModeShannonNL, -2, 140, -2)).addComponent(this.lblSampleSize, GroupLayout.Alignment.LEADING, -1, 504, Short.MAX_VALUE))).addGroup(settingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lblSampleSizeMode, -2, 78, -2))).addContainerGap()));
        settingsPanelLayout.setVerticalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblCriterion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioAIC).addComponent(this.radioBIC).addComponent(this.radioAICC).addComponent(this.radioDT).addComponent(this.radioLK)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSampleSize).addComponent(this.lblSampleSizeMode)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeModeAlignment3).addComponent(this.sizeModeShannonNL).addComponent(this.sizeModeShannon).addComponent(this.sizeModeVar)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeModeNL).addComponent(this.sizeModeCustom).addComponent(this.txtSampleSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblConfInt).addComponent(this.lblConfidenceInterval)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderConfidence, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblConsType).addComponent(this.lblConsensusType).addComponent(this.lblPercent)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderConsType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMR).addComponent(this.lblStrict).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnBuild).addComponent(this.btnExport))).addContainerGap()));
        this.displayScroll.setName("displayScroll");
        this.displayArea.setColumns(20);
        this.displayArea.setEditable(false);
        this.displayArea.setLineWrap(true);
        this.displayArea.setRows(5);
        this.displayArea.setName("displayArea");
        this.displayScroll.setViewportView(this.displayArea);
        this.jMenuBar1.setName("jMenuBar1");
        this.windowMenu.setName("windowMenu");
        this.closeMenuItem.setAction(actionMap.get("Close"));
        this.closeMenuItem.setName("closeMenuItem");
        this.windowMenu.add(this.closeMenuItem);
        this.jMenuBar1.add(this.windowMenu);
        this.editMenu.setText(resourceMap.getString("editMenu.text", new Object[0]));
        this.editMenu.setName("editMenu");
        this.editCopyMenuItem.setAction(actionMap.get("editCopy"));
        this.editCopyMenuItem.setName("editCopyMenuItem");
        this.editMenu.add(this.editCopyMenuItem);
        this.selectAllMenuItem.setAction(actionMap.get("editSelectAll"));
        this.selectAllMenuItem.setText(resourceMap.getString("selectAllMenuItem.text", new Object[0]));
        this.selectAllMenuItem.setName("selectAllMenuItem");
        this.editMenu.add(this.selectAllMenuItem);
        this.jMenuBar1.add(this.editMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.displayScroll, GroupLayout.Alignment.LEADING, -1, 664, Short.MAX_VALUE).addComponent(this.settingsPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.settingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayScroll, -1, 362, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void sliderConfidenceStateChanged(ChangeEvent evt) {
        this.lblConfidenceInterval.setText(String.valueOf(Double.valueOf(this.sliderConfidence.getValue()) / 100.0));
    }

    private void sliderConsTypeStateChanged(ChangeEvent evt) {
        this.lblConsensusType.setText(String.valueOf(Double.valueOf(this.sliderConsType.getValue()) / 100.0));
    }

    private void sizeModePressed(ActionEvent evt) {
        String btnName = evt.getActionCommand();
        this.txtSampleSize.setEnabled(false);
        if (btnName.equals(ResourceBundle.getBundle("es/uvigo/darwin/xprottest/results/resources/ResultsView").getString("btn-sizemode-alignment"))) {
            this.sampleSizeMode = 2;
        } else if (btnName.equals(ResourceBundle.getBundle("es/uvigo/darwin/xprottest/results/resources/ResultsView").getString("btn-sizemode-alignment-var"))) {
            this.sampleSizeMode = 3;
        } else if (btnName.equals(ResourceBundle.getBundle("es/uvigo/darwin/xprottest/results/resources/ResultsView").getString("btn-sizemode-shannon"))) {
            this.sampleSizeMode = 0;
        } else if (btnName.equals(ResourceBundle.getBundle("es/uvigo/darwin/xprottest/results/resources/ResultsView").getString("btn-sizemode-shannon-nxl"))) {
            this.sampleSizeMode = 1;
        } else if (btnName.equals(ResourceBundle.getBundle("es/uvigo/darwin/xprottest/results/resources/ResultsView").getString("btn-sizemode-nxl"))) {
            this.sampleSizeMode = 4;
        } else if (btnName.equals(ResourceBundle.getBundle("es/uvigo/darwin/xprottest/results/resources/ResultsView").getString("btn-sizemode-custom"))) {
            this.sampleSizeMode = 5;
            try {
                this.sampleSize = Double.parseDouble(this.txtSampleSize.getText());
            }
            catch (NumberFormatException e) {
                this.sampleSize = 0.0;
            }
            this.txtSampleSize.setEnabled(true);
            this.txtSampleSize.grabFocus();
        }
        this.lblSampleSize.setText(String.valueOf(ProtTestAlignment.calculateSampleSize(this.models.getAlignment(), this.sampleSizeMode, this.sampleSize)));
    }

    private void txtSampleSizeFocusLost(FocusEvent evt) {
        try {
            this.sampleSize = Double.parseDouble(this.txtSampleSize.getText());
        }
        catch (NumberFormatException e) {
            this.sampleSize = 0.0;
        }
        this.lblSampleSize.setText(String.valueOf(ProtTestAlignment.calculateSampleSize(this.models.getAlignment(), this.sampleSizeMode, this.sampleSize)));
    }

    @Action
    public void buildConsensus() {
        this.displayArea.setText("");
        this.displayArea.setForeground(XProtTestView.NORMAL_COLOR);
        double confidenceInterval = Double.valueOf(this.sliderConfidence.getValue()) / 100.0;
        double supportThreshold = Double.valueOf(this.sliderConsType.getValue()) / 100.0;
        try {
            int selection;
            InformationCriterion ic;
            if (this.radioAIC.isSelected()) {
                ic = new AIC(this.models, confidenceInterval, this.sampleSize);
                selection = 0;
            } else if (this.radioBIC.isSelected()) {
                ic = new BIC(this.models, confidenceInterval, this.sampleSize);
                selection = 1;
            } else if (this.radioAICC.isSelected()) {
                ic = new AICc(this.models, confidenceInterval, this.sampleSize);
                selection = 2;
            } else if (this.radioLK.isSelected()) {
                ic = new LNL(this.models, confidenceInterval, this.sampleSize);
                selection = 3;
            } else if (this.radioDT.isSelected()) {
                ic = new DT(this.models, confidenceInterval, this.sampleSize);
                selection = 4;
            } else {
                ic = null;
                selection = 5;
            }
            this.logHandler.setLevel(Level.INFO);
            if (ic == null || ic.getConfidenceModels().size() > 0) {
                es.uvigo.darwin.prottest.consensus.Consensus consensus = null;
                if (ic == null) {
                    throw new ProtTestInternalException("Consensus needs an Information Criterion");
                }
                consensus = this.facade.createConsensus(ic, supportThreshold);
                this.println("----------------------------------------");
                this.println("Selection criterion: . . . . " + SELECTION[selection]);
                this.println("Confidence interval: . . . . " + confidenceInterval);
                this.println("Sample size: . . . . . . . . " + this.sampleSize);
                this.println("Consensus support threshold: " + supportThreshold);
                this.println("----------------------------------------");
                this.println("");
                this.println("# # # # # # # # # # # # # # # #");
                this.println(" ");
                this.println("Species in order:");
                this.println(" ");
                for (int i = 0; i < consensus.getIdGroup().getIdCount(); ++i) {
                    Identifier id = consensus.getIdGroup().getIdentifier(i);
                    this.println("    " + (i + 1) + ". " + id.getName());
                }
                this.println(" ");
                this.println("# # # # # # # # # # # # # # # #");
                this.println(" ");
                this.println("Sets included in the consensus tree");
                this.println(" ");
                int numTaxa = consensus.getIdGroup().getIdCount();
                this.println(consensus.getSetsIncluded());
                this.println(" ");
                this.println("Sets NOT included in consensus tree");
                this.println(" ");
                this.println(consensus.getSetsNotIncluded());
                this.println(" ");
                this.println("# # # # # # # # # # # # # # # #");
                this.println(" ");
                Tree consensusTree = consensus.getConsensusTree();
                String newickTree = this.facade.toNewick(consensusTree, true, true, true);
                this.println(newickTree);
                this.println(" ");
                this.println("# # # # # # # # # # # # # # # #");
                this.println(" ");
                this.println(this.facade.toASCII(consensusTree));
                this.println(" ");
                this.println(this.facade.branchInfo(consensusTree));
                this.println(" ");
                this.println(this.facade.heightInfo(consensusTree));
            } else {
                this.displayArea.setForeground(XProtTestView.CRITIC_COLOR);
                this.println(this.resourceMap.getString("msg-no-data", new Object[0]));
            }
        }
        catch (NumberFormatException e) {
            this.displayArea.setForeground(XProtTestView.CRITIC_COLOR);
            this.println(this.resourceMap.getString("msg-sample-size-error", new Object[0]));
        }
        this.logHandler.setLevel(Level.OFF);
        this.btnExport.setEnabled(!this.displayArea.getText().equals(""));
    }

    @Action
    public void disableSampleSize() {
        this.txtSampleSize.setEnabled(false);
    }

    @Action
    public void enableSampleSize() {
        this.txtSampleSize.setEnabled(true);
    }

    @Action
    public void close() {
        ProtTestLogger.getDefaultLogger().removeHandler(this.logHandler);
        this.setVisible(false);
    }

    @Action
    public void editCopy() {
        this.displayArea.copy();
    }

    @Action
    public void editSelectAll() {
        this.displayArea.selectAll();
    }

    @Action
    public void selectSampleSize() {
    }

    private void print(String message) {
        ProtTestLogger.info(message, this.getClass());
    }

    private void println(String message) {
        ProtTestLogger.infoln(message, this.getClass());
    }

    @Action
    public void exportData() {
        this.mainFrame.enableHandler();
        ProtTestPrinter.printTreeHeader("MODEL AVERAGED PHYLOGENY");
        ProtTestLogger.getDefaultLogger().infoln(this.displayArea.getText());
        this.mainFrame.disableHandler();
    }
}

