/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.xprottest.analysis;

import es.uvigo.darwin.prottest.facade.TreeFacade;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogger;
import es.uvigo.darwin.prottest.util.printer.ProtTestPrinter;
import es.uvigo.darwin.xprottest.XProtTestView;
import es.uvigo.darwin.xprottest.analysis.TreeWrapper;
import es.uvigo.darwin.xprottest.util.TextAreaWriter;
import java.awt.Font;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import pal.tree.Tree;

public class TreeView
extends JFrame {
    private Tree tree;
    private List<Tree> trees;
    private TreeFacade facade;
    private PrintWriter displayWriter;
    private XProtTestView mainFrame;
    private JButton btnExport;
    private JMenuItem closeMenuItem;
    private JComboBox cmbTreeFormatSelection;
    private JComboBox cmbTreeSelection;
    private JTextArea displayArea;
    private JScrollPane displayScroll;
    private JMenuItem editCopyMenuItem;
    private JMenu editMenu;
    private JMenuItem editSelectAllMenuItem;
    private JMenuBar jMenuBar1;
    private JPanel optionsPanel;
    private ButtonGroup treeDisplayTypeBtnGroup;
    private JMenu windowMenu;

    public TreeView(XProtTestView mainFrame, TreeFacade facade, Tree tree, Model[] models) {
        this.mainFrame = mainFrame;
        this.tree = tree;
        this.facade = facade;
        this.trees = new ArrayList<Tree>(models.length);
        this.initComponents();
        this.displayWriter = new PrintWriter(new TextAreaWriter(this.displayArea));
        Font f = new Font("Monospaced", 0, 12);
        this.displayArea.setFont(f);
        if (tree != null) {
            this.cmbTreeSelection.addItem(new TreeWrapper("Starting Topology", tree));
        }
        if (models != null) {
            for (Model model : models) {
                if (model.getTree() == null) continue;
                this.cmbTreeSelection.addItem(new TreeWrapper(model.getModelName(), model.getTree()));
                this.trees.add(model.getTree());
            }
        }
        if (this.cmbTreeSelection.getItemCount() > 0) {
            this.cmbTreeSelection.setSelectedIndex(0);
        }
        this.treeFormatSelection();
    }

    private void initComponents() {
        this.treeDisplayTypeBtnGroup = new ButtonGroup();
        this.displayScroll = new JScrollPane();
        this.displayArea = new JTextArea();
        this.optionsPanel = new JPanel();
        this.cmbTreeSelection = new JComboBox();
        this.cmbTreeFormatSelection = new JComboBox();
        this.btnExport = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.windowMenu = new JMenu();
        this.closeMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.editCopyMenuItem = new JMenuItem();
        this.editSelectAllMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("es/uvigo/darwin/xprottest/analysis/resources/TreeView");
        this.setTitle(bundle.getString("title"));
        this.setName("Form");
        this.setResizable(false);
        this.displayScroll.setName("displayScroll");
        this.displayArea.setColumns(20);
        this.displayArea.setEditable(false);
        this.displayArea.setRows(5);
        this.displayArea.setName("displayArea");
        this.displayScroll.setViewportView(this.displayArea);
        this.optionsPanel.setName("optionsPanel");
        ApplicationActionMap actionMap = Application.getInstance().getContext().getActionMap(TreeView.class, (Object)this);
        this.cmbTreeSelection.setAction(actionMap.get("treeFormatSelection"));
        this.cmbTreeSelection.setName("cmbTreeSelection");
        this.cmbTreeFormatSelection.setModel(new DefaultComboBoxModel<String>(new String[]{"Newick Format", "ASCII Format"}));
        this.cmbTreeFormatSelection.setSelectedItem("ASCII Format");
        this.cmbTreeFormatSelection.setAction(actionMap.get("treeFormatSelection"));
        this.cmbTreeFormatSelection.setName("cmbTreeFormatSelection");
        this.btnExport.setAction(actionMap.get("exportData"));
        this.btnExport.setText("Export to main console");
        this.btnExport.setName("btnExport");
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cmbTreeSelection, -2, 173, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 47, Short.MAX_VALUE).addComponent(this.cmbTreeFormatSelection, -2, 124, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExport)));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbTreeSelection, -2, -1, -2).addComponent(this.btnExport).addComponent(this.cmbTreeFormatSelection, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jMenuBar1.setName("jMenuBar1");
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(TreeView.class);
        this.windowMenu.setText(resourceMap.getString("windowMenu.text", new Object[0]));
        this.windowMenu.setName("windowMenu");
        this.closeMenuItem.setAction(actionMap.get("close"));
        this.closeMenuItem.setName("closeMenuItem");
        this.windowMenu.add(this.closeMenuItem);
        this.jMenuBar1.add(this.windowMenu);
        this.editMenu.setText(resourceMap.getString("editMenu.text", new Object[0]));
        this.editMenu.setName("editMenu");
        this.editCopyMenuItem.setAction(actionMap.get("editCopy"));
        this.editCopyMenuItem.setName("editCopyMenuItem");
        this.editMenu.add(this.editCopyMenuItem);
        this.editSelectAllMenuItem.setAction(actionMap.get("editSelectAll"));
        this.editSelectAllMenuItem.setName("editSelectAllMenuItem");
        this.editMenu.add(this.editSelectAllMenuItem);
        this.jMenuBar1.add(this.editMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayScroll, -1, 527, Short.MAX_VALUE).addComponent(this.optionsPanel, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.optionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayScroll, -1, 451, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void displayAsciiTree(Tree tree) {
        this.displayArea.setText("");
        this.displayArea.setLineWrap(false);
        this.displayWriter.println(this.facade.toASCII(tree));
        this.displayWriter.println(" ");
        this.displayWriter.println(this.facade.branchInfo(tree));
        this.displayWriter.println(" ");
        this.displayWriter.println(this.facade.heightInfo(tree));
    }

    private void displayNewickTree(Tree tree) {
        this.displayArea.setText("");
        this.displayArea.setLineWrap(true);
        String newickTree = this.facade.toNewick(tree, true, true, false);
        this.displayWriter.println(newickTree);
    }

    @Action
    public void treeFormatSelection() {
        Tree displayTree = ((TreeWrapper)this.cmbTreeSelection.getSelectedItem()).getTree();
        if (this.cmbTreeFormatSelection.getSelectedItem().toString().toLowerCase().contains("newick")) {
            this.displayNewickTree(displayTree);
        } else if (this.cmbTreeFormatSelection.getSelectedItem().toString().toLowerCase().contains("ascii")) {
            this.displayAsciiTree(displayTree);
        }
    }

    @Action
    public void editCopy() {
        this.displayArea.copy();
    }

    @Action
    public void editSelectAll() {
        this.displayArea.selectAll();
    }

    @Action
    public void close() {
        this.setVisible(false);
    }

    @Action
    public void exportData() {
        this.mainFrame.enableHandler();
        ProtTestPrinter.printTreeHeader(((TreeWrapper)this.cmbTreeSelection.getSelectedItem()).toString());
        ProtTestLogger.getDefaultLogger().infoln(this.displayArea.getText());
        this.mainFrame.disableHandler();
    }
}

