/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.xprottest.analysis;

import es.uvigo.darwin.prottest.util.ProtTestAlignment;
import es.uvigo.darwin.prottest.util.printer.ProtTestFormattedOutput;
import es.uvigo.darwin.xprottest.XProtTestApp;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import pal.alignment.Alignment;

public class FrequenciesView
extends JFrame {
    private int freqWidth = 5;
    private JScrollPane jScrollPane1;
    private JLabel lblTitle;
    private JTable tableFrequencies;

    public FrequenciesView(Alignment alignment) {
        this.initComponents();
        double[] frequencies = ProtTestAlignment.getFrequencies(alignment);
        for (int i = 0; i < frequencies.length; ++i) {
            this.tableFrequencies.setValueAt(Character.valueOf(ProtTestAlignment.charOfIndex(i)), i, 0);
            this.tableFrequencies.setValueAt(ProtTestFormattedOutput.getDecimalString(frequencies[i], this.freqWidth), i, 1);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tableFrequencies = new JTable();
        this.lblTitle = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.jScrollPane1.setName("jScrollPane1");
        ResourceMap resourceMap = ((XProtTestApp)Application.getInstance(XProtTestApp.class)).getContext().getResourceMap(FrequenciesView.class);
        this.tableFrequencies.setBackground(resourceMap.getColor("tableFrequencies.background"));
        DefaultTableModel freqTableModel = new DefaultTableModel(){

            public Class getColumnClass(int column) {
                if (column >= 0 && column <= this.getColumnCount()) {
                    try {
                        return this.getValueAt(0, column).getClass();
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        return Object.class;
                    }
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        freqTableModel.addColumn((Object)"AA", (Object[])new String[20][1]);
        freqTableModel.addColumn((Object)"Frequency", (Object[])new Double[20][1]);
        this.tableFrequencies.setModel(freqTableModel);
        TableRowSorter<1> freqSorter = new TableRowSorter<1>(freqTableModel);
        this.tableFrequencies.setRowSorter(freqSorter);
        this.tableFrequencies.setColumnSelectionAllowed(true);
        this.tableFrequencies.setName("tableFrequencies");
        this.jScrollPane1.setViewportView(this.tableFrequencies);
        this.lblTitle.setHorizontalAlignment(0);
        ResourceBundle bundle = ResourceBundle.getBundle("es/uvigo/darwin/xprottest/analysis/resources/FrequenciesView");
        this.lblTitle.setText(bundle.getString("msg-title"));
        this.lblTitle.setName("lblTitle");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 217, Short.MAX_VALUE).addComponent(this.lblTitle, GroupLayout.Alignment.LEADING, -1, 217, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 343, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }
}

