/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.xprottest;

import es.uvigo.darwin.prottest.facade.ProtTestFacade;
import es.uvigo.darwin.prottest.facade.TreeFacadeImpl;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.ProtTestAlignment;
import es.uvigo.darwin.prottest.util.exception.AlignmentParseException;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.factory.ProtTestFactory;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogger;
import es.uvigo.darwin.prottest.util.printer.ProtTestFormattedOutput;
import es.uvigo.darwin.prottest.util.printer.ProtTestPrinter;
import es.uvigo.darwin.xprottest.CreditsBox;
import es.uvigo.darwin.xprottest.PreferencesView;
import es.uvigo.darwin.xprottest.XProtTestAboutBox;
import es.uvigo.darwin.xprottest.XProtTestApp;
import es.uvigo.darwin.xprottest.analysis.FrequenciesView;
import es.uvigo.darwin.xprottest.analysis.TreeView;
import es.uvigo.darwin.xprottest.analysis.consensus.Consensus;
import es.uvigo.darwin.xprottest.compute.OptionsView;
import es.uvigo.darwin.xprottest.compute.RunningFrame;
import es.uvigo.darwin.xprottest.results.ErrorLogView;
import es.uvigo.darwin.xprottest.results.ResultsView;
import es.uvigo.darwin.xprottest.util.BrowserLauncher;
import es.uvigo.darwin.xprottest.util.TextAreaAppender;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.plaf.BorderUIResource;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.application.TaskService;
import pal.alignment.Alignment;
import pal.tree.Tree;

public final class XProtTestView
extends FrameView {
    public static final Color NORMAL_COLOR = Color.BLACK;
    public static final Color CRITIC_COLOR = new Color(153, 0, 0);
    public static final Color DONE_COLOR = new Color(102, 102, 153);
    private int errorBehavior;
    private ResourceMap resourceMap;
    private Alignment alignment;
    private Tree tree;
    private ProtTestFacade prottestFacade;
    private boolean alignmentLoaded;
    private File alignmentFile;
    private boolean lnlCalculated;
    private PrintWriter displayWriter;
    private Model[] models;
    private Handler mainHandler;
    private ResultsView resultsView;
    private TreeView treeView;
    private Consensus consensusView;
    private FrequenciesView frequenciesView;
    private ErrorLogView errorLogView;
    private boolean correctDone;
    private int numModels;
    private boolean taskRunning = false;
    private JMenu analysisMenu;
    private JMenuItem averagingMenuItem;
    private JMenuItem computeMenuItem;
    private JMenuItem editCopyMenuItem;
    private JMenu editMenu;
    private JMenuItem editSelectAllMenuItem;
    private JMenuItem errorMenuItem;
    private JLabel lblDataFileStatus;
    private JLabel lblLikelihoodStatus;
    private JLabel lblMoreInfo;
    private JMenuItem loadAlignmentMenuItem;
    private JPanel mainPanel;
    private JScrollPane mainScrollPane;
    private JTextArea mainTextArea;
    private JMenuItem manualMenuItem;
    private JMenuBar menuBar;
    private JMenuItem preferencesMenuItem;
    private JMenu resultsMenu;
    private JMenuItem resultsMenuItem;
    private JMenuItem showFrequenciesItem;
    private JMenuItem showTreeMenuItem;
    private JPanel statusPanel;
    private JMenuItem saveConsoleMenuItem;
    private JMenuItem printConsoleMenuItem;
    private JMenuItem creditsMenuItem = new JMenuItem();
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    private JDialog creditsBox;

    public int getErrorBehavior() {
        return this.errorBehavior;
    }

    protected void setErrorBehavior(int errorBehavior) {
        this.errorBehavior = errorBehavior;
    }

    public ProtTestFacade getFacade() {
        return this.prottestFacade;
    }

    private void setAlignmentFile(File alignmentFile) {
        this.enableHandler();
        int numDecimals = 5;
        boolean bl = this.alignmentLoaded = alignmentFile != null;
        if (this.alignmentLoaded) {
            this.lblDataFileStatus.setText(this.resourceMap.getString("msg-data-loaded", new Object[0]) + " " + alignmentFile.getName());
            this.lblDataFileStatus.setForeground(DONE_COLOR);
            this.alignmentFile = alignmentFile;
            this.showFrequenciesItem.setEnabled(true);
            double[] frequencies = ProtTestAlignment.getFrequencies(this.alignment);
            this.displayWriter.println("");
            this.displayWriter.println(this.resourceMap.getString("aa-frequencies", new Object[0]));
            this.displayWriter.println(ProtTestFormattedOutput.space(this.resourceMap.getString("aa-frequencies", new Object[0]).length(), '-'));
            for (int i = 0; i < frequencies.length; ++i) {
                this.displayWriter.println(ProtTestAlignment.charOfIndex(i) + " - " + ProtTestFormattedOutput.getDecimalString(frequencies[i], numDecimals));
            }
        } else {
            this.lblDataFileStatus.setText(this.resourceMap.getString("msg-no-data", new Object[0]));
            this.lblDataFileStatus.setForeground(CRITIC_COLOR);
            this.showFrequenciesItem.setEnabled(false);
        }
        this.frequenciesView = null;
        this.computeMenuItem.setEnabled(this.alignmentLoaded);
        this.resultsMenuItem.setEnabled(false);
        if (this.resultsView != null) {
            this.resultsView.dispose();
            this.resultsView = null;
        }
        this.showTreeMenuItem.setEnabled(false);
        if (this.treeView != null) {
            this.treeView.dispose();
            this.treeView = null;
        }
        this.averagingMenuItem.setEnabled(false);
        if (this.consensusView != null) {
            this.consensusView.dispose();
            this.consensusView = null;
        }
        this.disableHandler();
    }

    public PrintWriter getDisplayWriter() {
        return this.displayWriter;
    }

    public XProtTestView(SingleFrameApplication app, ProtTestFacade facade) {
        super((Application)app);
        this.resourceMap = ((XProtTestApp)Application.getInstance(XProtTestApp.class)).getContext().getResourceMap(XProtTestView.class);
        this.errorBehavior = ((XProtTestApp)Application.getInstance(XProtTestApp.class)).getContext().getResourceMap(XProtTestApp.class).getInteger("default-error-behavior");
        this.prottestFacade = facade;
        this.initComponents();
        this.displayWriter = new PrintWriter(new TextAreaAppender(this.mainTextArea));
        this.mainHandler = ProtTestLogger.getDefaultLogger().addHandler(this.displayWriter);
        try {
            Handler logHandler = ProtTestFactory.getInstance().createLogHandler();
            if (logHandler != null) {
                ProtTestLogger.getDefaultLogger().addHandler(logHandler);
            }
        }
        catch (IOException ex) {
            ProtTestLogger.getDefaultLogger().severeln(ex.getMessage());
        }
        int messageTimeout = this.resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XProtTestView.this.lblLikelihoodStatus.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = this.resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = this.resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XProtTestView.this.busyIconIndex = (XProtTestView.this.busyIconIndex + 1) % XProtTestView.this.busyIcons.length;
                XProtTestView.this.lblDataFileStatus.setIcon(XProtTestView.this.busyIcons[XProtTestView.this.busyIconIndex]);
            }
        });
        this.idleIcon = this.resourceMap.getIcon("StatusBar.idleIcon");
        this.lblDataFileStatus.setIcon(this.idleIcon);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!XProtTestView.this.busyIconTimer.isRunning()) {
                        XProtTestView.this.lblDataFileStatus.setIcon(XProtTestView.this.busyIcons[0]);
                        XProtTestView.this.busyIconIndex = 0;
                        XProtTestView.this.busyIconTimer.start();
                    }
                } else if ("done".equals(propertyName)) {
                    XProtTestView.this.busyIconTimer.stop();
                    XProtTestView.this.lblDataFileStatus.setIcon(XProtTestView.this.idleIcon);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    XProtTestView.this.lblLikelihoodStatus.setText(text == null ? "" : text);
                    XProtTestView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int n = (Integer)evt.getNewValue();
                }
            }
        });
        this.lblMoreInfo.setVisible(false);
        ProtTestPrinter.printHeader();
        this.disableHandler();
    }

    public void disableHandler() {
        this.mainHandler.setLevel(Level.OFF);
    }

    public void enableHandler() {
        this.mainHandler.setLevel(Level.INFO);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = XProtTestApp.getApplication().getMainFrame();
            this.aboutBox = new XProtTestAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        this.aboutBox.setVisible(true);
    }

    @Action
    public void showCreditsBox() {
        if (this.creditsBox == null) {
            JFrame mainFrame = XProtTestApp.getApplication().getMainFrame();
            this.creditsBox = new CreditsBox(mainFrame);
            this.creditsBox.setLocationRelativeTo(mainFrame);
        }
        this.creditsBox.setVisible(true);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.mainScrollPane = new JScrollPane();
        this.mainTextArea = new JTextArea();
        this.statusPanel = new JPanel();
        this.lblDataFileStatus = new JLabel();
        this.lblLikelihoodStatus = new JLabel();
        this.lblMoreInfo = new JLabel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.loadAlignmentMenuItem = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        this.saveConsoleMenuItem = new JMenuItem();
        this.printConsoleMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.editCopyMenuItem = new JMenuItem();
        this.editSelectAllMenuItem = new JMenuItem();
        this.preferencesMenuItem = new JMenuItem();
        this.analysisMenu = new JMenu();
        this.computeMenuItem = new JMenuItem();
        this.showFrequenciesItem = new JMenuItem();
        this.showTreeMenuItem = new JMenuItem();
        this.averagingMenuItem = new JMenuItem();
        this.resultsMenu = new JMenu();
        this.resultsMenuItem = new JMenuItem();
        this.errorMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        this.manualMenuItem = new JMenuItem();
        JMenuItem aboutMenuItem = new JMenuItem();
        ResourceMap appResourceMap = ((XProtTestApp)Application.getInstance(XProtTestApp.class)).getContext().getResourceMap(XProtTestView.class);
        this.mainPanel.setSize(new Dimension(500, 860));
        this.mainPanel.setBorder(new BorderUIResource.EmptyBorderUIResource(new Insets(20, 20, 20, 20)));
        this.mainPanel.setLocation(new Point(10, -10));
        this.mainPanel.setVisible(true);
        this.mainPanel.setAutoscrolls(true);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBackground(null);
        this.mainPanel.setName("mainPanel");
        this.mainScrollPane.setSize(590, 800);
        this.mainScrollPane.setLocation(new Point(20, 20));
        this.mainScrollPane.setVisible(true);
        this.mainScrollPane.setAutoscrolls(true);
        this.mainScrollPane.setName("mainScrollPane");
        this.mainTextArea.setMargin(new Insets(5, 5, 5, 5));
        this.mainTextArea.setBackground(Color.white);
        this.mainTextArea.setEditable(false);
        this.mainTextArea.setSize(500, 800);
        this.mainTextArea.setAutoscrolls(true);
        this.mainTextArea.setVisible(true);
        this.mainTextArea.setFont(XProtTestApp.FONT_CONSOLE);
        this.mainTextArea.setName("mainTextArea");
        this.mainScrollPane.setHorizontalScrollBarPolicy(31);
        this.mainTextArea.setWrapStyleWord(true);
        this.mainTextArea.setLineWrap(true);
        this.statusPanel.setPreferredSize(new Dimension(592, 30));
        this.statusPanel.setBorder(new BorderUIResource.EtchedBorderUIResource(1, new Color(182, 182, 182), new Color(89, 89, 89)));
        this.statusPanel.setLocation(new Point(20, 630));
        this.statusPanel.setVisible(true);
        this.statusPanel.setLayout(new BorderLayout());
        this.statusPanel.setForeground(Color.blue);
        this.statusPanel.setBackground(new Color(220, 220, 220));
        this.statusPanel.setName("statusPanel");
        this.lblDataFileStatus.setSize(new Dimension(150, 40));
        this.lblDataFileStatus.setVisible(true);
        this.lblDataFileStatus.setForeground(CRITIC_COLOR);
        this.lblDataFileStatus.setHorizontalAlignment(4);
        this.lblDataFileStatus.setFont(XProtTestApp.FONT_LABEL);
        ResourceBundle bundle = ResourceBundle.getBundle("es/uvigo/darwin/xprottest/resources/XProtTestView");
        this.lblDataFileStatus.setText(bundle.getString("msg-no-data"));
        this.lblDataFileStatus.setName("lblDataFileStatus");
        this.lblLikelihoodStatus.setSize(new Dimension(270, 40));
        this.lblLikelihoodStatus.setVisible(true);
        this.lblLikelihoodStatus.setForeground(CRITIC_COLOR);
        this.lblLikelihoodStatus.setFont(XProtTestApp.FONT_LABEL);
        this.lblLikelihoodStatus.setText(bundle.getString("msg-no-lnl-calculated"));
        this.lblLikelihoodStatus.setName("lblLikelihoodStatus");
        this.mainPanel.add((Component)this.mainScrollPane, "Center");
        this.mainPanel.add((Component)this.statusPanel, "Last");
        this.mainScrollPane.getViewport().add(this.mainTextArea);
        this.statusPanel.add((Component)this.lblLikelihoodStatus, "Before");
        this.statusPanel.add((Component)this.lblDataFileStatus, "After");
        this.menuBar.setName("menuBar");
        ApplicationActionMap actionMap = ((XProtTestApp)Application.getInstance(XProtTestApp.class)).getContext().getActionMap(XProtTestView.class, (Object)this);
        fileMenu.setAction(actionMap.get("openDataFile"));
        fileMenu.setMnemonic('F');
        fileMenu.setText(bundle.getString("item-file"));
        fileMenu.setName("fileMenu");
        this.saveConsoleMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveConsoleMenuItem.setMnemonic('S');
        this.saveConsoleMenuItem.setText(bundle.getString("item-save-console"));
        this.saveConsoleMenuItem.setName("saveConsoleMenuItem");
        this.saveConsoleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XProtTestView.this.saveConsole(evt);
            }
        });
        this.printConsoleMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.printConsoleMenuItem.setMnemonic('P');
        this.printConsoleMenuItem.setText(bundle.getString("item-print-console"));
        this.printConsoleMenuItem.setName("printConsoleMenuItem");
        this.printConsoleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XProtTestView.this.printConsole(evt);
            }
        });
        this.loadAlignmentMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.loadAlignmentMenuItem.setMnemonic('L');
        this.loadAlignmentMenuItem.setText(bundle.getString("item-load-alignment"));
        this.loadAlignmentMenuItem.setName("loadAlignmentMenuItem");
        this.loadAlignmentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XProtTestView.this.openDataFile(evt);
            }
        });
        fileMenu.add(this.loadAlignmentMenuItem);
        fileMenu.add(this.saveConsoleMenuItem);
        fileMenu.add(this.printConsoleMenuItem);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setMnemonic('x');
        exitMenuItem.setName("menuFileExit");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.editMenu.setMnemonic('E');
        this.editMenu.setText(appResourceMap.getString("menu-edit", new Object[0]));
        this.editMenu.setName("editMenu");
        this.editCopyMenuItem.setAction(actionMap.get("editCopy"));
        this.editCopyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.editCopyMenuItem.setMnemonic('c');
        this.editCopyMenuItem.setText(appResourceMap.getString("menu-copy", new Object[0]));
        this.editCopyMenuItem.setToolTipText(appResourceMap.getString("editCopyMenuItem.toolTipText", new Object[0]));
        this.editCopyMenuItem.setName("editCopyMenuItem");
        this.editMenu.add(this.editCopyMenuItem);
        this.editSelectAllMenuItem.setAction(actionMap.get("editSelectAll"));
        this.editSelectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.editSelectAllMenuItem.setMnemonic('a');
        this.editSelectAllMenuItem.setText(appResourceMap.getString("menu-selectAll", new Object[0]));
        this.editSelectAllMenuItem.setToolTipText(appResourceMap.getString("editSelectAllMenuItem.toolTipText", new Object[0]));
        this.editSelectAllMenuItem.setName("editSelectAllMenuItem");
        this.editMenu.add(this.editSelectAllMenuItem);
        this.preferencesMenuItem.setMnemonic('p');
        this.preferencesMenuItem.setText(appResourceMap.getString("menu-preferences", new Object[0]));
        this.preferencesMenuItem.setToolTipText(appResourceMap.getString("editPreferencesMenuItem.toolTipText", new Object[0]));
        this.preferencesMenuItem.setName("preferencesMenuItem");
        this.preferencesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XProtTestView.this.loadPreferencesView(evt);
            }
        });
        this.editMenu.add(this.preferencesMenuItem);
        this.menuBar.add(this.editMenu);
        this.analysisMenu.setMnemonic('A');
        this.analysisMenu.setText(bundle.getString("item-analysis"));
        this.analysisMenu.setName("analysisMenu");
        this.computeMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.computeMenuItem.setMnemonic('c');
        this.computeMenuItem.setText(bundle.getString("item-compute-likelihood"));
        this.computeMenuItem.setToolTipText(appResourceMap.getString("computeMenuItem.toolTipText", new Object[0]));
        this.computeMenuItem.setEnabled(false);
        this.computeMenuItem.setName("computeMenuItem");
        this.computeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XProtTestView.this.loadOptionsView(evt);
            }
        });
        this.analysisMenu.add(this.computeMenuItem);
        this.showFrequenciesItem.setAction(actionMap.get("showAminoacidFrequencies"));
        this.showFrequenciesItem.setAccelerator(KeyStroke.getKeyStroke(70, 3));
        this.showFrequenciesItem.setMnemonic('f');
        this.showFrequenciesItem.setText(bundle.getString("item-show-frequencies"));
        this.showFrequenciesItem.setToolTipText(appResourceMap.getString("showFrequenciesItem.toolTipText", new Object[0]));
        this.showFrequenciesItem.setEnabled(false);
        this.showFrequenciesItem.setName("showFrequenciesItem");
        this.analysisMenu.add(this.showFrequenciesItem);
        this.showTreeMenuItem.setAction(actionMap.get("showTree"));
        this.showTreeMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 3));
        this.showTreeMenuItem.setMnemonic('t');
        this.showTreeMenuItem.setText(bundle.getString("item-show-tree"));
        this.showTreeMenuItem.setToolTipText(appResourceMap.getString("showTreeMenuItem.toolTipText", new Object[0]));
        this.showTreeMenuItem.setEnabled(false);
        this.showTreeMenuItem.setName("showTreeMenuItem");
        this.analysisMenu.add(this.showTreeMenuItem);
        this.averagingMenuItem.setAction(actionMap.get("showConsensus"));
        this.averagingMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 3));
        this.averagingMenuItem.setMnemonic('p');
        this.averagingMenuItem.setText(appResourceMap.getString("averagingMenuItem.text", new Object[0]));
        this.averagingMenuItem.setToolTipText(appResourceMap.getString("averagingMenuItem.toolTipText", new Object[0]));
        this.averagingMenuItem.setEnabled(false);
        this.averagingMenuItem.setName("averagingMenuItem");
        this.analysisMenu.add(this.averagingMenuItem);
        this.menuBar.add(this.analysisMenu);
        this.resultsMenu.setAction(actionMap.get("showResultsWindow"));
        this.resultsMenu.setMnemonic('S');
        this.resultsMenu.setText(bundle.getString("item-results"));
        this.resultsMenu.setName("resultsMenu");
        this.resultsMenuItem.setAction(actionMap.get("showResultsWindow"));
        this.resultsMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 3));
        this.resultsMenuItem.setMnemonic('r');
        this.resultsMenuItem.setText(bundle.getString("item-results-sub"));
        this.resultsMenuItem.setEnabled(false);
        this.resultsMenuItem.setName("resultsMenuItem");
        this.resultsMenuItem.setToolTipText(appResourceMap.getString("resultsMenuItem.toolTipText", new Object[0]));
        this.resultsMenu.add(this.resultsMenuItem);
        this.errorMenuItem.setAction(actionMap.get("showErrorLog"));
        this.errorMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 3));
        this.errorMenuItem.setMnemonic('e');
        this.errorMenuItem.setText(appResourceMap.getString("errorMenuItem.text", new Object[0]));
        this.errorMenuItem.setToolTipText(appResourceMap.getString("errorMenuItem.toolTipText", new Object[0]));
        this.errorMenuItem.setEnabled(false);
        this.errorMenuItem.setName("errorMenuItem");
        this.resultsMenu.add(this.errorMenuItem);
        this.menuBar.add(this.resultsMenu);
        helpMenu.setMnemonic('H');
        helpMenu.setText(bundle.getString("item-help"));
        helpMenu.setName("helpMenu");
        this.manualMenuItem.setAction(actionMap.get("showManual"));
        this.manualMenuItem.setMnemonic('m');
        this.manualMenuItem.setText(appResourceMap.getString("menu-manual", new Object[0]));
        this.manualMenuItem.setName("manualMenuItem");
        helpMenu.add(this.manualMenuItem);
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setText(bundle.getString("item-about-window"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.creditsMenuItem.setAction(actionMap.get("showCreditsBox"));
        this.creditsMenuItem.setText(bundle.getString("item-credits-window"));
        this.creditsMenuItem.setName("creditsMenuItem");
        helpMenu.add(this.creditsMenuItem);
        this.menuBar.add(helpMenu);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.getFrame().setLayout(new BorderLayout());
        this.getFrame().setLocation(new Point(281, 80));
        this.getFrame().getContentPane().setLayout(new BorderLayout());
        this.getFrame().setTitle("ProtTest-HPC 3.0");
        this.getFrame().setSize(new Dimension(630, 695));
        this.getFrame().setResizable(true);
        this.getFrame().setContentPane(this.mainPanel);
    }

    private void openDataFile(ActionEvent evt) {
        FileDialog fc = new FileDialog((Frame)this.getFrame(), "Load DNA alignment", 0);
        fc.setDirectory(System.getProperty("user.dir"));
        fc.setVisible(true);
        String dataFileName = fc.getFile();
        if (dataFileName != null) {
            this.enableHandler();
            try {
                ProtTestPrinter.printPreAnalysisHeader();
                File f = new File(fc.getDirectory() + dataFileName);
                ProtTestPrinter.printFileData(f);
                if (this.alignmentFile == null || !f.getAbsolutePath().equals(this.alignmentFile.getAbsolutePath())) {
                    this.lblLikelihoodStatus.setText(this.resourceMap.getString("msg-no-lnl-calculated", new Object[0]));
                    this.lblLikelihoodStatus.setForeground(CRITIC_COLOR);
                    this.lnlCalculated = false;
                }
                this.alignment = this.prottestFacade.readAlignment(f.getAbsolutePath(), true);
                this.setAlignmentFile(f);
            }
            catch (AlignmentParseException ex) {
                this.displayWriter.println(ex.getMessage());
                this.setAlignmentFile(null);
            }
            catch (FileNotFoundException ex) {
                this.displayWriter.println(ex.getMessage());
                this.setAlignmentFile(null);
            }
            catch (IOException ex) {
                this.displayWriter.println(ex.getMessage());
                this.setAlignmentFile(null);
            }
            this.disableHandler();
        }
    }

    private void saveConsole(ActionEvent evt) {
        String text = this.mainTextArea.getText();
        FileDialog fc = new FileDialog((Frame)this.getFrame(), "Load DNA alignment", 1);
        fc.setDirectory(System.getProperty("user.dir"));
        fc.setVisible(true);
        String dataFileName = fc.getFile();
        try {
            File f = new File(dataFileName);
            FileWriter fw = new FileWriter(f);
            fw.write(text);
            fw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(XProtTestView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void printConsole(ActionEvent evt) {
        try {
            this.mainTextArea.print();
        }
        catch (PrinterException ex) {
            Logger.getLogger(XProtTestView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadOptionsView(ActionEvent evt) {
        OptionsView op = new OptionsView(this, this.alignment, this.alignmentFile.getAbsolutePath());
        op.setVisible(true);
        this.getFrame().setEnabled(false);
    }

    private void loadPreferencesView(ActionEvent evt) {
        PreferencesView pv = new PreferencesView(this);
        pv.setVisible(true);
        this.getFrame().setEnabled(false);
    }

    public void unloadOptionsView(boolean running) {
        if (!running) {
            this.getFrame().setEnabled(true);
        }
    }

    public void unloadPreferencesView() {
        this.getFrame().setEnabled(true);
    }

    @Action
    public void showAminoacidFrequencies() {
        if (this.alignment != null) {
            if (this.frequenciesView == null) {
                this.frequenciesView = new FrequenciesView(this.alignment);
            }
            this.frequenciesView.setVisible(true);
        }
    }

    @Action
    public void showResultsWindow() {
        if (this.models != null) {
            if (this.resultsView == null) {
                this.resultsView = new ResultsView(this, this.alignment, this.models, this.correctDone);
            }
            this.resultsView.setVisible(true);
        }
    }

    public void computeLikelihood(int numModels, ApplicationOptions options) {
        this.enableHandler();
        ProtTestPrinter.printExecutionHeader(options);
        this.preferencesMenuItem.setEnabled(false);
        this.numModels = numModels;
        if (this.errorLogView != null) {
            ProtTestLogger.getDefaultLogger().removeHandler(this.errorLogView.getLogHandler());
            this.errorLogView.setVisible(false);
            this.errorLogView.dispose();
            this.errorLogView = null;
        }
        if (this.resultsView != null) {
            this.resultsView.setVisible(false);
            this.resultsView.dispose();
            this.resultsView = null;
        }
        if (this.treeView != null) {
            this.treeView.setVisible(false);
            this.treeView.dispose();
            this.treeView = null;
        }
        if (this.consensusView != null) {
            this.consensusView.setVisible(false);
            this.consensusView.dispose();
            this.consensusView = null;
        }
        this.errorLogView = new ErrorLogView();
        ProtTestLogger.getDefaultLogger().addHandler(this.errorLogView.getLogHandler());
        RunningFrame runningFrame = new RunningFrame(this, numModels);
        this.errorMenuItem.setEnabled(false);
        this.prottestFacade.addObserver(runningFrame);
        this.lblMoreInfo.setVisible(false);
        ComputeLikelihoodTask task = new ComputeLikelihoodTask(this.getApplication(), runningFrame, this, options);
        ApplicationContext appC = Application.getInstance().getContext();
        TaskMonitor tM = appC.getTaskMonitor();
        TaskService tS = appC.getTaskService();
        tS.execute((Task)task);
        this.taskRunning = true;
        this.getFrame().setEnabled(false);
        runningFrame.setVisible(true);
    }

    protected void computationDone(boolean done, Model[] models) {
        this.preferencesMenuItem.setEnabled(true);
        if (done) {
            boolean bl = this.correctDone = models.length == this.numModels;
            if (this.correctDone) {
                this.lblLikelihoodStatus.setText(this.resourceMap.getString("msg-lnl-calculated", new Object[0]));
                this.lblLikelihoodStatus.setForeground(DONE_COLOR);
                this.errorMenuItem.setEnabled(false);
                this.lblMoreInfo.setVisible(false);
                if (this.errorLogView != null) {
                    this.errorLogView.setVisible(false);
                    this.errorLogView.dispose();
                    this.errorLogView = null;
                }
            } else {
                this.lblLikelihoodStatus.setText("Warning! " + this.resourceMap.getString("models-not-complete", new Object[0]));
                this.lblLikelihoodStatus.setForeground(CRITIC_COLOR);
                this.displayWriter.println("");
                this.displayWriter.println(this.resourceMap.getString("models-not-complete", new Object[0]));
                this.displayWriter.println(this.resourceMap.getString("msg-see-error-log", new Object[0]));
                this.errorMenuItem.setEnabled(true);
                this.lblMoreInfo.setVisible(true);
            }
        } else {
            this.lblLikelihoodStatus.setText(this.resourceMap.getString("msg-lnl-error", new Object[0]));
            this.lblLikelihoodStatus.setForeground(CRITIC_COLOR);
            this.displayWriter.println(this.resourceMap.getString("msg-see-error-log", new Object[0]));
            this.errorMenuItem.setEnabled(true);
        }
        this.lnlCalculated = done;
        this.resultsMenuItem.setEnabled(done);
        this.showTreeMenuItem.setEnabled(done);
        this.averagingMenuItem.setEnabled(done);
        this.models = models;
        this.disableHandler();
    }

    public void computationInterrupted() {
        this.lblLikelihoodStatus.setText(this.resourceMap.getString("msg-lnl-error", new Object[0]));
        this.lblLikelihoodStatus.setForeground(CRITIC_COLOR);
        this.errorMenuItem.setEnabled(true);
        this.lblMoreInfo.setVisible(true);
        this.disableHandler();
    }

    public void unloadRunningView(RunningFrame rf) {
        this.getFrame().setEnabled(true);
        rf.setVisible(false);
        this.disableHandler();
    }

    @Action
    public void showTree() {
        TreeFacadeImpl treeFacade = new TreeFacadeImpl();
        if (this.models != null) {
            if (this.treeView == null) {
                this.treeView = new TreeView(this, treeFacade, this.tree, this.models);
            }
            this.treeView.setVisible(true);
        }
    }

    @Action
    public void showConsensus() {
        TreeFacadeImpl treeFacade = new TreeFacadeImpl();
        if (this.models != null) {
            if (this.consensusView == null) {
                this.consensusView = new Consensus(this, treeFacade, this.models, this.alignment);
            }
            this.consensusView.setVisible(true);
        }
    }

    @Action
    public void showErrorLog() {
        if (this.errorLogView != null) {
            this.errorLogView.setVisible(true);
        }
    }

    @Action
    public void editCopy() {
        this.mainTextArea.copy();
    }

    @Action
    public void editSelectAll() {
        this.mainTextArea.selectAll();
    }

    @Action
    public void showPreferences() {
    }

    @Action
    public void showManual() {
        try {
            BrowserLauncher.openURL("http://darwin.uvigo.es/download/prottest_manual.pdf");
        }
        catch (IOException e) {
            this.displayWriter.println("Cannot open URL : " + e.getMessage());
        }
    }

    private class ComputeLikelihoodTask
    extends Task<Object, Void> {
        private RunningFrame runningFrame;
        private XProtTestView mainFrame;
        private Model[] models;
        private ApplicationOptions options;

        ComputeLikelihoodTask(Application app, RunningFrame runningFrame, XProtTestView mainFrame, ApplicationOptions options) {
            super(app);
            this.options = options;
            this.runningFrame = runningFrame;
            this.mainFrame = mainFrame;
            runningFrame.setTask(this);
        }

        protected Object doInBackground() {
            try {
                this.options.setAlignment(XProtTestView.this.alignmentFile.getAbsolutePath());
                this.models = XProtTestView.this.prottestFacade.startAnalysis(this.options);
            }
            catch (AlignmentParseException ex) {
                ProtTestLogger.severeln(ex.getMessage(), ((Object)((Object)this)).getClass());
            }
            catch (IOException ex) {
                ProtTestLogger.severeln(ex.getMessage(), ((Object)((Object)this)).getClass());
            }
            catch (ProtTestInternalException ex) {
                ProtTestLogger.severeln(ex.getMessage(), ((Object)((Object)this)).getClass());
            }
            this.runningFrame.finishedExecution();
            return null;
        }

        protected void succeeded(Object result) {
            boolean done;
            boolean bl = done = this.models != null && this.models.length > 0;
            if (done) {
                try {
                    for (Model model : this.models) {
                        model.getLk();
                    }
                }
                catch (ProtTestInternalException e) {
                    done = false;
                }
            }
            this.mainFrame.computationDone(done, this.models);
        }

        protected void cancelled() {
            this.mainFrame.computationDone(false, null);
        }

        protected void interrupted(InterruptedException ex) {
            this.mainFrame.computationInterrupted();
        }
    }
}

