/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.printer;

import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogger;
import es.uvigo.darwin.prottest.util.printer.ProtTestFormattedOutput;
import java.io.File;
import java.io.PrintWriter;
import java.util.Date;

public class ProtTestPrinter {
    private static final String H_RULE = "********************************************************";
    private PrintWriter out;
    private PrintWriter err;

    public ProtTestPrinter(PrintWriter out, PrintWriter err) {
        this.out = out;
        this.err = err;
    }

    public static void printHeader() {
        ProtTestPrinter.println("");
        ProtTestPrinter.println("");
        ProtTestPrinter.println("ProtTest 3.0" + ProtTestFormattedOutput.space(27 - "3.0".length(), ' ') + "Fast selection of the best-fit models of protein evolution");
        ProtTestPrinter.println("(c) 2009-2010   Diego Darriba (1,2), Guillermo Taboada (2), Ram\u00f3n Doallo (2), David Posada (1)");
        ProtTestPrinter.println("(1)                               Facultad de Biologia, Universidad de Vigo, 36200 Vigo, Spain");
        ProtTestPrinter.println("(2)                    Facultade de Inform\u00e1tica, Universidade da Coru\u00f1a, 15071 A Coru\u00f1a, Spain");
        ProtTestPrinter.println("Contact:                                                     ddarriba@udc.es, dposada@uvigo.es");
        ProtTestPrinter.println("----------------------------------------------------------------------------------------------");
        ProtTestPrinter.println("");
        ProtTestPrinter.println(new Date().toString());
        ProtTestPrinter.println("OS = " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")");
        ProtTestPrinter.println("");
        ProtTestPrinter.println("Citation: Darriba D, Taboada GL, Doallo R, Posada D. ProtTest 3: fast selection of best-fit ");
        ProtTestPrinter.println("          models of protein evolution. Bioinformatics, 27:1164-1165, 2011");
        ProtTestPrinter.println("");
    }

    public static void printPreAnalysisHeader() {
        ProtTestPrinter.println("");
        ProtTestPrinter.println(H_RULE);
        ProtTestPrinter.println(ProtTestPrinter.center("ALIGNMENT ANALYSIS"));
        ProtTestPrinter.println(H_RULE);
        ProtTestPrinter.println("");
    }

    public static void printSelectionHeader(String criterionName) {
        ProtTestPrinter.println("");
        ProtTestPrinter.println("");
        ProtTestPrinter.println(H_RULE);
        ProtTestPrinter.println(ProtTestPrinter.center(criterionName));
        ProtTestPrinter.println(H_RULE);
    }

    public static void printTreeHeader(String modelName) {
        ProtTestPrinter.println("");
        ProtTestPrinter.println(H_RULE);
        ProtTestPrinter.println(ProtTestPrinter.center(modelName));
        ProtTestPrinter.println(H_RULE);
        ProtTestPrinter.println("");
    }

    public static void printExecutionHeader(ApplicationOptions options) {
        ProtTestPrinter.println("");
        ProtTestPrinter.println(H_RULE);
        ProtTestPrinter.println(ProtTestPrinter.center("MODEL OPTIMIZATION"));
        ProtTestPrinter.println(H_RULE);
        options.reportModelOptimization();
        ProtTestPrinter.println("");
    }

    public static void printFileData(File f) {
        ProtTestPrinter.println("");
        ProtTestPrinter.println("File: " + f.getAbsolutePath());
        ProtTestPrinter.println("Size: " + f.length());
        ProtTestPrinter.println("");
    }

    public static void println(String text) {
        ProtTestLogger.infoln(text, ProtTestPrinter.class);
    }

    public static void printFooter() {
        ProtTestPrinter.println("");
        ProtTestPrinter.println("");
        ProtTestPrinter.println("ProtTest-HPC - 3.0");
    }

    private static String center(String text) {
        return ProtTestFormattedOutput.space((H_RULE.length() - text.length()) / 2, ' ') + text;
    }

    public PrintWriter getOutputWriter() {
        return this.out;
    }

    public void setOutputWriter(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getErrorWriter() {
        return this.err;
    }

    public void setErrorWriter(PrintWriter err) {
        this.err = err;
    }

    public void flush() {
        this.out.flush();
    }

    public void flushError() {
        this.err.flush();
    }

    public void closeError() {
        this.err.close();
    }
}

