/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.printer;

import java.io.PrintWriter;
import pal.io.FormattedOutput;

public class ProtTestFormattedOutput {
    private static final String NAN = "NaN";
    private static FormattedOutput formatter = FormattedOutput.getInstance();

    public static String space(int size, char c) {
        return FormattedOutput.space((int)size, (char)c);
    }

    public static String getDecimalString(double number, int width) {
        String strValue = Double.isNaN(number) ? NAN : formatter.getDecimalString(number, width);
        return strValue;
    }

    public static int displayDecimal(PrintWriter out, double number, int width) {
        int result = 0;
        if (Double.isNaN(number)) {
            formatter.displayLabel(out, NAN, width);
            result = NAN.length();
        } else {
            result = formatter.displayDecimal(out, number, width);
        }
        return result;
    }

    public static String getIntegerString(int num, int maxNum) {
        int lenMaxNum;
        StringBuffer sb = new StringBuffer();
        int lenNum = Integer.toString(num).length();
        if (lenNum < (lenMaxNum = Integer.toString(maxNum).length())) {
            for (int i = 0; i < num; ++i) {
                sb.append(' ');
            }
        }
        sb.append(num);
        return sb.toString();
    }

    public static void displayInteger(PrintWriter out, int num, int maxNum) {
        int lenMaxNum;
        int lenNum = Integer.toString(num).length();
        if (lenNum < (lenMaxNum = Integer.toString(maxNum).length())) {
            ProtTestFormattedOutput.multiplePrint(out, ' ', lenMaxNum - lenNum);
        }
        out.print(num);
    }

    public static void displayIntegerWhite(PrintWriter out, int maxNum) {
        int lenMaxNum = Integer.toString(maxNum).length();
        ProtTestFormattedOutput.multiplePrint(out, ' ', lenMaxNum);
    }

    public static void displayLabel(PrintWriter out, String label, int width) {
        int len = label.length();
        if (len == width) {
            out.print(label);
        } else if (len < width) {
            out.print(label);
            ProtTestFormattedOutput.multiplePrint(out, ' ', width - len);
        } else {
            for (int i = 0; i < width; ++i) {
                out.print(label.charAt(i));
            }
        }
    }

    public static void multiplePrint(PrintWriter out, char c, int num) {
        for (int i = 0; i < num; ++i) {
            out.print(c);
        }
    }
}

