/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.logging;

import es.uvigo.darwin.prottest.util.WriterOutputStream;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogFormatter;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class ProtTestLogger {
    public static final String DEFAULT_LOGGER_NAME = "default";
    public static final Level DEFAULT_LEVEL = Level.INFO;
    private static HashMap<String, ProtTestLogger> loggers = new HashMap();
    private String loggerName;
    private Level loggerLevel;
    private List<Handler> handlers;
    private Handler stdHandler;

    public static ProtTestLogger getLogger(String loggerName, boolean force) {
        if (!loggers.containsKey(loggerName)) {
            if (force) {
                loggers.put(loggerName, new ProtTestLogger(loggerName));
            } else {
                return null;
            }
        }
        return loggers.get(loggerName);
    }

    public static boolean exists(Class classLogger) {
        return ProtTestLogger.getLogger(classLogger.getName(), false) != null;
    }

    public ProtTestLogger(String loggerName) {
        this.loggerName = loggerName;
        if (loggers.containsKey(loggerName)) {
            throw new ProtTestInternalException("ProtTestLogger with name " + loggerName + " already exists. " + " Use getLogger() instead");
        }
        this.loggerLevel = Level.ALL;
        this.handlers = new ArrayList<Handler>();
        this.stdHandler = new StreamHandler(System.out, new ProtTestLogFormatter());
        this.stdHandler.setLevel(Level.OFF);
        this.handlers.add(this.stdHandler);
    }

    public static ProtTestLogger getDefaultLogger() {
        return ProtTestLogger.getLogger(DEFAULT_LOGGER_NAME, true);
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.loggerLevel.intValue() && this.loggerLevel.intValue() != Level.OFF.intValue();
    }

    public void addHandler(Handler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handlers.add(handler);
    }

    public void addHandler(Handler[] newHandlers) {
        for (Handler handler : newHandlers) {
            if (handler == null) {
                throw new NullPointerException();
            }
            if (this.handlers.contains(handler)) continue;
            this.handlers.add(handler);
        }
    }

    public Handler addHandler(OutputStream out) {
        return this.addHandler(out, DEFAULT_LEVEL);
    }

    public Handler addHandler(OutputStream out, Level level) {
        if (out == null) {
            throw new NullPointerException();
        }
        StreamHandler handler = new StreamHandler(out, new ProtTestLogFormatter());
        handler.setLevel(level);
        this.handlers.add(handler);
        return handler;
    }

    public Handler addHandler(Writer out) {
        return this.addHandler(out, DEFAULT_LEVEL);
    }

    public Handler addHandler(Writer out, Level level) {
        if (out == null) {
            throw new NullPointerException();
        }
        StreamHandler handler = new StreamHandler(new WriterOutputStream(out), new ProtTestLogFormatter());
        handler.setLevel(level);
        this.handlers.add(handler);
        return handler;
    }

    public boolean removeHandler(Handler handler) {
        return this.handlers.remove(handler);
    }

    public Handler[] getHandlers() {
        return this.handlers.toArray(new Handler[0]);
    }

    public void setStdHandlerLevel(Level newLevel) {
        if (newLevel == null) {
            throw new NullPointerException();
        }
        this.stdHandler.setLevel(newLevel);
    }

    public Level getStdHandlerLevel() {
        return this.stdHandler.getLevel();
    }

    public void setLevel(Level newLevel) {
        if (newLevel == null) {
            throw new NullPointerException();
        }
        this.loggerLevel = newLevel;
    }

    public Level getLevel() {
        return this.loggerLevel;
    }

    public void info(String text) {
        this.log(Level.INFO, text);
    }

    public void warning(String text) {
        this.log(Level.WARNING, text);
    }

    public void config(String text) {
        this.log(Level.CONFIG, text);
    }

    public void severe(String text) {
        this.log(Level.SEVERE, text);
    }

    public void fine(String text) {
        this.log(Level.FINE, text);
    }

    public void finer(String text) {
        this.log(Level.FINER, text);
    }

    public void finest(String text) {
        this.log(Level.FINEST, text);
    }

    public void infoln(String text) {
        this.log(Level.INFO, text + "\n");
        this.flush();
    }

    public void warningln(String text) {
        this.log(Level.WARNING, text + "\n");
        this.flush();
    }

    public void configln(String text) {
        this.log(Level.CONFIG, text + "\n");
        this.flush();
    }

    public void severeln(String text) {
        this.log(Level.SEVERE, text + "\n");
        this.flush();
    }

    public void fineln(String text) {
        this.log(Level.FINE, text + "\n");
        this.flush();
    }

    public void finerln(String text) {
        this.log(Level.FINER, text + "\n");
        this.flush();
    }

    public void finestln(String text) {
        this.log(Level.FINEST, text + "\n");
        this.flush();
    }

    public static void info(String text, Class loggingClass) {
        ProtTestLogger.log(Level.INFO, text, loggingClass);
    }

    public static void warning(String text, Class loggingClass) {
        ProtTestLogger.log(Level.WARNING, text, loggingClass);
    }

    public static void config(String text, Class loggingClass) {
        ProtTestLogger.log(Level.CONFIG, text, loggingClass);
    }

    public static void severe(String text, Class loggingClass) {
        ProtTestLogger.log(Level.SEVERE, text, loggingClass);
    }

    public static void fine(String text, Class loggingClass) {
        ProtTestLogger.log(Level.FINE, text, loggingClass);
    }

    public static void finer(String text, Class loggingClass) {
        ProtTestLogger.log(Level.FINER, text, loggingClass);
    }

    public static void finest(String text, Class loggingClass) {
        ProtTestLogger.log(Level.FINEST, text, loggingClass);
    }

    public static void infoln(String text, Class loggingClass) {
        ProtTestLogger.log(Level.INFO, text + "\n", loggingClass);
        ProtTestLogger.flush(loggingClass);
    }

    public static void warningln(String text, Class loggingClass) {
        ProtTestLogger.log(Level.WARNING, text + "\n", loggingClass);
        ProtTestLogger.flush(loggingClass);
    }

    public static void configln(String text, Class loggingClass) {
        ProtTestLogger.log(Level.CONFIG, text + "\n", loggingClass);
        ProtTestLogger.flush(loggingClass);
    }

    public static void severeln(String text, Class loggingClass) {
        ProtTestLogger.log(Level.SEVERE, text + "\n", loggingClass);
        ProtTestLogger.flush(loggingClass);
    }

    public static void fineln(String text, Class loggingClass) {
        ProtTestLogger.log(Level.FINE, text + "\n", loggingClass);
        ProtTestLogger.flush(loggingClass);
    }

    public static void finerln(String text, Class loggingClass) {
        ProtTestLogger.log(Level.FINER, text + "\n", loggingClass);
        ProtTestLogger.flush(loggingClass);
    }

    public static void finestln(String text, Class loggingClass) {
        ProtTestLogger.log(Level.FINEST, text + "\n", loggingClass);
        ProtTestLogger.flush(loggingClass);
    }

    public static void log(Level level, String text, Class loggingClass) {
        ProtTestLogger.getDefaultLogger().log(level, text);
        if (ProtTestLogger.exists(loggingClass)) {
            ProtTestLogger.getLogger(loggingClass.getName(), false).log(level, text);
        }
    }

    public void log(Level level, String text) {
        this.log(new LogRecord(level, text));
    }

    public void log(LogRecord lr) {
        if (lr.getLevel().intValue() > this.loggerLevel.intValue() && this.loggerLevel.intValue() != Level.OFF.intValue()) {
            for (Handler handler : this.handlers) {
                handler.publish(lr);
            }
        }
    }

    public void flush() {
        for (Handler handler : this.handlers) {
            handler.flush();
        }
    }

    public static void flush(Class loggingClass) {
        ProtTestLogger.getDefaultLogger().flush();
        if (ProtTestLogger.exists(loggingClass)) {
            ProtTestLogger.getLogger(loggingClass.getName(), false).flush();
        }
    }

    static {
        ProtTestLogger defaultLogger = new ProtTestLogger(DEFAULT_LOGGER_NAME);
        loggers.put(DEFAULT_LOGGER_NAME, defaultLogger);
    }
}

