/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.fileio;

import es.uvigo.darwin.prottest.tree.WeightedTree;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.exception.TreeFormatException;
import es.uvigo.darwin.prottest.util.fileio.AlignmentReader;
import es.uvigo.darwin.prottest.util.fileio.TreeReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.util.List;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public class SimpleNewickTreeReader
extends TreeReader {
    private static final int FIRST = 0;

    public SimpleNewickTreeReader(File treeFile) throws ProtTestInternalException, IOException {
        FileReader fr = new FileReader(treeFile);
        BufferedReader br = new BufferedReader(fr);
        try {
            String line;
            while (br.ready() && (line = br.readLine()) != null && !line.equals("")) {
                line = line.replace('[', ';');
                line = line.replace(']', ';');
                String[] values = line.split(";");
                String weightStr = values[1];
                double weight = Double.parseDouble(weightStr);
                File tempFile = File.createTempFile("consensus", "tmp");
                tempFile.deleteOnExit();
                FileWriter fw = new FileWriter(tempFile);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(values[0]);
                bw.append(';');
                bw.close();
                fw.close();
                PushbackReader in = new PushbackReader(new FileReader(tempFile));
                PrintWriter out = new PrintWriter(System.out);
                Tree tree = AlignmentReader.readTree(out, in, false);
                out.flush();
                this.addTree(this.trees, new WeightedTree(tree, weight));
            }
        }
        catch (TreeFormatException tfe) {
            throw new ProtTestInternalException("Bad file format. Cannot parse tree");
        }
        catch (NumberFormatException nfe) {
            throw new ProtTestInternalException("Bad file format. Expecting double value");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean addTree(List<WeightedTree> trees, WeightedTree wTree) {
        if (wTree.getTree() == null || wTree.getWeight() < 0.0) {
            throw new ProtTestInternalException();
        }
        if (trees.size() == 0) {
            trees.add(wTree);
            this.numTaxa = wTree.getTree().getIdCount();
            this.idGroup = TreeUtils.getLeafIdGroup((Tree)wTree.getTree());
        } else {
            if (wTree.getTree().getIdCount() != this.numTaxa) {
                return false;
            }
            Tree pTree = trees.get(0).getTree();
            for (int i = 0; i < this.numTaxa; ++i) {
                boolean found = false;
                for (int j = 0; j < this.numTaxa; ++j) {
                    if (!wTree.getTree().getIdentifier(i).equals((Object)pTree.getIdentifier(j))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                System.out.println("NOT COMPATIBLE TREES");
                return false;
            }
            trees.add(wTree);
        }
        this.cumWeight += wTree.getWeight();
        return true;
    }
}

