/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.fileio;

import es.uvigo.darwin.prottest.tree.TreeUtils;
import es.uvigo.darwin.prottest.tree.WeightedTree;
import es.uvigo.darwin.prottest.util.exception.ImportException;
import es.uvigo.darwin.prottest.util.fileio.NexusImporter;
import es.uvigo.darwin.prottest.util.fileio.TreeReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import pal.tree.Tree;

public class NexusTreeReader
extends TreeReader {
    private NexusImporter imp;

    public String getNexusId() {
        return this.imp.getNexusId();
    }

    public NexusTreeReader(File treeFile) throws ImportException {
        try {
            FileReader fileReader = new FileReader(treeFile);
            this.imp = new NexusImporter(fileReader);
            List<Tree> importedTrees = this.imp.importTrees();
            for (Tree tree : importedTrees) {
                double weight = (Double)tree.getAttribute(tree.getRoot(), "weight");
                this.trees.add(new WeightedTree(tree, weight));
                this.cumWeight += weight;
                if (this.idGroup != null) continue;
                this.idGroup = TreeUtils.getLeafIdGroup(tree);
                this.numTaxa = this.idGroup.getIdCount();
            }
            fileReader.close();
        }
        catch (IOException ex) {
            Logger.getLogger(NexusTreeReader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) throws ImportException {
        String filename = args[0];
        File file = new File(filename);
        NexusTreeReader ntr = new NexusTreeReader(file);
    }
}

