/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.fileio;

import es.uvigo.darwin.prottest.taxa.Taxon;
import es.uvigo.darwin.prottest.util.attributable.Attributable;
import es.uvigo.darwin.prottest.util.exception.ImportException;
import es.uvigo.darwin.prottest.util.fileio.ImportHelper;
import java.awt.Color;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pal.misc.Identifier;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.tree.SimpleTree;
import pal.tree.Tree;

public class NexusImporter {
    private boolean compactTrees = false;
    private Writer commentWriter;
    private String nexusId;
    private boolean isReadingTreesBlock = false;
    private List<Taxon> treeTaxonList = null;
    private Map<String, Taxon> translationList = Collections.emptyMap();
    private Tree nextTree = null;
    private String[] lastToken = new String[1];
    private NexusBlock nextBlock = null;
    private String nextBlockName = null;
    protected final ImportHelper helper;

    public String getNexusId() {
        return this.nexusId;
    }

    public NexusImporter(Reader reader, long expectedLength) {
        this.helper = new ImportHelper(reader);
        this.helper.setExpectedInputLength(expectedLength);
        this.initHelper();
    }

    public NexusImporter(Reader reader) {
        this(reader, 0L);
    }

    public NexusImporter(Reader reader, boolean compactTrees, long expectedInputLength) {
        this(reader, expectedInputLength);
        this.compactTrees = compactTrees;
    }

    private void initHelper() {
        this.helper.setCommentDelimiters('[', ']', '\u0000', '!', '&');
        this.commentWriter = new StringWriter();
        this.helper.setCommentWriter(this.commentWriter);
    }

    public NexusBlock findNextBlock() throws IOException {
        this.findToken("BEGIN", true);
        this.nextBlockName = this.helper.readToken(";").toUpperCase();
        return this.findBlockName(this.nextBlockName);
    }

    private NexusBlock findBlockName(String blockName) {
        try {
            this.nextBlock = NexusBlock.valueOf(blockName);
        }
        catch (IllegalArgumentException e) {
            this.nextBlock = null;
        }
        if (this.nextBlock == null) {
            this.nextBlock = NexusBlock.UNKNOWN;
        }
        return this.nextBlock;
    }

    public String getNextBlockName() {
        return this.nextBlockName;
    }

    public Iterator<Tree> iterator() {
        return new Iterator<Tree>(){

            @Override
            public boolean hasNext() {
                boolean hasNext = false;
                try {
                    hasNext = NexusImporter.this.hasTree();
                }
                catch (IOException e) {
                }
                catch (ImportException importException) {
                    // empty catch block
                }
                return hasNext;
            }

            @Override
            public Tree next() {
                Tree tree = null;
                try {
                    tree = NexusImporter.this.importNextTree();
                }
                catch (IOException e) {
                }
                catch (ImportException importException) {
                    // empty catch block
                }
                if (tree == null) {
                    throw new NoSuchElementException("No more trees in this file");
                }
                return tree;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("operation is not supported by this Iterator");
            }
        };
    }

    public List<Tree> parseTreesBlock(List<Taxon> taxonList) throws ImportException, IOException {
        return this.readTreesBlock(taxonList);
    }

    public boolean hasTree() throws IOException, ImportException {
        if (!this.isReadingTreesBlock) {
            this.isReadingTreesBlock = this.startReadingTrees();
            this.translationList = this.readTranslationList(this.treeTaxonList, this.lastToken);
        }
        if (!this.isReadingTreesBlock) {
            return false;
        }
        if (this.nextTree == null) {
            this.nextTree = this.readNextTree(this.lastToken);
        }
        return this.nextTree != null;
    }

    public Tree importNextTree() throws IOException, ImportException {
        if (!this.hasTree()) {
            this.isReadingTreesBlock = false;
            return null;
        }
        Tree tree = this.nextTree;
        this.nextTree = null;
        return tree;
    }

    public List<Tree> importTrees() throws IOException, ImportException {
        this.isReadingTreesBlock = false;
        if (!this.startReadingTrees()) {
            throw new MissingBlockException("TREES block is missing");
        }
        List<Tree> treesBlock = this.readTreesBlock(this.treeTaxonList);
        this.helper.closeReader();
        this.nexusId = this.commentWriter.toString();
        this.commentWriter.close();
        return treesBlock;
    }

    public boolean startReadingTrees() throws IOException, ImportException {
        this.treeTaxonList = null;
        try {
            while (true) {
                NexusBlock block = this.findNextBlock();
                switch (block) {
                    case TREES: {
                        return true;
                    }
                }
            }
        }
        catch (EOFException ex) {
            return false;
        }
    }

    private void findToken(String query, boolean ignoreCase) throws IOException {
        boolean found = false;
        do {
            String token = this.helper.readToken();
            if ((!ignoreCase || !token.equalsIgnoreCase(query)) && !token.equals(query)) continue;
            found = true;
        } while (!found);
    }

    public void findEndBlock() throws IOException {
        try {
            String token;
            while (!(token = this.helper.readToken(";")).equalsIgnoreCase("END") && !token.equalsIgnoreCase("ENDBLOCK")) {
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.nextBlock = NexusBlock.UNKNOWN;
    }

    private List<Tree> readTreesBlock(List<Taxon> taxonList) throws ImportException, IOException {
        SimpleTree tree;
        ArrayList<Tree> trees = new ArrayList<Tree>();
        double cumWeight = 0.0;
        String[] localLastToken = new String[1];
        this.translationList = this.readTranslationList(taxonList, localLastToken);
        while ((tree = this.readNextTree(localLastToken)) != null) {
            cumWeight += ((Double)tree.getAttribute(tree.getRoot(), "weight")).doubleValue();
            trees.add((Tree)tree);
        }
        if (trees.size() == 0) {
            throw new ImportException.BadFormatException("No trees defined in TREES block");
        }
        if (cumWeight > 1.0) {
            for (Tree tree2 : trees) {
                double treeWeight = (Double)tree2.getAttribute(tree2.getRoot(), "weight");
                tree2.setAttribute(tree2.getRoot(), "weight", (Object)(treeWeight /= cumWeight));
            }
        }
        this.nextBlock = NexusBlock.UNKNOWN;
        return trees;
    }

    private Map<String, Taxon> readTranslationList(List<Taxon> taxonList, String[] lastToken) throws ImportException, IOException {
        HashMap<String, Taxon> localTranslationList = new HashMap<String, Taxon>();
        String token = this.helper.readToken(";");
        if (token.equalsIgnoreCase("TRANSLATE")) {
            do {
                String token2 = this.helper.readToken(",;");
                if (this.helper.getLastDelimiter() == 44 || this.helper.getLastDelimiter() == 59) {
                    if (token2.length() == 0 && (char)this.helper.getLastDelimiter() == ';') break;
                    throw new ImportException.BadFormatException("Missing taxon label in TRANSLATE command of TREES block");
                }
                String token3 = this.helper.readToken(",;");
                if (this.helper.getLastDelimiter() != 44 && this.helper.getLastDelimiter() != 59) {
                    throw new ImportException.BadFormatException("Expecting ',' or ';' after taxon label in TRANSLATE command of TREES block");
                }
                Taxon taxon = Taxon.getTaxon(token3);
                if (taxonList != null && !taxonList.contains(taxon)) {
                    throw new ImportException.UnknownTaxonException(token3);
                }
                localTranslationList.put(token2, taxon);
            } while (this.helper.getLastDelimiter() != 59);
            token = this.helper.readToken(";");
        } else if (taxonList != null) {
            for (Taxon taxon : taxonList) {
                localTranslationList.put(taxon.getName(), taxon);
            }
        }
        lastToken[0] = token;
        return localTranslationList;
    }

    private SimpleTree readNextTree(String[] lastToken) throws ImportException, IOException {
        try {
            SimpleTree tree = null;
            String token = lastToken[0];
            boolean isUnrooted = token.equalsIgnoreCase("UTREE");
            if (isUnrooted || token.equalsIgnoreCase("TREE")) {
                String meta;
                if (this.helper.nextCharacter() == '*') {
                    this.helper.readCharacter();
                }
                if ((meta = this.helper.getLastMetaComment()) != null) {
                    if (meta.equalsIgnoreCase("U")) {
                        isUnrooted = true;
                    }
                    this.helper.clearLastMetaComment();
                }
                String treeName = this.helper.readToken("=;");
                if (this.helper.getLastDelimiter() != 61) {
                    throw new ImportException.BadFormatException("Missing label for tree'" + treeName + "' or missing '=' in TREE command of TREES block");
                }
                try {
                    if (this.helper.nextCharacter() != '(') {
                        throw new ImportException.BadFormatException("Missing tree definition in TREE command of TREES block");
                    }
                    String comment = this.helper.getLastMetaComment();
                    this.helper.clearLastMetaComment();
                    Node internalNode = this.readInternalNode();
                    tree = new SimpleTree(internalNode);
                    int last = this.helper.getLastDelimiter();
                    if (last == 58) {
                        this.helper.readDouble(";");
                        last = this.helper.getLastDelimiter();
                    }
                    if (last != 59) {
                        throw new ImportException.BadFormatException("Expecting ';' after tree, '" + treeName + "', TREE command of TREES block");
                    }
                    double weight = 1.0;
                    if (comment != null && comment.matches("^W\\s+[\\+\\-]?[\\d\\.]+")) {
                        weight = new Double(comment.substring(2));
                    }
                    tree.setAttribute(internalNode, "weight", (Object)weight);
                    tree.setAttribute(internalNode, "treeName", (Object)treeName);
                }
                catch (EOFException e) {
                    return tree;
                }
            } else {
                if (token.equalsIgnoreCase("ENDBLOCK") || token.equalsIgnoreCase("END")) {
                    return null;
                }
                throw new ImportException.BadFormatException("Unknown command '" + token + "' in TREES block");
            }
            token = this.helper.readToken(";");
            lastToken[0] = token;
            return tree;
        }
        catch (EOFException e) {
            return null;
        }
    }

    private Node readBranch() throws IOException, ImportException {
        this.helper.clearLastMetaComment();
        Node branch = this.helper.nextCharacter() == '(' ? this.readInternalNode() : this.readExternalNode();
        if (this.helper.getLastDelimiter() == 58) {
            double length = this.helper.readDouble(",():;");
            branch.setBranchLength(length);
        }
        return branch;
    }

    private Node readInternalNode() throws IOException, ImportException {
        ArrayList<Node> children = new ArrayList<Node>();
        this.helper.readCharacter();
        children.add(this.readBranch());
        if (this.helper.getLastDelimiter() != 44) {
            // empty if block
        }
        while (this.helper.getLastDelimiter() == 44) {
            children.add(this.readBranch());
        }
        if (this.helper.getLastDelimiter() != 41) {
            throw new ImportException.BadFormatException("Missing closing ')' in tree");
        }
        Node node = NodeFactory.createNode((Node[])children.toArray(new Node[0]));
        String token = this.helper.readToken(":(),;").trim();
        if (token.length() > 0) {
            node.setIdentifier(new Identifier((String)NexusImporter.parseValue(token)));
        }
        return node;
    }

    private Node readExternalNode() throws ImportException, IOException {
        Taxon taxon;
        String label = this.helper.readToken(":(),;");
        try {
            taxon = Taxon.getTaxon(label);
        }
        catch (IllegalArgumentException e) {
            throw new ImportException.UnknownTaxonException(e.getMessage());
        }
        if (this.translationList.size() > 0 && (taxon = this.translationList.get(label)) == null) {
            throw new ImportException.UnknownTaxonException("Taxon in tree, '" + label + "' is unknown");
        }
        try {
            Node node = NodeFactory.createNode((Identifier)new Identifier(taxon.getName()));
            return node;
        }
        catch (IllegalArgumentException e) {
            throw new ImportException.DuplicateTaxaException(e.getMessage());
        }
    }

    static void parseMetaCommentPairs(String meta, Attributable item) throws ImportException.BadFormatException {
        Pattern pattern = Pattern.compile("(\"[^\"]*\"+|[^,=\\s]+)\\s*(=\\s*(\\{[^=}]*\\}|\"[^\"]*\"+|[^,]+))?");
        Matcher matcher = pattern.matcher(meta);
        while (matcher.find()) {
            String label = matcher.group(1);
            if (label.charAt(0) == '\"') {
                label = label.substring(1, label.length() - 1);
            }
            if (label == null || label.trim().length() == 0) {
                throw new ImportException.BadFormatException("Badly formatted attribute: '" + matcher.group() + "'");
            }
            String value = matcher.group(2);
            if (value != null && value.trim().length() > 0) {
                item.setAttribute(label, NexusImporter.parseValue(value.substring(1)));
                continue;
            }
            item.setAttribute(label, Boolean.TRUE);
        }
    }

    static Object parseValue(String value) {
        if ((value = value.trim()).startsWith("{")) {
            String[] elements = value.substring(1, value.length() - 1).split(",");
            Object[] values = new Object[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                values[i] = NexusImporter.parseValue(elements[i]);
            }
            return values;
        }
        if (value.startsWith("#")) {
            try {
                return Color.decode(value.substring(1));
            }
            catch (NumberFormatException nfe1) {
                // empty catch block
            }
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.subSequence(1, value.length() - 1);
        }
        if (value.equalsIgnoreCase("TRUE") || value.equalsIgnoreCase("FALSE")) {
            return Boolean.valueOf(value);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe1) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                return value;
            }
        }
    }

    public static class MissingBlockException
    extends ImportException {
        public MissingBlockException() {
        }

        public MissingBlockException(String message) {
            super(message);
        }
    }

    public static enum NexusBlock {
        UNKNOWN,
        TAXA,
        CHARACTERS,
        DATA,
        UNALIGNED,
        DISTANCES,
        TREES;

    }
}

