/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.fileio;

import es.uvigo.darwin.prottest.tree.TreeUtils;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import pal.tree.Tree;

public class NexusExporter {
    private static final String HEADER = "#NEXUS";
    private File outFile;
    private PrintWriter outputWriter;

    public NexusExporter(File outFile) throws IOException {
        this.outFile = outFile;
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        this.outputWriter = new PrintWriter(outFile);
        this.initStructure(this.outputWriter);
    }

    public void printTreeBlock(List<Tree> trees) {
        NexusBlock treeBlock = NexusBlock.TREES;
        treeBlock.beginSection(this.outputWriter);
        treeBlock.export(this.outputWriter, trees, new Properties());
        treeBlock.endSection(this.outputWriter);
    }

    public void printConsensusBlock(Tree tree, String id) {
        NexusBlock treeBlock = NexusBlock.CONSENSUS;
        ArrayList<Tree> trees = new ArrayList<Tree>();
        trees.add(tree);
        if (id != null) {
            treeBlock.addComment(this.outputWriter, id, 0);
        }
        treeBlock.beginSection(this.outputWriter);
        treeBlock.export(this.outputWriter, trees, new Properties());
        treeBlock.endSection(this.outputWriter);
    }

    public void printComment(String msg, int colWidth) {
        NexusBlock.DEFAULT.addComment(this.outputWriter, msg, colWidth);
    }

    public void close() {
        this.outputWriter.close();
    }

    private void initStructure(PrintWriter outputWriter) {
        outputWriter.println(HEADER);
        outputWriter.println(" ");
    }

    private static enum NexusBlock {
        TAXA{

            @Override
            public void beginSection(PrintWriter outputWriter) {
                outputWriter.println("begin taxa;");
            }

            @Override
            public void endSection(PrintWriter outputWriter) {
                outputWriter.println("end taxa;");
            }

            public String getSectionName() {
                return "taxa";
            }

            @Override
            public void export(PrintWriter outputWriter, List taxa, Properties properties) {
            }
        }
        ,
        TREES{

            @Override
            public void beginSection(PrintWriter outputWriter) {
                outputWriter.println("begin trees;");
            }

            @Override
            public void endSection(PrintWriter outputWriter) {
                outputWriter.println("end trees;");
            }

            public String getSectionName() {
                return "trees";
            }

            @Override
            public void export(PrintWriter outputWriter, List trees, Properties properties) {
                this.printBlankLine(outputWriter);
                for (Object o : trees) {
                    if (!(o instanceof Tree)) {
                        throw new TypeMismatchException(Tree.class, o.getClass());
                    }
                    Tree tree = (Tree)o;
                    boolean printCladeSupport = properties.getProperty(NexusBlock.PRINT_CLADE_SUPPORT, "false").equalsIgnoreCase("true");
                    String treeName = (String)tree.getAttribute(tree.getRoot(), "treeName");
                    String treeNewick = TreeUtils.toNewick(tree, true, true, printCladeSupport);
                    outputWriter.print("    " + treeName + " = ");
                    outputWriter.println(treeNewick);
                }
                this.printBlankLine(outputWriter);
            }
        }
        ,
        CONSENSUS{

            @Override
            public void beginSection(PrintWriter outputWriter) {
                TREES.beginSection(outputWriter);
            }

            @Override
            public void endSection(PrintWriter outputWriter) {
                TREES.endSection(outputWriter);
            }

            @Override
            public void export(PrintWriter outputWriter, List trees, Properties properties) {
                this.printBlankLine(outputWriter);
                String fullTreeComment = "Note: This tree contains information on the topology, branch lengths (if present), and the probability  of the partition indicated by the branch.";
                this.addComment(outputWriter, fullTreeComment, 0);
                properties.setProperty(NexusBlock.PRINT_CLADE_SUPPORT, "true");
                TREES.export(outputWriter, trees, properties);
                String simpleTreeComment = "Note: This tree contains information only on the topology and branch lengths (mean of the posterior probability density).";
                this.addComment(outputWriter, simpleTreeComment, 0);
                properties.setProperty(NexusBlock.PRINT_CLADE_SUPPORT, "false");
                TREES.export(outputWriter, trees, properties);
                this.printBlankLine(outputWriter);
            }
        }
        ,
        DEFAULT{

            @Override
            public void beginSection(PrintWriter outputWriter) {
                throw new UndefinedBlockException();
            }

            @Override
            public void endSection(PrintWriter outputWriter) {
                throw new UndefinedBlockException();
            }

            @Override
            public void export(PrintWriter outputWriter, List objects, Properties properties) {
                throw new UndefinedBlockException();
            }
        };

        public static final String PRINT_CLADE_SUPPORT = "pcs";

        public void addComment(PrintWriter outputWriter, String comment, int lineWidth) {
            int toWriteLength;
            comment = "[" + comment + "] ";
            int commentLength = comment.length();
            if (lineWidth <= 0) {
                lineWidth = comment.length();
            }
            for (int column = 0; column < commentLength; column += toWriteLength) {
                String toWrite = column + lineWidth + 1 < comment.length() ? comment.substring(column, column + lineWidth + 1) : comment.substring(column);
                toWriteLength = toWrite.lastIndexOf(" ");
                if (toWriteLength > 0 && toWriteLength < toWrite.length()) {
                    outputWriter.println(toWrite.substring(0, toWriteLength));
                    continue;
                }
                toWriteLength = lineWidth;
                outputWriter.println(toWrite);
            }
        }

        public void printBlankLine(PrintWriter outputWriter) {
            outputWriter.println(" ");
        }

        public abstract void beginSection(PrintWriter var1);

        public abstract void endSection(PrintWriter var1);

        public abstract void export(PrintWriter var1, List var2, Properties var3);

        private static class UndefinedBlockException
        extends ProtTestInternalException {
            public UndefinedBlockException() {
                super("No Nexus block is defined");
            }
        }

        private static class TypeMismatchException
        extends ProtTestInternalException {
            public TypeMismatchException(Class classRequired, Class classObtained) {
                super("Required class " + classRequired + " but obtained " + classObtained);
            }
        }
    }
}

