/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.fileio;

import es.uvigo.darwin.prottest.util.exception.ImportException;
import java.io.EOFException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;

public class ImportHelper {
    private long totalCharactersRead = 0L;
    private long expectedInputLength = 0L;
    private LineNumberReader reader;
    private Writer commentWriter = null;
    private int lastChar = 0;
    private int lastDelimiter = 0;
    private boolean hasComments = false;
    private char startComment = (char)65535;
    private char stopComment = (char)65535;
    private char lineComment = (char)65535;
    private char writeComment = (char)65535;
    private char metaComment = (char)65535;
    private StringBuffer lastComment;
    private String lastMetaComment = null;

    public ImportHelper(Reader reader) {
        this.reader = new LineNumberReader(reader);
        this.commentWriter = null;
    }

    public void setExpectedInputLength(long l) {
        this.expectedInputLength = l;
    }

    public ImportHelper(Reader reader, Writer commentWriter) {
        this.reader = new LineNumberReader(reader);
        this.commentWriter = commentWriter;
    }

    public double getProgress() {
        if (this.expectedInputLength == 0L) {
            return 0.0;
        }
        return (double)this.totalCharactersRead / (double)this.expectedInputLength;
    }

    public void closeReader() throws IOException {
        this.reader.close();
    }

    public void setCommentDelimiters(char line) {
        this.hasComments = true;
        this.lineComment = line;
    }

    public void setCommentDelimiters(char start, char stop) {
        this.hasComments = true;
        this.startComment = start;
        this.stopComment = stop;
    }

    public void setCommentDelimiters(char start, char stop, char line) {
        this.hasComments = true;
        this.startComment = start;
        this.stopComment = stop;
        this.lineComment = line;
    }

    public void setCommentDelimiters(char start, char stop, char line, char write, char meta) {
        this.hasComments = true;
        this.startComment = start;
        this.stopComment = stop;
        this.lineComment = line;
        this.writeComment = write;
        this.metaComment = meta;
    }

    public void setCommentWriter(Writer commentWriter) {
        this.commentWriter = commentWriter;
    }

    public int getLineNumber() {
        return this.reader.getLineNumber();
    }

    public int getLastDelimiter() {
        return this.lastDelimiter;
    }

    public char nextCharacter() throws IOException {
        if (this.lastChar == 0) {
            this.lastChar = this.readCharacter();
        }
        return (char)this.lastChar;
    }

    public char readCharacter() throws IOException {
        this.skipSpace();
        char ch = this.read();
        while (this.hasComments && (ch == this.startComment || ch == this.lineComment)) {
            this.skipComments(ch);
            this.skipSpace();
            ch = this.read();
        }
        return ch;
    }

    public void unreadCharacter(char ch) {
        this.lastChar = ch;
    }

    public char next() throws IOException {
        if (this.lastChar == 0) {
            this.lastChar = this.read();
        }
        return (char)this.lastChar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char read() throws IOException {
        int ch;
        if (this.lastChar == 0) {
            ch = this.reader.read();
            if (ch == -1) throw new EOFException();
            ++this.totalCharactersRead;
            return (char)ch;
        } else {
            ch = this.lastChar;
            this.lastChar = 0;
        }
        return (char)ch;
    }

    public String readLine() throws IOException {
        StringBuffer line = new StringBuffer();
        char ch = this.read();
        try {
            while (ch != '\n' && ch != '\r') {
                if (this.hasComments) {
                    if (ch == this.lineComment) {
                        this.skipComments(ch);
                        break;
                    }
                    if (ch == this.startComment) {
                        this.skipComments(ch);
                        ch = this.read();
                    }
                }
                line.append(ch);
                ch = this.read();
            }
            if (ch == '\r' && this.next() == '\n') {
                this.read();
            }
            this.lastDelimiter = ch;
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return line.toString();
    }

    public int readInteger() throws IOException, ImportException {
        String token = this.readToken();
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Number format error: " + nfe.getMessage());
        }
    }

    public int readInteger(String delimiters) throws IOException, ImportException {
        String token = this.readToken(delimiters);
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Number format error: " + nfe.getMessage());
        }
    }

    public double readDouble() throws IOException, ImportException {
        String token = this.readToken();
        try {
            return Double.parseDouble(token);
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Number format error: " + nfe.getMessage());
        }
    }

    public double readDouble(String delimiters) throws IOException, ImportException {
        String token = this.readToken(delimiters);
        try {
            return Double.parseDouble(token);
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Number format error: " + nfe.getMessage());
        }
    }

    public String readToken() throws IOException {
        return this.readToken("");
    }

    public String readToken(String delimiters) throws IOException {
        char ch;
        boolean space = false;
        char quoteChar = '\u0000';
        boolean done = false;
        boolean first = true;
        boolean quoted = false;
        this.nextCharacter();
        StringBuffer token = new StringBuffer();
        while (!done) {
            ch = this.read();
            try {
                boolean isSpace = Character.isWhitespace(ch);
                if (quoted && ch == quoteChar) {
                    char ch2 = this.read();
                    if (ch == ch2) {
                        token.append(ch);
                        continue;
                    }
                    this.lastDelimiter = 32;
                    if (this.hasComments && (ch2 == this.startComment || ch2 == this.lineComment)) {
                        this.skipComments(ch2, this.startComment != '\"' && this.startComment != '\'');
                    } else {
                        this.unreadCharacter(ch2);
                    }
                    done = true;
                    quoted = false;
                    continue;
                }
                if (first && (ch == '\'' || ch == '\"')) {
                    quoted = true;
                    quoteChar = ch;
                    first = false;
                    space = false;
                    continue;
                }
                if (!(quoted || ch != this.startComment && ch != this.lineComment)) {
                    this.skipComments(ch, this.startComment != '\"' && this.startComment != '\'');
                    this.lastDelimiter = 32;
                    done = true;
                    continue;
                }
                if (quoted) {
                    token.append(ch);
                    continue;
                }
                if (isSpace) {
                    this.lastDelimiter = 32;
                    done = true;
                    continue;
                }
                if (delimiters.indexOf(ch) != -1) {
                    done = true;
                    this.lastDelimiter = ch;
                    continue;
                }
                token.append(ch);
                first = false;
            }
            catch (EOFException e) {
                done = true;
            }
        }
        if (Character.isWhitespace((char)this.lastDelimiter)) {
            ch = this.nextCharacter();
            while (Character.isWhitespace(ch)) {
                this.read();
                ch = this.nextCharacter();
            }
            if (delimiters.indexOf(ch) != -1) {
                this.lastDelimiter = this.readCharacter();
            }
        }
        return token.toString();
    }

    protected void skipComments(char delimiter) throws IOException {
        this.skipComments(delimiter, false);
    }

    protected void skipComments(char delimiter, boolean gobbleStrings) throws IOException {
        int n = 1;
        boolean write = true;
        StringBuffer meta = null;
        if (this.lastComment == null) {
            this.lastComment = new StringBuffer();
        }
        if (this.nextCharacter() == this.writeComment) {
            this.read();
        } else if (this.nextCharacter() == this.metaComment) {
            this.read();
            meta = new StringBuffer();
            write = false;
        }
        this.lastMetaComment = null;
        if (delimiter == this.lineComment) {
            String line = this.readLine();
            if (write && this.commentWriter != null) {
                this.commentWriter.write(line, 0, line.length());
                this.commentWriter.write(10);
            } else if (meta != null) {
                meta.append(line);
            }
        } else {
            Character inString = null;
            do {
                char ch;
                if (((ch = this.read()) == '\"' || ch == '\'') && gobbleStrings) {
                    if (inString == null) {
                        inString = Character.valueOf(ch);
                    } else if (inString.charValue() == ch) {
                        inString = null;
                    }
                }
                if (inString == null) {
                    if (ch == this.startComment) {
                        this.lastComment = new StringBuffer();
                        ++n;
                        continue;
                    }
                    if (ch == this.stopComment) {
                        if (write && this.commentWriter != null) {
                            if (this.lastComment.toString().contains("ID")) {
                                this.commentWriter.write(this.lastComment.toString());
                            }
                            this.lastComment = new StringBuffer();
                        }
                        --n;
                        continue;
                    }
                }
                if (write && this.commentWriter != null) {
                    this.lastComment.append(ch);
                    continue;
                }
                if (meta == null) continue;
                meta.append(ch);
            } while (n > 0);
        }
        if (meta != null) {
            this.lastMetaComment = meta.toString();
        }
    }

    public void skipToEndOfLine() throws IOException {
        char ch;
        do {
            ch = this.read();
            if (!this.hasComments) continue;
            if (ch == this.lineComment) {
                this.skipComments(ch);
                break;
            }
            if (ch != this.startComment) continue;
            this.skipComments(ch);
            ch = this.read();
        } while (ch != '\n' && ch != '\r');
        if (ch == '\r' && this.nextCharacter() == '\n') {
            this.read();
        }
    }

    public void skipWhile(String skip) throws IOException {
        char ch;
        while (skip.indexOf(ch = this.read()) > -1) {
        }
        this.unreadCharacter(ch);
    }

    public void skipSpace() throws IOException {
        this.skipWhile(" \t\r\n");
    }

    public void skipCharacters(String skip) throws IOException {
        this.skipWhile(skip + " \t\r\n");
    }

    public char skipUntil(String skip) throws IOException {
        char ch;
        while (skip.indexOf(ch = this.readCharacter()) == -1) {
        }
        return ch;
    }

    public String getLastMetaComment() {
        return this.lastMetaComment;
    }

    public void clearLastMetaComment() {
        this.lastMetaComment = null;
    }

    static String safeName(String name) {
        if (!name.matches("[a-zA-Z0-9_.]+")) {
            name = "\"" + name + "\"";
        }
        return name;
    }

    static String convertControlsChars(String token) {
        if (!token.matches("[^\\p{Cntrl}]+")) {
            StringBuilder b = new StringBuilder();
            for (char c : token.toCharArray()) {
                if (c < ' ' || c >= '\u00fe') {
                    b.append("#").append(Integer.toHexString(c));
                    continue;
                }
                b.append(c);
            }
            return b.toString();
        }
        return token;
    }
}

