/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.fileio;

import converter.Converter;
import converter.DefaultFactory;
import es.uvigo.darwin.prottest.util.exception.TreeFormatException;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogger;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import pal.alignment.Alignment;
import pal.alignment.AlignmentParseException;
import pal.alignment.ReadAlignment;
import pal.tree.ReadTree;
import pal.tree.Tree;
import pal.tree.TreeParseException;
import parser.ParseException;

public class AlignmentReader {
    public static Alignment readAlignment(PrintWriter output, String filename, boolean debug) throws es.uvigo.darwin.prottest.util.exception.AlignmentParseException, FileNotFoundException, IOException {
        String s;
        StringBuilder text = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        while ((s = br.readLine()) != null) {
            text.append(s).append("\r\n");
        }
        br.close();
        String in = text.toString();
        String inO = "";
        String inP = "";
        String inF = "";
        boolean autodetect = true;
        boolean collapse = false;
        boolean gaps = false;
        boolean missing = false;
        int limit = 0;
        String out = "";
        String outO = "Linux";
        String os = System.getProperty("os.name");
        if (os.startsWith("Mac")) {
            outO = "MacOS";
        } else if (os.startsWith("Linux")) {
            outO = "Linux";
        } else if (os.startsWith("Win")) {
            outO = "Windows";
        }
        String outP = "ProtTest";
        String outF = "PHYLIP";
        boolean lower = false;
        boolean numbers = false;
        boolean sequential = true;
        boolean match = false;
        DefaultFactory factory = new DefaultFactory();
        Logger logger = Logger.getLogger("alter" + System.currentTimeMillis());
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.ALL);
        for (Handler handler : ProtTestLogger.getDefaultLogger().getHandlers()) {
            logger.addHandler(handler);
        }
        try {
            Converter converter = factory.getConverter(inO, inP, inF, autodetect, collapse, gaps, missing, limit, outO, outP, outF, lower, numbers, sequential, match, logger.getName());
            out = converter.convert(in);
        }
        catch (UnsupportedOperationException ex) {
            throw new es.uvigo.darwin.prottest.util.exception.AlignmentParseException("There's some error in your data: " + ex.getMessage());
        }
        catch (ParseException ex) {
            throw new es.uvigo.darwin.prottest.util.exception.AlignmentParseException("There's some error in your data: " + ex.getMessage());
        }
        PushbackReader pr = new PushbackReader(new StringReader(out));
        Alignment alignment = AlignmentReader.readAlignment(output, pr, debug);
        if (alignment == null) {
            throw new es.uvigo.darwin.prottest.util.exception.AlignmentParseException("There's some error in your data, exiting...");
        }
        return alignment;
    }

    public static Alignment readAlignment(PrintWriter out, PushbackReader pr, boolean debug) throws es.uvigo.darwin.prottest.util.exception.AlignmentParseException, IOException {
        int i;
        if (debug) {
            out.println("");
            out.println("**********************************************************");
            out.println("  Reading alignment...");
        }
        ReadAlignment alignment = null;
        try {
            alignment = new ReadAlignment(pr);
        }
        catch (AlignmentParseException e) {
            throw new es.uvigo.darwin.prottest.util.exception.AlignmentParseException(e.getMessage());
        }
        ArrayList<String> seqNames = new ArrayList<String>(alignment.getSequenceCount());
        for (int i2 = 0; i2 < alignment.getSequenceCount(); ++i2) {
            seqNames.add(alignment.getIdentifier(i2).getName());
        }
        int size = alignment.getSequenceCount();
        for (i = 0; i < size; ++i) {
            String currString = (String)seqNames.get(i);
            for (int j = i + 1; j < size; ++j) {
                if (!((String)seqNames.get(j)).equals(currString)) continue;
                throw new es.uvigo.darwin.prottest.util.exception.AlignmentParseException("ERROR: There are duplicated taxa names in the alignment: " + currString);
            }
        }
        if (debug) {
            for (i = 0; i < alignment.getSequenceCount(); ++i) {
                out.println("    Sequence #" + (i + 1) + ": " + alignment.getIdentifier(i).getName());
            }
            out.println("   Alignment contains " + alignment.getSequenceCount() + " sequences of length " + alignment.getSiteCount());
            out.println("");
            out.println("**********************************************************");
            out.println("");
        }
        return alignment;
    }

    public static Tree readTree(PrintWriter out, String filename, boolean debug) throws TreeFormatException, FileNotFoundException, IOException {
        ReadTree tree;
        if (debug) {
            out.println("Reading tree...");
        }
        try {
            tree = new ReadTree(filename);
        }
        catch (TreeParseException e) {
            throw new TreeFormatException("Error: Wrong tree format : " + e.getMessage());
        }
        if (debug) {
            out.println("Tree contains " + tree.getExternalNodeCount() + " external nodes");
            out.println("");
        }
        return tree;
    }

    public static Tree readTree(PrintWriter out, PushbackReader in, boolean debug) throws TreeFormatException {
        ReadTree tree;
        if (debug) {
            out.println("Reading tree...");
        }
        try {
            tree = new ReadTree(in);
        }
        catch (TreeParseException e) {
            throw new TreeFormatException("Error: Wrong tree format : " + e.getMessage());
        }
        if (debug) {
            out.println("Tree contains " + tree.getExternalNodeCount() + " external nodes");
            out.println("");
        }
        return tree;
    }
}

