/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.factory;

import es.uvigo.darwin.prottest.exe.AminoAcidRunEstimator;
import es.uvigo.darwin.prottest.exe.PhyMLv3AminoAcidRunEstimator;
import es.uvigo.darwin.prottest.exe.RaxMLAminoAcidRunEstimator;
import es.uvigo.darwin.prottest.exe.RunEstimator;
import es.uvigo.darwin.prottest.global.AminoAcidApplicationGlobals;
import es.uvigo.darwin.prottest.global.ApplicationGlobals;
import es.uvigo.darwin.prottest.global.RaxmlAminoAcidApplicationGlobals;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.AminoAcidModel;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.selection.printer.AminoAcidPrintFramework;
import es.uvigo.darwin.prottest.selection.printer.PrintFramework;
import es.uvigo.darwin.prottest.util.argumentparser.AminoAcidArgumentParser;
import es.uvigo.darwin.prottest.util.argumentparser.ProtTestArgumentParser;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogFormatter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.StreamHandler;
import pal.alignment.Alignment;
import pal.tree.Tree;

public class ProtTestFactory {
    public static final int PROTEIC = 1;
    public static final int NUCLEIC = 2;
    private static final int MAX_SORT = 2;
    private static ProtTestFactory instance;
    private int sort;
    private Handler logHandler;

    private ProtTestFactory(int sort) throws IllegalArgumentException {
        if (sort <= 0 || sort > 2) {
            throw new IllegalArgumentException("Cannot create factory (unexistent sort : " + sort + ")");
        }
        this.sort = sort;
    }

    public static String[] initialize(String[] args) {
        if (instance == null) {
            int sort;
            ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
            int index = argList.indexOf("-d");
            if (index < 0) {
                sort = 1;
            } else {
                String value = (String)argList.get(index + 1);
                argList.remove(index + 1);
                argList.remove(index);
                args = argList.toArray(new String[0]);
                if (value.equals("aa")) {
                    sort = 1;
                } else if (value.equals("nt")) {
                    sort = 2;
                } else {
                    throw new IllegalArgumentException("Invalid data type " + value);
                }
            }
            instance = new ProtTestFactory(sort);
            return args;
        }
        throw new ProtTestInternalException("ModelTestFactory was already initialized");
    }

    public static ProtTestFactory getInstance() {
        if (instance == null) {
            ProtTestFactory.initialize(new String[0]);
        }
        return instance;
    }

    public ProtTestArgumentParser createProtTestArgumentParser(String[] args, ApplicationOptions options) {
        AminoAcidArgumentParser mtap = null;
        switch (this.sort) {
            case 1: {
                mtap = new AminoAcidArgumentParser(args, options);
                break;
            }
            case 2: {
                throw new ProtTestInternalException("Unsupported operation: nucleic data");
            }
        }
        return mtap;
    }

    public ApplicationGlobals getApplicationGlobals() {
        AminoAcidApplicationGlobals ap = null;
        String analyzer = ApplicationGlobals.APPLICATION_PROPERTIES.getProperty("analyzer");
        switch (this.sort) {
            case 1: {
                if (analyzer.equals("raxml")) {
                    ap = new RaxmlAminoAcidApplicationGlobals();
                    break;
                }
                if (analyzer.equals("phyml")) {
                    ap = new AminoAcidApplicationGlobals();
                    break;
                }
                throw new ProtTestInternalException("Analyzer " + analyzer + " not supported by RunEstimator. Check your prottest.properties file");
            }
            case 2: {
                throw new ProtTestInternalException("Unsupported operation: nucleic data");
            }
        }
        return ap;
    }

    public Model createModel(String matrix, int distribution, Properties modelProperties, Alignment alignment, Tree tree, int ncat) {
        AminoAcidModel model = null;
        boolean plusF = modelProperties != null ? Boolean.parseBoolean(modelProperties.getProperty("plusF", "false")) : false;
        switch (this.sort) {
            case 1: {
                model = new AminoAcidModel(matrix, distribution, plusF, alignment, tree, ncat);
                break;
            }
            case 2: {
                throw new ProtTestInternalException("Unsupported operation: nucleic data");
            }
        }
        return model;
    }

    public RunEstimator createRunEstimator(ApplicationOptions options, Model model) {
        return this.createRunEstimator(options, model, 1);
    }

    public RunEstimator createRunEstimator(ApplicationOptions options, Model model, int numberOfThreads) {
        AminoAcidRunEstimator runEstimator = null;
        String analyzer = ApplicationGlobals.APPLICATION_PROPERTIES.getProperty("analyzer");
        if (analyzer.equals("phyml")) {
            switch (this.sort) {
                case 1: {
                    runEstimator = new PhyMLv3AminoAcidRunEstimator(options, model, numberOfThreads);
                    break;
                }
                case 2: {
                    throw new ProtTestInternalException("Unsupported operation: nucleic data");
                }
            }
        } else if (analyzer.equals("raxml")) {
            switch (this.sort) {
                case 1: {
                    runEstimator = new RaxMLAminoAcidRunEstimator(options, model);
                    break;
                }
                case 2: {
                    throw new ProtTestInternalException("Unsupported operation: nucleic data");
                }
            }
        } else {
            throw new ProtTestInternalException("Analyzer " + analyzer + " not supported by RunEstimator");
        }
        return runEstimator;
    }

    public Handler createLogHandler() throws IOException {
        if (this.logHandler == null) {
            String[] supportedLevels = new String[]{"INFO", "FINE", "FINER", "FINEST"};
            String logDirName = ApplicationGlobals.APPLICATION_PROPERTIES.getProperty("log_dir");
            String level = ApplicationGlobals.APPLICATION_PROPERTIES.getProperty("log_level", "info").toUpperCase();
            boolean supported = false;
            for (String testLevel : supportedLevels) {
                supported |= testLevel.equals(level);
            }
            if (logDirName != null && supported) {
                File logDir = new File(logDirName);
                if (!logDir.exists()) {
                    logDir.mkdirs();
                }
                File logFile = File.createTempFile("prottest3_", ".log", logDir);
                FileOutputStream fos = new FileOutputStream(logFile);
                this.logHandler = new StreamHandler(fos, new ProtTestLogFormatter());
                this.logHandler.setLevel(Level.parse(level));
            }
        }
        return this.logHandler;
    }

    public PrintFramework createPrintFramework() {
        AminoAcidPrintFramework pf = null;
        switch (this.sort) {
            case 1: {
                pf = new AminoAcidPrintFramework();
                break;
            }
            case 2: {
                throw new ProtTestInternalException("Unsupported operation: nucleic data");
            }
        }
        return pf;
    }
}

