/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.exception;

import es.uvigo.darwin.prottest.util.exception.ProtTestCheckedException;

public class ModelOptimizationException
extends ProtTestCheckedException {
    private static final long serialVersionUID = 20090728L;

    public ModelOptimizationException() {
        super("Model optimization exception");
    }

    public ModelOptimizationException(String description) {
        super("Model optimization exception: " + description);
    }

    public static class PhyMLExecutionException
    extends ExternalExecutionException {
        private static final String applicationName = "PhyML";

        public PhyMLExecutionException() {
            super(applicationName);
        }

        public PhyMLExecutionException(String message) {
            super(applicationName, message);
        }
    }

    public static class ModelNotFoundException
    extends ExternalExecutionException {
        private static final long serialVersionUID = 20090728L;

        public ModelNotFoundException(String model) {
            super("cannot find " + model + " matrix description");
        }

        public ModelNotFoundException(String model, String description) {
            super("cannot find " + model + " matrix description: " + description);
        }
    }

    public static class StatsFileFormatException
    extends ExternalExecutionException {
        private static final long serialVersionUID = 20090728L;

        public StatsFileFormatException(String application) {
            super("there was an error parsing " + application + " stats file");
        }

        public StatsFileFormatException(String application, String description) {
            super("there was an error parsing " + application + " stats file: " + description);
        }
    }

    public static class OSNotSupportedException
    extends ExternalExecutionException {
        public OSNotSupportedException(String application) {
            super(application, "this operating system (" + System.getProperty("os.name") + ") is not supported.");
        }
    }

    public static class ExternalExecutionException
    extends ModelOptimizationException {
        public ExternalExecutionException() {
        }

        public ExternalExecutionException(String application) {
            super("there was an error while executing " + application);
        }

        public ExternalExecutionException(String application, String message) {
            super("there was an error while executing " + application + ": " + message);
        }
    }
}

