/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.collection;

import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.comparator.ModelDistributionHeuristic;
import java.util.Collections;

public class ParallelModelQueue {
    private ModelCollection sortedModelList;
    private int maxAvThreads;
    private int availableThreads;

    public ParallelModelQueue(int maxAvThreads, ModelCollection modelList) {
        this.maxAvThreads = maxAvThreads;
        this.availableThreads = maxAvThreads;
        this.sortedModelList = modelList;
        Collections.sort(this.sortedModelList, new ModelDistributionHeuristic());
    }

    public synchronized Model getNextModel() {
        if (this.availableThreads < 1) {
            return null;
        }
        Model nextModel = null;
        for (Model model : this.sortedModelList) {
            if (this.getNumberOfThreads(model) > this.availableThreads) continue;
            nextModel = model;
            break;
        }
        this.availableThreads -= this.getNumberOfThreads(nextModel);
        this.sortedModelList.remove(nextModel);
        return nextModel;
    }

    private int getNumberOfThreads(Model model) {
        int numberOfProcessors = !model.isGamma() ? 1 : (!model.isInv() ? 2 : 4);
        return Math.min(numberOfProcessors, this.maxAvThreads);
    }
}

