/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.collection;

import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import es.uvigo.darwin.prottest.util.comparator.ModelWeightComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import pal.alignment.Alignment;
import pal.tree.Tree;

public class ParallelModelCollection
extends ModelCollection {
    private static final long serialVersionUID = 20090903L;
    private List<ModelCollection> modelCollections;
    private int groups;
    private boolean validDistribution = false;
    private ModelWeightComparator comparator;

    public ParallelModelCollection(Model[] allModels, int groups, ModelWeightComparator comparator, Alignment alignment) {
        super(alignment);
        ArrayList<Model> models = new ArrayList<Model>(Arrays.asList(allModels));
        this.comparator = comparator;
        Collections.sort(models, comparator);
        this.initialize(models, groups);
    }

    public ParallelModelCollection(ModelCollection allModels, int groups, ModelWeightComparator comparator) {
        super(allModels.getAlignment());
        ArrayList<Model> models = new ArrayList<Model>(allModels);
        this.comparator = comparator;
        Collections.sort(models, comparator);
        this.initialize(models, groups);
    }

    private void initialize(List<Model> allModels, int groups) {
        this.allModels = allModels;
        this.groups = groups;
        this.modelCollections = new ArrayList<ModelCollection>();
        this.distributeModels(this.allModels, this.groups);
    }

    private void distributeModels(List<Model> allModels, int groups) {
        this.modelCollections.clear();
        for (int i = 0; i < groups; ++i) {
            this.modelCollections.add(new SingleModelCollection(this.getAlignment()));
        }
        int maxWeight = 1;
        int currentGroup = 0;
        boolean modelAdded = false;
        for (Model model : allModels) {
            modelAdded = false;
            ModelCollection minModelGroup = this.modelCollections.get(0);
            for (currentGroup = 0; currentGroup < groups; ++currentGroup) {
                ModelCollection currentModelGroup = this.modelCollections.get(currentGroup);
                if (currentModelGroup.getWeight(this.comparator) + this.comparator.getWeight(model) <= maxWeight) {
                    modelAdded = currentModelGroup.addModel(model);
                    maxWeight = currentModelGroup.getWeight(this.comparator);
                    break;
                }
                if (currentModelGroup.getWeight(this.comparator) >= minModelGroup.getWeight(this.comparator)) continue;
                minModelGroup = currentModelGroup;
            }
            if (modelAdded) continue;
            minModelGroup.addModel(model);
            maxWeight = minModelGroup.getWeight(this.comparator);
        }
        this.validDistribution = true;
    }

    public ModelCollection getModelCollection(int group) {
        if (!this.validDistribution) {
            this.distributeModels(this.allModels, this.groups);
        }
        if (group < 0 || group > this.groups) {
            return null;
        }
        return this.modelCollections.get(group);
    }

    @Override
    public void add(int index, Model element) {
        this.validDistribution = false;
        super.add(index, element);
    }

    @Override
    public boolean add(Model e) {
        this.validDistribution = false;
        return super.add(e);
    }

    @Override
    public boolean addModel(String matrix, int distribution, Properties modelProperties, Alignment alignment, Tree tree, int ncat) {
        this.validDistribution = false;
        return super.addModel(matrix, distribution, modelProperties, alignment, tree, ncat);
    }

    @Override
    public boolean addModel(Model model) {
        this.validDistribution = false;
        return super.addModel(model);
    }

    @Override
    public boolean addModelCartesian(Collection<String> matrices, Collection<Integer> distributions, Properties modelProperties, Alignment alignment, Tree tree, int ncat) {
        this.validDistribution = false;
        return super.addModelCartesian(matrices, distributions, modelProperties, alignment, tree, ncat);
    }

    @Override
    public boolean addAll(Collection<? extends Model> c) {
        this.validDistribution = false;
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Model> c) {
        this.validDistribution = false;
        return super.addAll(index, c);
    }

    @Override
    public void clear() {
        this.validDistribution = false;
        super.clear();
    }

    @Override
    public boolean remove(Object o) {
        this.validDistribution = false;
        return super.remove(o);
    }

    @Override
    public Model remove(int index) {
        this.validDistribution = false;
        return super.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.validDistribution = false;
        return super.removeAll(c);
    }

    @Override
    public Model set(int index, Model element) {
        this.validDistribution = false;
        return super.set(index, element);
    }
}

