/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.collection;

import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import es.uvigo.darwin.prottest.util.comparator.ModelWeightComparator;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.factory.ProtTestFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import pal.alignment.Alignment;
import pal.tree.Tree;

public abstract class ModelCollection
implements List<Model>,
Serializable {
    protected Alignment alignment;
    private static final long serialVersionUID = 515892620727410572L;
    protected List<Model> allModels;

    public Alignment getAlignment() {
        return this.alignment;
    }

    public ModelCollection(Alignment alignment) {
        this.alignment = alignment;
        this.allModels = new ArrayList<Model>();
    }

    public ModelCollection(Model[] models, Alignment alignment) {
        this.alignment = alignment;
        for (Model model : models) {
            this.checkAlignment(model);
        }
        this.allModels = new ArrayList<Model>();
        this.allModels.addAll(Arrays.asList(models));
    }

    public ModelCollection(ModelCollection mc) {
        this.alignment = mc.getAlignment();
        this.allModels = new ArrayList<Model>();
        this.allModels.addAll(mc);
    }

    public boolean addModel(String matrix, int distribution, Properties modelProperties, Alignment alignment, Tree tree, int ncat) {
        boolean toAdd;
        Model model = ProtTestFactory.getInstance().createModel(matrix, distribution, modelProperties, alignment, tree, ncat);
        boolean bl = toAdd = !this.allModels.contains(model);
        if (toAdd) {
            this.checkAlignment(model);
            toAdd &= this.allModels.add(model);
        }
        return toAdd;
    }

    public boolean addModel(Model model) {
        boolean toAdd;
        boolean bl = toAdd = !this.allModels.contains(model);
        if (toAdd) {
            this.checkAlignment(model);
            toAdd &= this.allModels.add(model);
        }
        return toAdd;
    }

    public boolean addModelCartesian(Collection<String> matrices, Collection<Integer> distributions, Properties modelProperties, Alignment alignment, Tree tree, int ncat) {
        boolean allDone = true;
        boolean plusF = Boolean.parseBoolean(modelProperties.getProperty("plusF", "false"));
        Properties modelPropertiesFalse = new Properties();
        Properties modelPropertiesTrue = new Properties();
        modelPropertiesFalse.setProperty("plusF", "false");
        modelPropertiesTrue.setProperty("plusF", "true");
        for (String matrix : matrices) {
            for (Integer distribution : distributions) {
                allDone &= this.addModel(matrix, distribution, modelPropertiesFalse, alignment, tree, ncat);
                if (!plusF) continue;
                allDone &= this.addModel(matrix, distribution, modelPropertiesTrue, alignment, tree, ncat);
            }
        }
        return allDone;
    }

    public int getWeight(ModelWeightComparator mwc) {
        int weight = 0;
        for (Model model : this.allModels) {
            weight += mwc.getWeight(model);
        }
        return weight;
    }

    @Override
    public int size() {
        return this.allModels.size();
    }

    @Override
    public boolean add(Model e) {
        return this.allModels.add(e);
    }

    @Override
    public void add(int index, Model element) {
        this.allModels.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends Model> c) {
        return this.allModels.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Model> c) {
        return this.allModels.addAll(index, c);
    }

    @Override
    public void clear() {
        this.allModels.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.allModels.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.allModels.containsAll(c);
    }

    @Override
    public Model get(int index) {
        return this.allModels.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.allModels.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.allModels.isEmpty();
    }

    @Override
    public Iterator<Model> iterator() {
        return this.allModels.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.allModels.lastIndexOf(o);
    }

    @Override
    public ListIterator<Model> listIterator() {
        return this.allModels.listIterator();
    }

    @Override
    public ListIterator<Model> listIterator(int index) {
        return this.allModels.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.allModels.remove(o);
    }

    @Override
    public Model remove(int index) {
        return this.allModels.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.allModels.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.allModels.retainAll(c);
    }

    @Override
    public Model set(int index, Model element) {
        return this.allModels.set(index, element);
    }

    @Override
    public List<Model> subList(int fromIndex, int toIndex) {
        return this.allModels.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.allModels.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.allModels.toArray(a);
    }

    private void checkAlignment(Model model) {
        if (this.alignment == null) {
            throw new ProtTestInternalException("Internal error: Alignment is not initialized");
        }
        if (!model.checkAlignment(this.alignment)) {
            throw new ProtTestInternalException("Different alignments among model collection");
        }
    }

    public ModelCollection clone() {
        return new SingleModelCollection(this);
    }
}

