/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.checkpoint.status;

import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.global.options.SerializableApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.checkpoint.status.ApplicationStatus;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.util.List;

public class ProtTestStatus
extends ApplicationStatus {
    private static final long serialVersionUID = 1L;
    private SerializableApplicationOptions applicationOptions;
    private Model[] models;

    public Model[] getModels() {
        return this.models;
    }

    public SerializableApplicationOptions getApplicationOptions() {
        return this.applicationOptions;
    }

    public ProtTestStatus(Model[] models, ApplicationOptions applicationOptions) {
        if (applicationOptions == null) {
            throw new ProtTestInternalException("Wrong status format");
        }
        if (models != null && models.length > 0) {
            this.checkIntegrity(models, applicationOptions);
        }
        this.models = models;
        this.applicationOptions = new SerializableApplicationOptions(applicationOptions);
    }

    private boolean checkIntegrity(Model[] models, ApplicationOptions options) {
        List<String> matrices = options.getMatrices();
        List<Integer> distributions = options.getDistributions();
        boolean plusF = options.isPlusF();
        for (Model model : models) {
            if (!(matrices.contains(model.getMatrix()) && distributions.contains(model.getDistribution()) || model.isPlusF() && !plusF || !model.checkAlignment(options.getAlignment()))) {
                return false;
            }
            if (model.checkAlignment(options.getAlignment())) continue;
            model.setAlignment(options.getAlignment());
        }
        return true;
    }

    @Override
    public boolean isCompatible(ApplicationStatus other) {
        ProtTestStatus otherStatus;
        return other instanceof ProtTestStatus && (otherStatus = (ProtTestStatus)other).getApplicationOptions().equals(this.getApplicationOptions());
    }
}

