/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.checkpoint;

import es.uvigo.darwin.prottest.global.ApplicationGlobals;
import es.uvigo.darwin.prottest.util.checkpoint.status.ApplicationStatus;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;

public class CheckPointManager {
    private ApplicationStatus lastCheckpoint;
    private File snapshotDir;
    private File snapshotFile;
    private boolean cpEnabled;
    private final String SNAPSHOT_PREFIX = "SNAPSHOT";
    private final String SNAPSHOT_SUFFIX = "snp";

    public ApplicationStatus getLastCheckpoint() {
        return this.lastCheckpoint;
    }

    public CheckPointManager() {
        String snapshotDirName = ApplicationGlobals.APPLICATION_PROPERTIES.getProperty("snapshot_dir");
        boolean bl = this.cpEnabled = snapshotDirName != null;
        if (this.cpEnabled) {
            this.snapshotDir = new File(snapshotDirName);
            if (!this.snapshotDir.exists()) {
                this.snapshotDir.mkdirs();
            }
        }
    }

    public synchronized boolean setStatus(ApplicationStatus newCheckpoint) {
        if (this.cpEnabled) {
            boolean validStatus;
            boolean bl = validStatus = this.lastCheckpoint == null || this.lastCheckpoint.isCompatible(newCheckpoint);
            if (validStatus) {
                this.lastCheckpoint = newCheckpoint;
                this.saveStatus(this.lastCheckpoint);
            } else {
                return false;
            }
        }
        return true;
    }

    private synchronized void saveStatus(ApplicationStatus checkpoint) {
        if (this.cpEnabled) {
            try {
                if (this.snapshotFile == null) {
                    this.snapshotFile = File.createTempFile("SNAPSHOT", "snp", this.snapshotDir);
                }
                if (this.snapshotFile.exists()) {
                    this.snapshotFile.delete();
                }
                this.snapshotFile.createNewFile();
                FileOutputStream fos = new FileOutputStream(this.snapshotFile);
                ObjectOutputStream out = new ObjectOutputStream(fos);
                out.writeObject(checkpoint);
                out.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadStatus(ApplicationStatus initialStatus) {
        boolean loaded = false;
        if (this.cpEnabled && this.snapshotDir != null && this.snapshotDir.exists() && this.snapshotDir.canRead()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("SNAPSHOT") && name.endsWith("snp");
                }
            };
            File[] snapshotFiles = this.snapshotDir.listFiles(filter);
            Arrays.sort(snapshotFiles, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (((File)o1).lastModified() > ((File)o2).lastModified()) {
                        return -1;
                    }
                    if (((File)o1).lastModified() < ((File)o2).lastModified()) {
                        return 1;
                    }
                    return 0;
                }
            });
            ObjectInputStream in = null;
            for (File statusFile : snapshotFiles) {
                try {
                    in = new ObjectInputStream(new FileInputStream(statusFile));
                    Object obj = null;
                    obj = in.readObject();
                    if (!(obj instanceof ApplicationStatus) || !initialStatus.isCompatible((ApplicationStatus)obj)) continue;
                    this.snapshotFile = statusFile;
                    this.lastCheckpoint = (ApplicationStatus)obj;
                    loaded = true;
                    break;
                }
                catch (EOFException ex) {
                    statusFile.delete();
                }
                catch (ClassNotFoundException ex) {
                    statusFile.delete();
                }
                catch (FileNotFoundException ex) {
                }
                catch (IOException ex) {
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return loaded;
    }

    public void done() {
        if (this.snapshotFile != null) {
            this.snapshotFile.delete();
        }
        this.lastCheckpoint = null;
    }
}

