/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util.argumentparser;

import es.uvigo.darwin.prottest.global.ApplicationGlobals;
import es.uvigo.darwin.prottest.global.ProtTestConsoleParameters;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class ProtTestArgumentParser
implements ProtTestConsoleParameters {
    protected static final HashMap<String, Boolean> valuesRequired = new HashMap();
    protected static final HashMap<String, String[]> argumentValues = new HashMap();
    protected static final HashMap<String, Map<String, String>> specialArguments = new HashMap();
    private static final Properties defaultProperties;
    public static final String ARG_TOKEN = "-";
    private Properties arguments;

    public ProtTestArgumentParser(String[] args, ApplicationOptions options) throws IllegalArgumentException {
        this.arguments = this.checkArgs(args);
        options.fillIn(this);
    }

    private Properties checkArgs(String[] args) throws IllegalArgumentException {
        Properties localArguments = new Properties(defaultProperties);
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith(ARG_TOKEN)) {
                System.err.print("Command line: ");
                for (String simpleArg : args) {
                    System.err.print(simpleArg + " ");
                }
                System.err.println(" ");
                throw new IllegalArgumentException("Arguments must start with \"-\". The ofending argument was: " + arg);
            }
            if (valuesRequired.containsKey(arg = arg.substring(ARG_TOKEN.length()))) {
                if (valuesRequired.get(arg).booleanValue()) {
                    if (i + 1 < args.length) {
                        String[] values;
                        String value = args[++i];
                        if (argumentValues.containsKey(arg) && !Arrays.asList(values = argumentValues.get(arg)).contains(value)) {
                            throw new IllegalArgumentException("Invalid argument value " + value + " for parameter " + arg);
                        }
                        if (specialArguments.containsKey(arg)) {
                            Map<String, String> mapValues = specialArguments.get(arg);
                            for (String key : mapValues.keySet()) {
                                if (!mapValues.get(key).equals("?")) continue;
                                mapValues.put(key, value);
                            }
                            this.putArgument(mapValues, localArguments);
                            continue;
                        }
                        this.putArgument(arg, value, localArguments);
                        continue;
                    }
                    IllegalArgumentException e = new IllegalArgumentException("Parameter " + arg + " requires a value");
                    throw e;
                }
                if (specialArguments.containsKey(arg)) {
                    Map<String, String> mapValues = specialArguments.get(arg);
                    this.putArgument(mapValues, localArguments);
                    continue;
                }
                this.putArgument(arg, "T", localArguments);
                continue;
            }
            throw new IllegalArgumentException("Invalid argument " + arg);
        }
        return localArguments;
    }

    public boolean exists(String arg) {
        return this.arguments.containsKey(arg);
    }

    public boolean isSet(String arg) {
        boolean isSet;
        try {
            isSet = this.arguments.get(arg).equals("T");
        }
        catch (NullPointerException npe) {
            isSet = false;
        }
        return isSet;
    }

    public String getValue(String arg) {
        return this.arguments.getProperty(arg);
    }

    private void putArgument(String key, String value, Properties arguments) {
        if (arguments.containsKey(key)) {
            System.err.println("WARNING! Repeated argument \"" + key + "\". New value is " + value);
        }
        arguments.setProperty(key, value);
    }

    private void putArgument(Map<String, String> items, Properties arguments) {
        for (String key : items.keySet()) {
            this.putArgument(key, items.get(key), arguments);
        }
    }

    public abstract List<String> getMatrices();

    static {
        valuesRequired.put("i", true);
        valuesRequired.put("o", true);
        valuesRequired.put("t", true);
        String[] sortByValues = String.valueOf(ApplicationGlobals.SORTBY_VALUES).split("");
        valuesRequired.put("sort", true);
        argumentValues.put("sort", sortByValues);
        String[] optimizationStrategies = new String[ApplicationGlobals.OPTIMIZE_VALUES.length];
        for (int index = 0; index < ApplicationGlobals.OPTIMIZE_VALUES.length; ++index) {
            optimizationStrategies[index] = String.valueOf(ApplicationGlobals.OPTIMIZE_VALUES[index]);
        }
        valuesRequired.put("S", true);
        argumentValues.put("S", optimizationStrategies);
        String[] sampleSizeModes = new String[]{String.valueOf(0), String.valueOf(1), String.valueOf(2), String.valueOf(3), String.valueOf(4), String.valueOf(5)};
        valuesRequired.put("threads", true);
        valuesRequired.put("sample", true);
        argumentValues.put("sample", sampleSizeModes);
        valuesRequired.put("size", true);
        valuesRequired.put("all", false);
        valuesRequired.put("t1", false);
        valuesRequired.put("t2", false);
        valuesRequired.put("tc", true);
        valuesRequired.put("F", false);
        valuesRequired.put("I", false);
        valuesRequired.put("G", false);
        valuesRequired.put("IG", false);
        valuesRequired.put("ncat", true);
        valuesRequired.put("all-distributions", false);
        valuesRequired.put("verbose", false);
        HashMap<String, String> distributionsMap = new HashMap<String, String>(3);
        distributionsMap.put("G", "T");
        distributionsMap.put("I", "T");
        distributionsMap.put("IG", "T");
        specialArguments.put("all-distributions", distributionsMap);
        defaultProperties = new Properties();
        defaultProperties.setProperty("threads", String.valueOf(1));
        defaultProperties.setProperty("ncat", String.valueOf(4));
        defaultProperties.setProperty("sort", String.valueOf('A'));
        defaultProperties.setProperty("S", String.valueOf(0));
        defaultProperties.setProperty("sample", String.valueOf(2));
        defaultProperties.setProperty("d", "aa");
    }
}

