/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util;

import java.net.URL;
import java.util.StringTokenizer;

public class Utilities {
    public static String lastToken(String str) {
        StringTokenizer st = new StringTokenizer(str);
        String token = "";
        while (st.hasMoreTokens()) {
            token = st.nextToken();
        }
        return token;
    }

    public static String nextToken(String str, String previousToken) {
        StringTokenizer st = new StringTokenizer(str);
        String token = "";
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (!token.equals(previousToken)) continue;
            return st.nextToken();
        }
        return null;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Window");
    }

    public static long getAverage(long[] meassures) {
        double avg = 0.0;
        for (long value : meassures) {
            avg += (double)value;
        }
        return Math.round(avg /= (double)meassures.length);
    }

    public static long getMax(long[] meassures) {
        long max = Long.MIN_VALUE;
        for (long value : meassures) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static long getMin(long[] meassures) {
        long min = Long.MAX_VALUE;
        for (long value : meassures) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static String arrangeRuntime(long runTime) {
        long seconds = Math.round((double)runTime / 1000.0);
        int hours = (int)((double)seconds / 3600.0);
        int rest1 = (int)((double)seconds % 3600.0);
        int minutes = (int)((double)rest1 / 60.0);
        seconds = (int)(seconds - (long)(hours * 60 * 60 + minutes * 60));
        String h = "" + hours;
        String m = "" + minutes;
        String s = "" + seconds;
        if (minutes < 10) {
            m = "0" + m;
        }
        if (seconds < 10L) {
            s = "0" + s;
        }
        return h + "h:" + m + ":" + s + "";
    }

    public static String calculateRuntime(long startTime, long endTime) {
        return Utilities.arrangeRuntime(endTime - startTime);
    }

    public static String getPath() {
        return new Utilities().internalGetPath(false);
    }

    public static String getURLPath() {
        return new Utilities().internalGetPath(true);
    }

    private String internalGetPath(boolean withFile) {
        String j = null;
        URL tmp = null;
        try {
            tmp = this.getClass().getResource("");
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            return null;
        }
        if (tmp == null) {
            System.err.println("***************************************************************");
            System.err.println("** ERROR: Cannot find ProtTest's path, unable to run phyml!! **");
            System.err.println("***************************************************************");
            return null;
        }
        j = tmp.getPath();
        j = Utilities.replace(j, "%20", " ");
        if (!withFile) {
            j = Utilities.isWindows() ? Utilities.replace(j, "file:/", "") : Utilities.replace(j, "file:", "");
        }
        int last2 = j.lastIndexOf("!");
        j = j.substring(0, last2);
        int last = j.lastIndexOf("/");
        j = j.substring(0, last);
        return j;
    }

    public static String quoteIt(String orig) {
        String result = Utilities.replace(orig, " ", "\\ ");
        return result;
    }

    public static String replace(String orig, String from, String to) {
        StringBuffer buffer;
        boolean greaterLength;
        int fromLength = from.length();
        if (fromLength == 0) {
            throw new IllegalArgumentException("String to be replaced must not be empty");
        }
        int start = orig.indexOf(from);
        if (start == -1) {
            return orig;
        }
        boolean bl = greaterLength = to.length() >= fromLength;
        if (greaterLength) {
            if (from.equals(to)) {
                return orig;
            }
            buffer = new StringBuffer(orig.length());
        } else {
            buffer = new StringBuffer();
        }
        char[] origChars = orig.toCharArray();
        int copyFrom = 0;
        while (start != -1) {
            buffer.append(origChars, copyFrom, start - copyFrom);
            buffer.append(to);
            copyFrom = start + fromLength;
            start = orig.indexOf(from, copyFrom);
        }
        buffer.append(origChars, copyFrom, origChars.length - copyFrom);
        return buffer.toString();
    }

    public static double round(double value, int decimals) {
        return (double)Math.round(value * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }
}

