/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util;

import es.uvigo.darwin.prottest.selection.InformationCriterion;
import es.uvigo.darwin.prottest.selection.model.SelectionModel;
import java.util.HashMap;
import java.util.Iterator;

public class StatFramework {
    private HashMap<String, Integer> hashSorted;
    private HashMap<Integer, String> hashSortedReverse;
    private HashMap<String, Double> hashWeights;
    private HashMap<String, Double> hashDeltas;
    private String framework;
    private String description;
    private double alphaImp = 0.0;
    private double invImp = 0.0;
    private double GIImp = 0.0;
    private double FImp = 0.0;
    private double overallAlpha = 0.0;
    private double overallInv = 0.0;
    private double overallAlphaGI = 0.0;
    private double overallInvGI = 0.0;
    private String[] names;

    public StatFramework(InformationCriterion ic, String framework, String description) {
        this.framework = framework;
        this.description = description;
        this.alphaImp = ic.getAlphaImportance();
        this.invImp = ic.getInvImportance();
        this.GIImp = ic.getAlphaInvImportance();
        this.FImp = ic.getFImportance();
        this.overallAlpha = ic.getOverallAlpha();
        this.overallInv = ic.getOverallInv();
        this.overallAlphaGI = ic.getOverallAlphaInv();
        this.overallInvGI = ic.getOverallInvAlpha();
        this.initHashes(ic, this.names);
    }

    private void initHashes(InformationCriterion ic, String[] names) {
        this.hashSorted = new HashMap();
        this.hashSortedReverse = new HashMap();
        this.hashWeights = new HashMap();
        this.hashDeltas = new HashMap();
        Iterator<SelectionModel> selectionModels = ic.allIterator();
        int position = 0;
        while (selectionModels.hasNext()) {
            SelectionModel model = selectionModels.next();
            this.hashSorted.put(model.getModel().getModelName(), new Integer(position));
            this.hashSortedReverse.put(new Integer(position), model.getModel().getModelName());
            this.hashWeights.put(model.getModel().getModelName(), new Double(model.getWeightValue()));
            this.hashDeltas.put(model.getModel().getModelName(), new Double(model.getDeltaValue()));
            ++position;
        }
    }

    public int getRanking(String modelName) {
        return this.hashSorted.get(modelName) + 1;
    }

    public double getWeight(String modelName) {
        return this.hashWeights.get(modelName);
    }

    public double getDelta(String modelName) {
        return this.hashDeltas.get(modelName);
    }

    public String getModelName(int ranking) {
        return this.hashSortedReverse.get(new Integer(ranking));
    }

    public String getFramework() {
        return this.framework;
    }

    public String getDescription() {
        return this.description;
    }

    public double getAlphaImp() {
        return this.alphaImp;
    }

    public double getInvImp() {
        return this.invImp;
    }

    public double getGIImp() {
        return this.GIImp;
    }

    public double getFImp() {
        return this.FImp;
    }

    public double getOverallAlpha() {
        return this.overallAlpha;
    }

    public double getOverallInv() {
        return this.overallInv;
    }

    public double getOverallAlphaGI() {
        return this.overallAlphaGI;
    }

    public double getOverallInvGI() {
        return this.overallInvGI;
    }
}

