/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.util;

import es.uvigo.darwin.prottest.util.printer.ProtTestFormattedOutput;
import java.io.PrintWriter;
import pal.alignment.Alignment;

public abstract class ProtTestAlignment {
    public static double calculateSampleSize(Alignment alignment, int sampleSizeMode, double customSampleSize) {
        double sampleSize = 0.0;
        if (sampleSizeMode == 5) {
            sampleSize = customSampleSize;
        } else if (sampleSizeMode == 2) {
            sampleSize = alignment.getSiteCount();
        } else if (sampleSizeMode == 3) {
            sampleSize = (double)alignment.getSiteCount() - (double)ProtTestAlignment.calculateInvariableSites(alignment, false);
        } else if (sampleSizeMode == 0 || sampleSizeMode == 1) {
            sampleSize = ProtTestAlignment.calculateShannonSampleSize(alignment, sampleSizeMode, false);
        } else if (sampleSizeMode == 4) {
            sampleSize = (double)alignment.getSiteCount() * (double)alignment.getSequenceCount();
        }
        return sampleSize;
    }

    public static int calculateInvariableSites(Alignment alignment, boolean verbose) {
        int numSites = alignment.getSiteCount();
        int numSeqs = alignment.getSequenceCount();
        int inv = 0;
        boolean tmpInv = true;
        for (int i = 0; i < numSites; ++i) {
            int tmp = ProtTestAlignment.indexOfChar(alignment.getData(0, i));
            tmpInv = true;
            for (int j = 0; j < numSeqs; ++j) {
                if (ProtTestAlignment.indexOfChar(alignment.getData(j, i)) == tmp) continue;
                j = numSeqs;
                tmpInv = false;
            }
            if (!tmpInv) continue;
            ++inv;
        }
        if (verbose) {
            System.out.println("Observed number of invariant sites: " + inv);
        }
        return inv;
    }

    public static double calculateShannonSampleSize(Alignment alignment, int sampleSizeMode, boolean verbose) {
        int j;
        int i;
        int numSites = alignment.getSiteCount();
        int numSeqs = alignment.getSequenceCount();
        double[][] freqs = new double[numSites][20];
        byte[][] state = new byte[numSites][20];
        double[] siteS = new double[numSites];
        int[] sequences = new int[numSites];
        double shannonEntropy = 0.0;
        if (verbose) {
            System.err.println("Num sites= " + numSites + "; Num seqs= " + numSeqs);
        }
        for (i = 0; i < numSites; ++i) {
            for (j = 0; j < numSeqs; ++j) {
                int index = ProtTestAlignment.indexOfChar(alignment.getData(j, i));
                if (index < 0) continue;
                byte[] byArray = state[i];
                int n = index;
                byArray[n] = (byte)(byArray[n] + 1);
                int n2 = i;
                sequences[n2] = sequences[n2] + 1;
            }
        }
        for (i = 0; i < numSites; ++i) {
            for (j = 0; j < 20; ++j) {
                freqs[i][j] = (double)state[i][j] / (double)sequences[i];
                if (freqs[i][j] > 0.0) {
                    int n = i;
                    siteS[n] = siteS[n] + freqs[i][j] * Math.log(freqs[i][j]) / Math.log(2.0);
                }
                if (!verbose) continue;
                System.out.println("[DEBUG] Math.log(freqs): " + Math.log(freqs[i][j]) + "  ///  freqs: " + i + "-" + j + ": " + freqs[i][j]);
            }
            if (!verbose) continue;
            System.out.println("[DEBUG] siteS[" + i + "]: " + siteS[i]);
        }
        for (i = 0; i < numSites; ++i) {
            shannonEntropy += siteS[i];
        }
        if (verbose) {
            for (int seq = 0; seq < numSeqs; ++seq) {
                System.err.println(alignment.getAlignedSequenceString(seq));
            }
            for (double y = -4.0; y <= 0.0; y += 0.5) {
                for (int site = 0; site < numSites; ++site) {
                    if (siteS[site] <= y) {
                        System.err.print("|");
                        continue;
                    }
                    System.err.print(" ");
                }
                System.err.println("");
            }
        }
        if (verbose) {
            for (int i2 = 0; i2 < numSites; ++i2) {
                System.out.print("[DEBUG] Position: " + i2);
                for (j = 0; j < 20; ++j) {
                    System.out.print("\t" + state[i2][j]);
                }
                System.out.println("");
            }
        }
        if (sampleSizeMode == 0) {
            return -1.0 * shannonEntropy;
        }
        double maxShannonEntropy = 0.0;
        double normalizedShannonEntropy = 0.0;
        double meanShannonEntropy = -1.0 * shannonEntropy / (double)numSites;
        for (int i3 = 0; i3 < 20; ++i3) {
            maxShannonEntropy += 0.05 * Math.log(0.05) / Math.log(2.0);
        }
        normalizedShannonEntropy = -1.0 * meanShannonEntropy / maxShannonEntropy;
        if (verbose) {
            System.err.println("[DEBUG] Max S=" + maxShannonEntropy + "; Mean S=" + meanShannonEntropy + "; Normalized S=" + normalizedShannonEntropy);
        }
        return (double)numSites * (double)numSeqs * normalizedShannonEntropy;
    }

    public static double[] getFrequencies(Alignment alignment) {
        int i;
        int numSites = alignment.getSiteCount();
        int numSeqs = alignment.getSequenceCount();
        double[] freqs = new double[20];
        int[] aas = new int[20];
        int total_aas = 0;
        for (i = 0; i < 20; ++i) {
            aas[i] = 0;
        }
        for (i = 0; i < numSites; ++i) {
            for (int j = 0; j < numSeqs; ++j) {
                int index = ProtTestAlignment.indexOfChar(alignment.getData(j, i));
                if (index < 0) continue;
                int n = index;
                aas[n] = aas[n] + 1;
                ++total_aas;
            }
        }
        for (i = 0; i < 20; ++i) {
            freqs[i] = (double)aas[i] / (double)total_aas;
        }
        return freqs;
    }

    public static void printFrequencies(double[] freqs, PrintWriter out) {
        out.println("Observed aminoacid frequencies:");
        for (int i = 0; i < 20; ++i) {
            char aa = ProtTestAlignment.charOfIndex(i);
            out.print(" " + aa + ": " + ProtTestFormattedOutput.getDecimalString(freqs[i], 3) + "   ");
            if ((i + 1) % 5 != 0) continue;
            out.println("");
        }
    }

    public static char charOfIndex(int c) {
        char[] charSet = new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'Y'};
        if (c >= 0 && c <= charSet.length) {
            return charSet[c];
        }
        return '?';
    }

    private static int indexOfChar(char c) {
        char[] charSet = new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'Y'};
        for (int charIndex = 0; charIndex < charSet.length; ++charIndex) {
            if (charSet[charIndex] != c) continue;
            return charIndex;
        }
        return -1;
    }
}

