/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.tree;

import es.uvigo.darwin.prottest.tree.TreeUtils;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.util.Hashtable;
import pal.tree.Tree;

public class TreeDistancesCache {
    public static final int EUCLIDEAN = 1;
    public static final int ROBINSON_FOULDS = 2;
    private Hashtable<TreePair, Double> distances;
    private int distanceType;

    public int getDistanceType() {
        return this.distanceType;
    }

    public TreeDistancesCache(int distanceType) {
        if (distanceType != 1 && distanceType != 2) {
            throw new ProtTestInternalException("Unsupported distance type");
        }
        this.distanceType = distanceType;
        this.distances = new Hashtable();
    }

    public double getDistance(Tree t1, Tree t2) {
        double distance = 0.0;
        TreePair tp = new TreePair(t1, t2);
        if (this.distances.containsKey(tp)) {
            distance = this.distances.get(tp);
        } else {
            switch (this.distanceType) {
                case 1: {
                    distance = TreeUtils.euclideanTreeDistance(t1, t2);
                    break;
                }
                case 2: {
                    distance = TreeUtils.robinsonFouldsTreeDistance(t1, t2);
                }
            }
            this.distances.put(tp, distance);
        }
        return distance;
    }

    private class TreePair {
        private Tree t1;
        private Tree t2;

        public TreePair(Tree t1, Tree t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.t1 == null ? 0 : this.t1.hashCode());
            result = 31 * result + (this.t2 == null ? 0 : this.t2.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TreePair other = (TreePair)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.t1 == null ? other.t1 != null : !this.t1.equals(other.t1)) {
                return false;
            }
            return !(this.t2 == null ? other.t2 != null : !this.t2.equals(other.t2));
        }

        private TreeDistancesCache getOuterType() {
            return TreeDistancesCache.this;
        }
    }
}

