/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.taxa;

import es.uvigo.darwin.prottest.taxa.TaxonomicLevel;
import es.uvigo.darwin.prottest.util.attributable.Attributable;
import es.uvigo.darwin.prottest.util.attributable.AttributableHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Taxon
implements Attributable,
Comparable {
    private AttributableHelper helper = null;
    private final String name;
    private static Map<String, Taxon> taxa = new HashMap<String, Taxon>();
    private final TaxonomicLevel taxonomicLevel;

    private Taxon(String name) {
        this(name, null);
    }

    private Taxon(String name, TaxonomicLevel taxonomicLevel) {
        this.name = name;
        this.taxonomicLevel = taxonomicLevel;
    }

    public String getName() {
        return this.name;
    }

    public TaxonomicLevel getTaxonomicLevel() {
        return this.taxonomicLevel;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.helper == null) {
            this.helper = new AttributableHelper();
        }
        this.helper.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.helper == null) {
            return null;
        }
        return this.helper.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.helper != null) {
            this.helper.removeAttribute(name);
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        if (this.helper == null) {
            return Collections.emptySet();
        }
        return this.helper.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        if (this.helper == null) {
            return Collections.emptyMap();
        }
        return this.helper.getAttributeMap();
    }

    public static Set<Taxon> getAllTaxa() {
        return Collections.unmodifiableSet(new HashSet<Taxon>(taxa.values()));
    }

    public static Taxon getTaxon(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Illegal null string for taxon name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Illegal empty string for taxon name");
        }
        Taxon taxon = taxa.get(name);
        if (taxon == null) {
            taxon = new Taxon(name);
            taxa.put(name, taxon);
        }
        return taxon;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((Taxon)o).getName());
    }

    public boolean equals(Taxon t) {
        return this.name.equals(t.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

