/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.selection.printer;

import es.uvigo.darwin.prottest.global.ApplicationGlobals;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.selection.AIC;
import es.uvigo.darwin.prottest.selection.AICc;
import es.uvigo.darwin.prottest.selection.BIC;
import es.uvigo.darwin.prottest.selection.InformationCriterion;
import es.uvigo.darwin.prottest.util.ProtTestAlignment;
import es.uvigo.darwin.prottest.util.StatFramework;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.comparator.LKComparator;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogger;
import es.uvigo.darwin.prottest.util.printer.ProtTestFormattedOutput;
import java.util.Collections;

public abstract class PrintFramework {
    private static final double NO_SAMPLE_SIZE = 0.0;

    public final void printModelsSorted(InformationCriterion informationCriterion) {
        int fieldLength = 15;
        int numberOfFields = 5;
        int lineLength = fieldLength * numberOfFields;
        Model bestModel = informationCriterion.getBestModel();
        ModelCollection models = informationCriterion.getModelCollection();
        String[] columns = new String[]{"Model", "delta" + informationCriterion.getCriterionName(), informationCriterion.getCriterionName(), informationCriterion.getCriterionName() + "w", "-lnL"};
        PrintFramework.println("");
        PrintFramework.println(ProtTestFormattedOutput.space(lineLength, '*'));
        PrintFramework.println("Best model according to " + informationCriterion.getCriterionName() + ": " + bestModel.getModelName());
        PrintFramework.println("Sample Size:         " + informationCriterion.getSampleSize());
        double confPercent = informationCriterion.getConfidenceInterval() * 100.0;
        PrintFramework.println("Confidence Interval: " + confPercent);
        PrintFramework.println(ProtTestFormattedOutput.space(lineLength, '*'));
        for (int i = 0; i < numberOfFields; ++i) {
            PrintFramework.print(columns[i]);
            PrintFramework.print(ProtTestFormattedOutput.space(fieldLength - columns[i].length(), ' '));
        }
        PrintFramework.println("");
        PrintFramework.println(ProtTestFormattedOutput.space(lineLength, '-'));
        for (Model model : models) {
            PrintFramework.print(model.getModelName());
            PrintFramework.print(ProtTestFormattedOutput.space(fieldLength - model.getModelName().length(), ' '));
            String decimal = ProtTestFormattedOutput.getDecimalString(informationCriterion.get(model).getDeltaValue(), 2);
            PrintFramework.print(decimal);
            PrintFramework.print(ProtTestFormattedOutput.space(fieldLength - decimal.length(), ' '));
            decimal = ProtTestFormattedOutput.getDecimalString(informationCriterion.get(model).getValue(), 2);
            PrintFramework.print(decimal);
            PrintFramework.print(ProtTestFormattedOutput.space(fieldLength - decimal.length(), ' '));
            decimal = ProtTestFormattedOutput.getDecimalString(informationCriterion.get(model).getWeightValue(), 2);
            PrintFramework.print(decimal);
            PrintFramework.print(ProtTestFormattedOutput.space(fieldLength - decimal.length(), ' '));
            decimal = ProtTestFormattedOutput.getDecimalString(model.getLk(), 2);
            PrintFramework.print(decimal);
            PrintFramework.print(ProtTestFormattedOutput.space(fieldLength - decimal.length(), ' '));
            PrintFramework.println("");
        }
        PrintFramework.println(ProtTestFormattedOutput.space(lineLength, '-'));
        PrintFramework.println(ProtTestFormattedOutput.space(lineLength, '-'));
        this.printRelativeImportance(informationCriterion);
        this.printModelAveragedEstimation(informationCriterion);
    }

    protected static void print(String text) {
        ProtTestLogger.getDefaultLogger().info(text);
    }

    protected static void println(String text) {
        ProtTestLogger.getDefaultLogger().infoln(text);
    }

    public static void printFrameworksComparison(ModelCollection models) {
        String tmp;
        double[] aic = new double[models.size()];
        double[] aicc1 = new double[models.size()];
        double[] aicc2 = new double[models.size()];
        double[] aicc3 = new double[models.size()];
        double[] bic1 = new double[models.size()];
        double[] bic2 = new double[models.size()];
        double[] bic3 = new double[models.size()];
        String[] modelNames = new String[models.size()];
        double sampleSize1 = ProtTestAlignment.calculateSampleSize(models.getAlignment(), 2, 0.0);
        double sampleSize2 = ProtTestAlignment.calculateSampleSize(models.getAlignment(), 0, 0.0);
        double sampleSize3 = ProtTestAlignment.calculateSampleSize(models.getAlignment(), 1, 0.0);
        AIC aicS1 = new AIC(models, 1.0, sampleSize1);
        AICc aiccS1 = new AICc(models, 1.0, sampleSize1);
        AICc aiccS2 = new AICc(models, 1.0, sampleSize2);
        AICc aiccS3 = new AICc(models, 1.0, sampleSize3);
        BIC bicS1 = new BIC(models, 1.0, sampleSize1);
        BIC bicS2 = new BIC(models, 1.0, sampleSize2);
        BIC bicS3 = new BIC(models, 1.0, sampleSize3);
        Collections.sort(models, new LKComparator());
        for (int i = 0; i < models.size(); ++i) {
            Model model = models.get(i);
            modelNames[i] = model.getModelName();
            aicc1[i] = aiccS1.get(model).getValue();
            bic1[i] = bicS1.get(model).getValue();
            aic[i] = aicS1.get(model).getValue();
            aicc2[i] = aiccS2.get(model).getValue();
            bic2[i] = bicS2.get(model).getValue();
            aicc3[i] = aiccS3.get(model).getValue();
            bic3[i] = bicS3.get(model).getValue();
        }
        StatFramework aicF = new StatFramework(aicS1, "AIC", "AIC");
        StatFramework aicc1F = new StatFramework(aiccS1, "AICc(1)", "second-order AIC (sample size: " + ApplicationGlobals.SIZE_MODE_NAMES[2] + ")");
        StatFramework aicc2F = new StatFramework(aiccS2, "AICc(2)", "second-order AIC (sample size: " + ApplicationGlobals.SIZE_MODE_NAMES[0] + ")");
        StatFramework aicc3F = new StatFramework(aiccS3, "AICc(3)", "second-order AIC (sample size: " + ApplicationGlobals.SIZE_MODE_NAMES[1] + ")");
        StatFramework bic1F = new StatFramework(bicS1, "BIC(1)", "BIC (sample size: " + ApplicationGlobals.SIZE_MODE_NAMES[2] + ")");
        StatFramework bic2F = new StatFramework(bicS2, "BIC(2)", "BIC (sample size: " + ApplicationGlobals.SIZE_MODE_NAMES[0] + ")");
        StatFramework bic3F = new StatFramework(bicS3, "BIC(3)", "BIC (sample size: " + ApplicationGlobals.SIZE_MODE_NAMES[1] + ")");
        PrintFramework.println(ProtTestFormattedOutput.space(100, '-'));
        PrintFramework.println("Table: Weights(Ranking) of the candidate models under the different frameworks");
        PrintFramework.println(ProtTestFormattedOutput.space(100, '-'));
        PrintFramework.println("model          AIC         AICc-1      AICc-2      AICc-3      BIC-1       BIC-2       BIC-3");
        for (int i = 0; i < models.size(); ++i) {
            String model__ = aicF.getModelName(i);
            PrintFramework.print(model__ + ProtTestFormattedOutput.space(15 - model__.length(), ' '));
            tmp = ProtTestFormattedOutput.getDecimalString(aicF.getWeight(model__), 2) + "(" + aicF.getRanking(model__) + ")";
            PrintFramework.print(ProtTestFormattedOutput.space(0 - tmp.length(), ' ') + tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
            tmp = ProtTestFormattedOutput.getDecimalString(aicc1F.getWeight(model__), 2) + "(" + aicc1F.getRanking(model__) + ")";
            PrintFramework.print(ProtTestFormattedOutput.space(0 - tmp.length(), ' ') + tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
            tmp = ProtTestFormattedOutput.getDecimalString(aicc2F.getWeight(model__), 2) + "(" + aicc2F.getRanking(model__) + ")";
            PrintFramework.print(ProtTestFormattedOutput.space(0 - tmp.length(), ' ') + tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
            tmp = ProtTestFormattedOutput.getDecimalString(aicc3F.getWeight(model__), 2) + "(" + aicc3F.getRanking(model__) + ")";
            PrintFramework.print(ProtTestFormattedOutput.space(0 - tmp.length(), ' ') + tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
            tmp = ProtTestFormattedOutput.getDecimalString(bic1F.getWeight(model__), 2) + "(" + bic1F.getRanking(model__) + ")";
            PrintFramework.print(ProtTestFormattedOutput.space(0 - tmp.length(), ' ') + tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
            tmp = ProtTestFormattedOutput.getDecimalString(bic2F.getWeight(model__), 2) + "(" + bic2F.getRanking(model__) + ")";
            PrintFramework.print(ProtTestFormattedOutput.space(0 - tmp.length(), ' ') + tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
            tmp = ProtTestFormattedOutput.getDecimalString(bic3F.getWeight(model__), 2) + "(" + bic3F.getRanking(model__) + ")";
            PrintFramework.print(ProtTestFormattedOutput.space(0 - tmp.length(), ' ') + tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
            PrintFramework.println("");
        }
        PrintFramework.println(ProtTestFormattedOutput.space(100, '-'));
        PrintFramework.println("Relative importance of");
        PrintFramework.println("parameters     AIC         AICc-1      AICc-2      AICc-3      BIC-1       BIC-2       BIC-3");
        PrintFramework.print("+G" + ProtTestFormattedOutput.space(13, ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicF.getAlphaImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc1F.getAlphaImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc2F.getAlphaImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc3F.getAlphaImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic1F.getAlphaImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic2F.getAlphaImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic3F.getAlphaImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        PrintFramework.println("");
        PrintFramework.print("+I" + ProtTestFormattedOutput.space(13, ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicF.getInvImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc1F.getInvImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc2F.getInvImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc3F.getInvImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic1F.getInvImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic2F.getInvImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic3F.getInvImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        PrintFramework.println("");
        PrintFramework.print("+I+G" + ProtTestFormattedOutput.space(11, ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicF.getGIImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc1F.getGIImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc2F.getGIImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc3F.getGIImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic1F.getGIImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic2F.getGIImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic3F.getGIImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        PrintFramework.println("");
        PrintFramework.print("+F" + ProtTestFormattedOutput.space(13, ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicF.getFImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc1F.getFImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc2F.getFImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc3F.getFImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic1F.getFImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic2F.getFImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic3F.getFImp(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        PrintFramework.println("");
        PrintFramework.println(ProtTestFormattedOutput.space(100, '-'));
        PrintFramework.println("Model-averaged estimate of");
        PrintFramework.println("parameters     AIC         AICc-1      AICc-2      AICc-3      BIC-1       BIC-2       BIC-3");
        PrintFramework.print("alpha (+G)" + ProtTestFormattedOutput.space(5, ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicF.getOverallAlpha(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc1F.getOverallAlpha(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc2F.getOverallAlpha(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc3F.getOverallAlpha(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic1F.getOverallAlpha(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic2F.getOverallAlpha(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic3F.getOverallAlpha(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        PrintFramework.println("");
        PrintFramework.print("p-inv (+I)" + ProtTestFormattedOutput.space(5, ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicF.getOverallInv(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc1F.getOverallInv(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc2F.getOverallInv(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc3F.getOverallInv(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic1F.getOverallInv(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic2F.getOverallInv(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic3F.getOverallInv(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        PrintFramework.println("");
        PrintFramework.print("alpha (+I+G)" + ProtTestFormattedOutput.space(3, ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicF.getOverallAlphaGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc1F.getOverallAlphaGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc2F.getOverallAlphaGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc3F.getOverallAlphaGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic1F.getOverallAlphaGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic2F.getOverallAlphaGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic3F.getOverallAlphaGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        PrintFramework.println("");
        PrintFramework.print("p-inv (+I+G)" + ProtTestFormattedOutput.space(3, ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicF.getOverallInvGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc1F.getOverallInvGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc2F.getOverallInvGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(aicc3F.getOverallInvGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic1F.getOverallInvGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic2F.getOverallInvGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        tmp = ProtTestFormattedOutput.getDecimalString(bic3F.getOverallInvGI(), 2);
        PrintFramework.print(tmp + ProtTestFormattedOutput.space(12 - tmp.length(), ' '));
        PrintFramework.println("");
        PrintFramework.println(ProtTestFormattedOutput.space(100, '-'));
        PrintFramework.println("AIC   : Akaike Information Criterion framework.");
        PrintFramework.println("AICc-x: Second-Order Akaike framework.");
        PrintFramework.println("BIC-x : Bayesian Information Criterion framework.");
        PrintFramework.println("AICc/BIC-1: sample size as: number of sites in the alignment                           (" + sampleSize1 + ")");
        PrintFramework.println("AICc/BIC-2: sample size as: Sum of position's Shannon Entropy over the whole alignment (" + ProtTestFormattedOutput.getDecimalString(sampleSize2, 1) + ")");
        PrintFramework.println("AICc/BIC-3: sample size as: align. length x num sequences x averaged (0-1)Sh. Entropy  (" + ProtTestFormattedOutput.getDecimalString(sampleSize3, 1) + ")");
        PrintFramework.println(ProtTestFormattedOutput.space(100, '-'));
        PrintFramework.println("");
    }

    public static String getDisplayValue(double value, String parameter, boolean existModels) {
        String toDisplay = existModels ? ProtTestFormattedOutput.getDecimalString(value, 3) : "No " + parameter + " models";
        return toDisplay;
    }

    abstract void printRelativeImportance(InformationCriterion var1);

    abstract void printModelAveragedEstimation(InformationCriterion var1);
}

