/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.selection;

import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.selection.model.SelectionModel;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import pal.alignment.Alignment;

public abstract class InformationCriterion {
    protected SelectionModel bestModel;
    protected List<SelectionModel> selectionModels;
    protected HashMap<Model, SelectionModel> hashModels;
    protected double confidenceInterval;
    protected List<SelectionModel> confidenceModels;
    protected double cumWeight;
    protected double overallAlpha = 0.0;
    protected double overallInv = 0.0;
    protected double overallAlphaInv = 0.0;
    protected double overallInvAlpha = 0.0;
    protected double alphaImportance = 0.0;
    protected double invImportance = 0.0;
    protected double alphaInvImportance = 0.0;
    protected double fImportance = 0.0;
    protected double sampleSize;
    protected Alignment alignment;
    private boolean existInvModels = false;
    private boolean existGammaModels = false;
    private boolean existGammaInvModels = false;
    private boolean existFModels = false;

    public boolean isExistFModels() {
        return this.existFModels;
    }

    public boolean isExistGammaInvModels() {
        return this.existGammaInvModels;
    }

    public boolean isExistGammaModels() {
        return this.existGammaModels;
    }

    public boolean isExistInvModels() {
        return this.existInvModels;
    }

    public double getOverallAlpha() {
        return this.overallAlpha;
    }

    public double getOverallInv() {
        return this.overallInv;
    }

    public double getOverallAlphaInv() {
        return this.overallAlphaInv;
    }

    public double getOverallInvAlpha() {
        return this.overallInvAlpha;
    }

    public double getAlphaImportance() {
        return this.alphaImportance;
    }

    public double getInvImportance() {
        return this.invImportance;
    }

    public double getAlphaInvImportance() {
        return this.alphaInvImportance;
    }

    public double getFImportance() {
        return this.fImportance;
    }

    public double getSampleSize() {
        return this.sampleSize;
    }

    public double getConfidenceInterval() {
        return this.confidenceInterval;
    }

    public List<SelectionModel> getSelectionModels() {
        return this.selectionModels;
    }

    public InformationCriterion(ModelCollection models, double confidenceInterval, double sampleSize) {
        this.alignment = models.getAlignment();
        this.sampleSize = sampleSize;
        int numberOfModels = models.size();
        this.confidenceInterval = confidenceInterval;
        this.hashModels = new HashMap(numberOfModels);
        this.confidenceModels = new ArrayList<SelectionModel>();
        this.selectionModels = this.getSelectionModels(models);
        Collections.sort(this.selectionModels);
        for (Model model : models) {
            if (!this.existInvModels && model.isInv() && !model.isGamma()) {
                this.existInvModels = true;
                continue;
            }
            if (!this.existGammaModels && !model.isInv() && model.isGamma()) {
                this.existGammaModels = true;
                continue;
            }
            if (!this.existGammaInvModels && model.isInv() && model.isGamma()) {
                this.existGammaInvModels = true;
                continue;
            }
            if (this.existFModels || !model.isPlusF()) continue;
            this.existFModels = true;
        }
        this.compute();
    }

    protected abstract List<SelectionModel> getSelectionModels(List<Model> var1);

    private void compute() {
        this.bestModel = this.selectionModels.get(0);
        double minValue = this.bestModel.getValue();
        double sumExp = 0.0;
        for (SelectionModel model : this.selectionModels) {
            model.setDeltaValue(model.getValue() - minValue);
            sumExp += Math.exp(-0.5 * model.getDeltaValue());
        }
        for (SelectionModel model : this.selectionModels) {
            if (model.getDeltaValue() > 1000.0) {
                model.setWeightValue(0.0);
                continue;
            }
            model.setWeightValue(Math.exp(-0.5 * model.getDeltaValue()) / sumExp);
        }
        double cum = 0.0;
        this.alphaImportance = 0.0;
        this.invImportance = 0.0;
        this.alphaInvImportance = 0.0;
        this.fImportance = 0.0;
        this.overallAlpha = 0.0;
        this.overallInv = 0.0;
        this.overallAlphaInv = 0.0;
        this.overallInvAlpha = 0.0;
        for (SelectionModel model : this.selectionModels) {
            model.setCumulativeWeightValue(cum += model.getWeightValue());
            if (model.getModel().isGamma() && model.getModel().isInv()) {
                this.alphaInvImportance += model.getWeightValue();
                this.overallAlphaInv += model.getWeightValue() * model.getModel().getAlpha();
                this.overallInvAlpha += model.getWeightValue() * model.getModel().getInv();
            } else if (model.getModel().isGamma()) {
                this.alphaImportance += model.getWeightValue();
                this.overallAlpha += model.getWeightValue() * model.getModel().getAlpha();
            } else if (model.getModel().isInv()) {
                this.invImportance += model.getWeightValue();
                this.overallInv += model.getWeightValue() * model.getModel().getInv();
            }
            if (!model.getModel().isPlusF()) continue;
            this.fImportance += model.getWeightValue();
        }
        this.overallAlpha /= this.alphaImportance;
        this.overallInv /= this.invImportance;
        this.overallInvAlpha /= this.alphaInvImportance;
        this.overallAlphaInv /= this.alphaInvImportance;
        this.buildConfidenceInterval();
    }

    public void buildConfidenceInterval() {
        this.confidenceModels = new ArrayList<SelectionModel>();
        if (this.confidenceInterval >= 1.0) {
            for (SelectionModel model : this.selectionModels) {
                model.setInConfidenceInterval(true);
                this.confidenceModels.add(model);
            }
            this.cumWeight = 1.0;
        } else {
            this.cumWeight = 0.0;
            SelectionModel lastModel = null;
            for (SelectionModel model : this.selectionModels) {
                if (model.getCumulativeWeightValue() <= this.confidenceInterval) {
                    this.confidenceModels.add(model);
                    this.cumWeight += model.getWeightValue();
                    continue;
                }
                lastModel = model;
                break;
            }
            double probOut = (lastModel.getCumulativeWeightValue() - this.confidenceInterval) / lastModel.getWeightValue();
            double probIn = 1.0 - probOut;
            Random generator = new Random();
            double randomNumber = generator.nextDouble();
            if (randomNumber <= probIn) {
                lastModel.setInConfidenceInterval(true);
                this.confidenceModels.add(lastModel);
                this.cumWeight += lastModel.getWeightValue();
            } else {
                lastModel.setInConfidenceInterval(false);
            }
        }
    }

    public Iterator<SelectionModel> allIterator() {
        return this.selectionModels.iterator();
    }

    public Collection<SelectionModel> getConfidenceModels() {
        return this.confidenceModels;
    }

    public ModelCollection getModelCollection() {
        SingleModelCollection models = new SingleModelCollection(this.alignment);
        for (SelectionModel model : this.confidenceModels) {
            models.add(model.getModel());
        }
        return models;
    }

    public SelectionModel get(int index) {
        return this.selectionModels.get(index);
    }

    public SelectionModel get(Model model) {
        return this.hashModels.get(model);
    }

    public Model getBestModel() {
        return this.bestModel.getModel();
    }

    public abstract String getCriterionName();
}

