/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.selection;

import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.selection.BIC;
import es.uvigo.darwin.prottest.selection.InformationCriterion;
import es.uvigo.darwin.prottest.selection.model.DTSelectionModel;
import es.uvigo.darwin.prottest.selection.model.SelectionModel;
import es.uvigo.darwin.prottest.tree.TreeDistancesCache;
import es.uvigo.darwin.prottest.tree.TreeEuclideanDistancesCache;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DT
extends InformationCriterion {
    private BIC bic;
    private TreeDistancesCache distancesCache;

    public DT(ModelCollection models, double confidenceInterval, double sampleSize) {
        super(models, confidenceInterval, sampleSize);
        Collections.sort(this.selectionModels);
    }

    @Override
    protected List<SelectionModel> getSelectionModels(List<Model> models) {
        SingleModelCollection modelCollection = new SingleModelCollection(models.toArray(new Model[0]), this.alignment);
        this.bic = new BIC(modelCollection, this.confidenceInterval, this.sampleSize);
        this.distancesCache = TreeEuclideanDistancesCache.getInstance();
        ArrayList<SelectionModel> list = new ArrayList<SelectionModel>();
        for (Model model : models) {
            DTSelectionModel toAdd = new DTSelectionModel(model, this.sampleSize, this.bic, this.distancesCache);
            list.add(toAdd);
            this.hashModels.put(model, toAdd);
        }
        return list;
    }

    @Override
    public String getCriterionName() {
        return "DT";
    }
}

